/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.exchange.source;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.db.queryengine.execution.exchange.MPPDataExchangeManager;
import org.apache.iotdb.db.queryengine.execution.exchange.SharedTsBlockQueue;
import org.apache.iotdb.db.queryengine.execution.exchange.source.ISourceHandle;
import org.apache.iotdb.db.queryengine.metric.DataExchangeCostMetricSet;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.TsBlockSerde;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSourceHandle
implements ISourceHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalSourceHandle.class);
    private TFragmentInstanceId localFragmentInstanceId;
    private String localPlanNodeId;
    private final MPPDataExchangeManager.SourceHandleListener sourceHandleListener;
    protected final SharedTsBlockQueue queue;
    private boolean aborted = false;
    private boolean closed = false;
    private int currSequenceId;
    private final String threadName;
    private static final TsBlockSerde serde = new TsBlockSerde();
    private static final DataExchangeCostMetricSet DATA_EXCHANGE_COST_METRIC_SET = DataExchangeCostMetricSet.getInstance();
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(LocalSourceHandle.class) + RamUsageEstimator.shallowSizeOfInstance(TFragmentInstanceId.class) + RamUsageEstimator.shallowSizeOfInstance(SharedTsBlockQueue.class);

    public LocalSourceHandle(SharedTsBlockQueue queue, MPPDataExchangeManager.SourceHandleListener sourceHandleListener, String threadName) {
        this.queue = (SharedTsBlockQueue)Validate.notNull((Object)queue, (String)"queue can not be null.", (Object[])new Object[0]);
        this.queue.setSourceHandle(this);
        this.sourceHandleListener = (MPPDataExchangeManager.SourceHandleListener)Validate.notNull((Object)sourceHandleListener, (String)"sourceHandleListener can not be null.", (Object[])new Object[0]);
        this.threadName = threadName;
    }

    public LocalSourceHandle(TFragmentInstanceId localFragmentInstanceId, String localPlanNodeId, SharedTsBlockQueue queue, MPPDataExchangeManager.SourceHandleListener sourceHandleListener) {
        this.localFragmentInstanceId = (TFragmentInstanceId)Validate.notNull((Object)localFragmentInstanceId, (String)"localFragmentInstanceId can not be null.", (Object[])new Object[0]);
        this.localPlanNodeId = (String)Validate.notNull((Object)localPlanNodeId, (String)"localPlanNodeId can not be null.", (Object[])new Object[0]);
        this.queue = (SharedTsBlockQueue)Validate.notNull((Object)queue, (String)"queue can not be null.", (Object[])new Object[0]);
        this.queue.setSourceHandle(this);
        this.sourceHandleListener = (MPPDataExchangeManager.SourceHandleListener)Validate.notNull((Object)sourceHandleListener, (String)"sourceHandleListener can not be null.", (Object[])new Object[0]);
        this.threadName = MPPDataExchangeManager.createFullIdFrom(localFragmentInstanceId, localPlanNodeId);
    }

    @Override
    public TFragmentInstanceId getLocalFragmentInstanceId() {
        return this.localFragmentInstanceId;
    }

    @Override
    public String getLocalPlanNodeId() {
        return this.localPlanNodeId;
    }

    @Override
    public long getBufferRetainedSizeInBytes() {
        return this.queue.getBufferRetainedSizeInBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TsBlock receive() {
        long startTime = System.nanoTime();
        try {
            SetThreadName sourceHandleName = new SetThreadName(this.threadName);
            try {
                TsBlock tsBlock;
                this.checkState();
                if (!this.queue.isBlocked().isDone()) {
                    throw new IllegalStateException("Source handle is blocked.");
                }
                SharedTsBlockQueue sharedTsBlockQueue = this.queue;
                synchronized (sharedTsBlockQueue) {
                    tsBlock = this.queue.remove();
                }
                if (tsBlock != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("[GetTsBlockFromQueue] TsBlock:{} size:{}", (Object)this.currSequenceId, (Object)tsBlock.getRetainedSizeInBytes());
                    }
                    ++this.currSequenceId;
                }
                this.checkAndInvokeOnFinished();
                sharedTsBlockQueue = tsBlock;
                sourceHandleName.close();
                return sharedTsBlockQueue;
            }
            catch (Throwable throwable) {
                try {
                    sourceHandleName.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            DATA_EXCHANGE_COST_METRIC_SET.recordDataExchangeCost("source_handle_get_tsblock_local", System.nanoTime() - startTime);
        }
    }

    @Override
    public ByteBuffer getSerializedTsBlock() throws IoTDBException {
        TsBlock tsBlock = this.receive();
        if (tsBlock != null) {
            long startTime = System.nanoTime();
            try {
                ByteBuffer byteBuffer = serde.serialize(tsBlock);
                return byteBuffer;
            }
            catch (Exception e) {
                throw new IoTDBException((Throwable)e, TSStatusCode.TSBLOCK_SERIALIZE_ERROR.getStatusCode());
            }
            finally {
                DATA_EXCHANGE_COST_METRIC_SET.recordDataExchangeCost("source_handle_deserialize_tsblock_local", System.nanoTime() - startTime);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFinished() {
        SharedTsBlockQueue sharedTsBlockQueue = this.queue;
        synchronized (sharedTsBlockQueue) {
            return this.queue.hasNoMoreTsBlocks() && this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndInvokeOnFinished() {
        SharedTsBlockQueue sharedTsBlockQueue = this.queue;
        synchronized (sharedTsBlockQueue) {
            if (this.isFinished()) {
                LocalSourceHandle localSourceHandle = this;
                synchronized (localSourceHandle) {
                    this.sourceHandleListener.onFinished(this);
                }
            }
        }
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        this.checkState();
        return Futures.nonCancellationPropagating(this.queue.isBlocked());
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void abort() {
        try (SetThreadName sourceHandleName = new SetThreadName(this.threadName);){
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[StartAbortLocalSourceHandle]");
            }
            SharedTsBlockQueue sharedTsBlockQueue = this.queue;
            synchronized (sharedTsBlockQueue) {
                LocalSourceHandle localSourceHandle = this;
                synchronized (localSourceHandle) {
                    if (this.aborted) return;
                    if (this.closed) {
                        return;
                    }
                    this.queue.abort();
                    this.aborted = true;
                    this.sourceHandleListener.onAborted(this);
                }
            }
            if (!LOGGER.isDebugEnabled()) return;
            LOGGER.debug("[EndAbortLocalSourceHandle]");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void abort(Throwable t) {
        try (SetThreadName sourceHandleName = new SetThreadName(this.threadName);){
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[StartAbortLocalSourceHandle]");
            }
            SharedTsBlockQueue sharedTsBlockQueue = this.queue;
            synchronized (sharedTsBlockQueue) {
                LocalSourceHandle localSourceHandle = this;
                synchronized (localSourceHandle) {
                    if (this.aborted) return;
                    if (this.closed) {
                        return;
                    }
                    this.queue.abort(t);
                    this.aborted = true;
                    this.sourceHandleListener.onAborted(this);
                }
            }
            if (!LOGGER.isDebugEnabled()) return;
            LOGGER.debug("[EndAbortLocalSourceHandle]");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        try (SetThreadName sourceHandleName = new SetThreadName(this.threadName);){
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[StartCloseLocalSourceHandle]");
            }
            SharedTsBlockQueue sharedTsBlockQueue = this.queue;
            synchronized (sharedTsBlockQueue) {
                LocalSourceHandle localSourceHandle = this;
                synchronized (localSourceHandle) {
                    if (this.aborted) return;
                    if (this.closed) {
                        return;
                    }
                    this.queue.close();
                    this.closed = true;
                    this.sourceHandleListener.onFinished(this);
                }
            }
            if (!LOGGER.isDebugEnabled()) return;
            LOGGER.debug("[EndCloseLocalSourceHandle]");
            return;
        }
    }

    private void checkState() {
        if (this.aborted) {
            if (this.queue.isBlocked().isDone()) {
                try {
                    this.queue.isBlocked().get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException(e);
                }
                catch (ExecutionException e) {
                    throw new IllegalStateException(e.getCause() == null ? e : e.getCause());
                }
            }
            throw new IllegalStateException("Source handle is aborted.");
        }
        if (this.closed) {
            throw new IllegalStateException("Source Handle is closed.");
        }
    }

    public SharedTsBlockQueue getSharedTsBlockQueue() {
        return this.queue;
    }

    @Override
    public void setMaxBytesCanReserve(long maxBytesCanReserve) {
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + RamUsageEstimator.sizeOf((String)this.threadName) + RamUsageEstimator.sizeOf((String)this.localPlanNodeId);
    }
}

