/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.resource.log.PipeLogManager;
import org.apache.iotdb.commons.pipe.resource.ref.PipePhantomReferenceManager;
import org.apache.iotdb.commons.pipe.resource.snapshot.PipeSnapshotResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryManager;
import org.apache.iotdb.db.pipe.resource.ref.PipeDataNodePhantomReferenceManager;
import org.apache.iotdb.db.pipe.resource.snapshot.PipeDataNodeSnapshotResourceManager;
import org.apache.iotdb.db.pipe.resource.tsfile.PipeTsFileResourceManager;
import org.apache.iotdb.db.pipe.resource.wal.PipeWALResourceManager;
import org.apache.iotdb.db.pipe.resource.wal.hardlink.PipeWALHardlinkResourceManager;
import org.apache.iotdb.db.pipe.resource.wal.selfhost.PipeWALSelfHostResourceManager;

public class PipeDataNodeResourceManager {
    private final PipeTsFileResourceManager pipeTsFileResourceManager = new PipeTsFileResourceManager();
    private final AtomicReference<PipeWALResourceManager> pipeWALResourceManager = new AtomicReference();
    private final PipeSnapshotResourceManager pipeSnapshotResourceManager = new PipeDataNodeSnapshotResourceManager();
    private final PipeMemoryManager pipeMemoryManager = new PipeMemoryManager();
    private final PipeLogManager pipeLogManager = new PipeLogManager();
    private final PipePhantomReferenceManager pipePhantomReferenceManager = new PipeDataNodePhantomReferenceManager();

    public static PipeTsFileResourceManager tsfile() {
        return PipeResourceManagerHolder.INSTANCE.pipeTsFileResourceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PipeWALResourceManager wal() {
        if (PipeResourceManagerHolder.INSTANCE.pipeWALResourceManager.get() == null) {
            PipeDataNodeResourceManager pipeDataNodeResourceManager = PipeResourceManagerHolder.INSTANCE;
            synchronized (pipeDataNodeResourceManager) {
                if (PipeResourceManagerHolder.INSTANCE.pipeWALResourceManager.get() == null) {
                    PipeResourceManagerHolder.INSTANCE.pipeWALResourceManager.set(PipeConfig.getInstance().getPipeHardLinkWALEnabled() ? new PipeWALHardlinkResourceManager() : new PipeWALSelfHostResourceManager());
                }
            }
        }
        return PipeResourceManagerHolder.INSTANCE.pipeWALResourceManager.get();
    }

    public static PipeSnapshotResourceManager snapshot() {
        return PipeResourceManagerHolder.INSTANCE.pipeSnapshotResourceManager;
    }

    public static PipeMemoryManager memory() {
        return PipeResourceManagerHolder.INSTANCE.pipeMemoryManager;
    }

    public static PipeLogManager log() {
        return PipeResourceManagerHolder.INSTANCE.pipeLogManager;
    }

    public static PipePhantomReferenceManager ref() {
        return PipeResourceManagerHolder.INSTANCE.pipePhantomReferenceManager;
    }

    private PipeDataNodeResourceManager() {
    }

    private static class PipeResourceManagerHolder {
        private static final PipeDataNodeResourceManager INSTANCE = new PipeDataNodeResourceManager();

        private PipeResourceManagerHolder() {
        }
    }
}

