/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.metric;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALInsertNodeCache;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeWALInsertNodeCacheMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeWALInsertNodeCacheMetrics.class);
    private volatile AbstractMetricService metricService;
    private final Map<Integer, WALInsertNodeCache> cacheMap = new ConcurrentHashMap<Integer, WALInsertNodeCache>();

    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        ImmutableSet dataRegionIds = ImmutableSet.copyOf(this.cacheMap.keySet());
        for (Integer dataRegionId : dataRegionIds) {
            this.createMetrics(dataRegionId);
        }
    }

    private void createMetrics(Integer dataRegionId) {
        this.createAutoGauge(dataRegionId);
    }

    private void createAutoGauge(Integer dataRegionId) {
        this.metricService.createAutoGauge(Metric.PIPE_WAL_INSERT_NODE_CACHE_HIT_RATE.toString(), MetricLevel.IMPORTANT, (Object)this.cacheMap.get(dataRegionId), WALInsertNodeCache::getCacheHitRate, new String[]{Tag.REGION.toString(), String.valueOf(dataRegionId)});
        this.metricService.createAutoGauge(Metric.PIPE_WAL_INSERT_NODE_CACHE_HIT_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this.cacheMap.get(dataRegionId), WALInsertNodeCache::getCacheHitCount, new String[]{Tag.REGION.toString(), String.valueOf(dataRegionId)});
        this.metricService.createAutoGauge(Metric.PIPE_WAL_INSERT_NODE_CACHE_REQUEST_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this.cacheMap.get(dataRegionId), WALInsertNodeCache::getCacheRequestCount, new String[]{Tag.REGION.toString(), String.valueOf(dataRegionId)});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        ImmutableSet dataRegionIds = ImmutableSet.copyOf(this.cacheMap.keySet());
        for (Integer dataRegionId : dataRegionIds) {
            this.deregister(dataRegionId);
        }
        if (!this.cacheMap.isEmpty()) {
            LOGGER.warn("Failed to unbind from wal insert node cache metrics, cache map not empty");
        }
    }

    private void removeMetrics(Integer dataRegionId) {
        this.removeAutoGauge(dataRegionId);
    }

    private void removeAutoGauge(Integer dataRegionId) {
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_WAL_INSERT_NODE_CACHE_HIT_RATE.toString(), new String[]{Tag.REGION.toString(), String.valueOf(dataRegionId)});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_WAL_INSERT_NODE_CACHE_HIT_COUNT.toString(), new String[]{Tag.REGION.toString(), String.valueOf(dataRegionId)});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_WAL_INSERT_NODE_CACHE_REQUEST_COUNT.toString(), new String[]{Tag.REGION.toString(), String.valueOf(dataRegionId)});
    }

    public void register(@NonNull WALInsertNodeCache walInsertNodeCache, Integer dataRegionId) {
        this.cacheMap.putIfAbsent(dataRegionId, walInsertNodeCache);
        if (Objects.nonNull(this.metricService)) {
            this.createMetrics(dataRegionId);
        }
    }

    public void deregister(Integer dataRegionId) {
        if (!this.cacheMap.containsKey(dataRegionId)) {
            LOGGER.warn("Failed to deregister wal insert node cache metrics, WALInsertNodeCache({}) does not exist", (Object)dataRegionId);
            return;
        }
        if (Objects.nonNull(this.metricService)) {
            this.removeMetrics(dataRegionId);
        }
        this.cacheMap.remove(dataRegionId);
    }

    public static PipeWALInsertNodeCacheMetrics getInstance() {
        return PipeWALInsertNodeCacheMetricsHolder.INSTANCE;
    }

    private PipeWALInsertNodeCacheMetrics() {
    }

    private static class PipeWALInsertNodeCacheMetricsHolder {
        private static final PipeWALInsertNodeCacheMetrics INSTANCE = new PipeWALInsertNodeCacheMetrics();

        private PipeWALInsertNodeCacheMetricsHolder() {
        }
    }
}

