/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile.parser.table;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.db.pipe.event.common.PipeInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.parser.TsFileInsertionEventParser;
import org.apache.iotdb.db.pipe.event.common.tsfile.parser.table.TsFileInsertionEventTableParserTabletIterator;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.tsfile.file.metadata.TableSchema;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.controller.CachedChunkLoaderImpl;
import org.apache.tsfile.read.controller.IChunkLoader;
import org.apache.tsfile.read.controller.IMetadataQuerier;
import org.apache.tsfile.read.controller.MetadataQuerierByFileImpl;
import org.apache.tsfile.read.query.executor.TableQueryExecutor;
import org.apache.tsfile.write.record.Tablet;

public class TsFileInsertionEventTableParser
extends TsFileInsertionEventParser {
    private final TableQueryExecutor tableQueryExecutor;
    private final Iterator<Map.Entry<String, TableSchema>> filteredTableSchemaIterator;

    public TsFileInsertionEventTableParser(File tsFile, TablePattern pattern, long startTime, long endTime, PipeTaskMeta pipeTaskMeta, PipeInsertionEvent sourceEvent) throws IOException {
        super(null, pattern, startTime, endTime, pipeTaskMeta, sourceEvent);
        try {
            this.tsFileSequenceReader = new TsFileSequenceReader(tsFile.getPath(), true, true);
            this.filteredTableSchemaIterator = this.tsFileSequenceReader.getTableSchemaMap().entrySet().stream().filter(entry -> Objects.isNull(pattern) || pattern.matchesTable((String)entry.getKey())).iterator();
            this.tableQueryExecutor = new TableQueryExecutor((IMetadataQuerier)new MetadataQuerierByFileImpl(this.tsFileSequenceReader), (IChunkLoader)new CachedChunkLoaderImpl(this.tsFileSequenceReader), TableQueryExecutor.TableQueryOrdering.DEVICE);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    @Override
    public Iterable<TabletInsertionEvent> toTabletInsertionEvents() {
        return () -> new Iterator<TabletInsertionEvent>(){
            private TsFileInsertionEventTableParserTabletIterator tabletIterator = null;

            @Override
            public boolean hasNext() {
                while (this.tabletIterator == null || !this.tabletIterator.hasNext()) {
                    if (!TsFileInsertionEventTableParser.this.filteredTableSchemaIterator.hasNext()) {
                        TsFileInsertionEventTableParser.this.close();
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)TsFileInsertionEventTableParser.this.filteredTableSchemaIterator.next();
                    try {
                        this.tabletIterator = new TsFileInsertionEventTableParserTabletIterator(TsFileInsertionEventTableParser.this.tableQueryExecutor, (String)entry.getKey(), (TableSchema)entry.getValue(), TsFileInsertionEventTableParser.this.startTime, TsFileInsertionEventTableParser.this.endTime);
                    }
                    catch (Exception e) {
                        TsFileInsertionEventTableParser.this.close();
                        throw new PipeException("failed to create TsFileInsertionDataTabletIterator", (Throwable)e);
                    }
                }
                return true;
            }

            @Override
            public TabletInsertionEvent next() {
                PipeRawTabletInsertionEvent next;
                if (!this.hasNext()) {
                    TsFileInsertionEventTableParser.this.close();
                    throw new NoSuchElementException();
                }
                Tablet tablet = this.tabletIterator.next();
                if (!this.hasNext()) {
                    next = new PipeRawTabletInsertionEvent(Boolean.TRUE, TsFileInsertionEventTableParser.this.sourceEvent != null ? TsFileInsertionEventTableParser.this.sourceEvent.getTreeModelDatabaseName() : null, tablet, true, TsFileInsertionEventTableParser.this.sourceEvent != null ? TsFileInsertionEventTableParser.this.sourceEvent.getPipeName() : null, TsFileInsertionEventTableParser.this.sourceEvent != null ? TsFileInsertionEventTableParser.this.sourceEvent.getCreationTime() : 0L, TsFileInsertionEventTableParser.this.pipeTaskMeta, TsFileInsertionEventTableParser.this.sourceEvent, true);
                    TsFileInsertionEventTableParser.this.close();
                } else {
                    next = new PipeRawTabletInsertionEvent(Boolean.TRUE, TsFileInsertionEventTableParser.this.sourceEvent != null ? TsFileInsertionEventTableParser.this.sourceEvent.getTreeModelDatabaseName() : null, tablet, true, TsFileInsertionEventTableParser.this.sourceEvent != null ? TsFileInsertionEventTableParser.this.sourceEvent.getPipeName() : null, TsFileInsertionEventTableParser.this.sourceEvent != null ? TsFileInsertionEventTableParser.this.sourceEvent.getCreationTime() : 0L, TsFileInsertionEventTableParser.this.pipeTaskMeta, TsFileInsertionEventTableParser.this.sourceEvent, false);
                }
                return next;
            }
        };
    }
}

