/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift.sync;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.connector.client.IoTDBSyncClient;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferFilePieceReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferPlanNodeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferSchemaSnapshotPieceReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferSchemaSnapshotSealReq;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.sync.IoTDBDataNodeSyncConnector;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionSnapshotEvent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionWritePlanEvent;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBSchemaRegionConnector
extends IoTDBDataNodeSyncConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBSchemaRegionConnector.class);

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        throw new UnsupportedOperationException("IoTDBSchemaRegionConnector can't transfer TabletInsertionEvent.");
    }

    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        throw new UnsupportedOperationException("IoTDBSchemaRegionConnector can't transfer TsFileInsertionEvent.");
    }

    public void transfer(Event event) throws Exception {
        if (event instanceof PipeSchemaRegionWritePlanEvent) {
            this.doTransferWrapper((PipeSchemaRegionWritePlanEvent)event);
        } else if (event instanceof PipeSchemaRegionSnapshotEvent) {
            this.doTransferWrapper((PipeSchemaRegionSnapshotEvent)event);
        } else if (!(event instanceof PipeHeartbeatEvent)) {
            LOGGER.warn("IoTDBSchemaRegionConnector does not support transferring generic event: {}.", (Object)event);
        }
    }

    private void doTransferWrapper(PipeSchemaRegionWritePlanEvent pipeSchemaRegionWritePlanEvent) throws PipeException {
        if (!pipeSchemaRegionWritePlanEvent.increaseReferenceCount(IoTDBDataNodeSyncConnector.class.getName())) {
            return;
        }
        try {
            this.doTransfer(pipeSchemaRegionWritePlanEvent);
        }
        finally {
            pipeSchemaRegionWritePlanEvent.decreaseReferenceCount(IoTDBDataNodeSyncConnector.class.getName(), false);
        }
    }

    private void doTransfer(PipeSchemaRegionWritePlanEvent pipeSchemaRegionWritePlanEvent) throws PipeException {
        TPipeTransferResp resp;
        Pair clientAndStatus = this.clientManager.getClient();
        try {
            TPipeTransferReq req = this.compressIfNeeded(PipeTransferPlanNodeReq.toTPipeTransferReq(pipeSchemaRegionWritePlanEvent.getPlanNode()));
            this.rateLimitIfNeeded(pipeSchemaRegionWritePlanEvent.getPipeName(), pipeSchemaRegionWritePlanEvent.getCreationTime(), ((IoTDBSyncClient)clientAndStatus.getLeft()).getEndPoint(), req.getBody().length);
            resp = ((IoTDBSyncClient)clientAndStatus.getLeft()).pipeTransfer(req);
        }
        catch (Exception e) {
            clientAndStatus.setRight((Object)false);
            throw new PipeConnectionException(String.format("Network error when transfer schema region write plan %s, because %s.", new Object[]{pipeSchemaRegionWritePlanEvent.getPlanNode().getType(), e.getMessage()}), (Throwable)e);
        }
        TSStatus status = resp.getStatus();
        if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && resp.getStatus().getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            this.receiverStatusHandler.handle(status, String.format("Transfer data node write plan %s error, result status %s.", new Object[]{pipeSchemaRegionWritePlanEvent.getPlanNode().getType(), status}), pipeSchemaRegionWritePlanEvent.getPlanNode().toString());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Successfully transferred schema event {}.", (Object)pipeSchemaRegionWritePlanEvent);
        }
    }

    private void doTransferWrapper(PipeSchemaRegionSnapshotEvent pipeSchemaRegionSnapshotEvent) throws PipeException, IOException {
        if (!pipeSchemaRegionSnapshotEvent.increaseReferenceCount(IoTDBSchemaRegionConnector.class.getName())) {
            return;
        }
        try {
            this.doTransfer(pipeSchemaRegionSnapshotEvent);
        }
        finally {
            pipeSchemaRegionSnapshotEvent.decreaseReferenceCount(IoTDBSchemaRegionConnector.class.getName(), false);
        }
    }

    private void doTransfer(PipeSchemaRegionSnapshotEvent snapshotEvent) throws PipeException, IOException {
        TPipeTransferResp resp;
        String pipeName = snapshotEvent.getPipeName();
        long creationTime = snapshotEvent.getCreationTime();
        File mTreeSnapshotFile = snapshotEvent.getMTreeSnapshotFile();
        File tagLogSnapshotFile = snapshotEvent.getTagLogSnapshotFile();
        Pair clientAndStatus = this.clientManager.getClient();
        this.transferFilePieces(Collections.singletonMap(new Pair((Object)pipeName, (Object)creationTime), 1.0), mTreeSnapshotFile, clientAndStatus, true);
        if (Objects.nonNull(tagLogSnapshotFile)) {
            this.transferFilePieces(Collections.singletonMap(new Pair((Object)pipeName, (Object)creationTime), 1.0), tagLogSnapshotFile, clientAndStatus, true);
        }
        try {
            TPipeTransferReq req = this.compressIfNeeded((TPipeTransferReq)PipeTransferSchemaSnapshotSealReq.toTPipeTransferReq(snapshotEvent.getTreePatternString(), mTreeSnapshotFile.getName(), mTreeSnapshotFile.length(), Objects.nonNull(tagLogSnapshotFile) ? tagLogSnapshotFile.getName() : null, Objects.nonNull(tagLogSnapshotFile) ? tagLogSnapshotFile.length() : 0L, snapshotEvent.getDatabaseName(), snapshotEvent.toSealTypeString()));
            this.rateLimitIfNeeded(snapshotEvent.getPipeName(), snapshotEvent.getCreationTime(), ((IoTDBSyncClient)clientAndStatus.getLeft()).getEndPoint(), req.getBody().length);
            resp = ((IoTDBSyncClient)clientAndStatus.getLeft()).pipeTransfer(req);
        }
        catch (Exception e) {
            clientAndStatus.setRight((Object)false);
            throw new PipeConnectionException(String.format("Network error when seal snapshot file %s and %s, because %s.", mTreeSnapshotFile, tagLogSnapshotFile, e.getMessage()), (Throwable)e);
        }
        if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && resp.getStatus().getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            this.receiverStatusHandler.handle(resp.getStatus(), String.format("Seal file %s and %s error, result status %s.", mTreeSnapshotFile, tagLogSnapshotFile, resp.getStatus()), snapshotEvent.toString());
        }
        LOGGER.info("Successfully transferred file {} and {}.", (Object)mTreeSnapshotFile, (Object)tagLogSnapshotFile);
    }

    protected PipeTransferFilePieceReq getTransferSingleFilePieceReq(String fileName, long position, byte[] payLoad) {
        throw new UnsupportedOperationException("The schema region connector does not support transferring single file piece req.");
    }

    protected PipeTransferFilePieceReq getTransferMultiFilePieceReq(String fileName, long position, byte[] payLoad) throws IOException {
        return PipeTransferSchemaSnapshotPieceReq.toTPipeTransferReq(fileName, position, payLoad);
    }
}

