/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferCompressedReq;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferFilePieceReq;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.response.PipeTransferFilePieceResp;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.utils.RetryUtils;
import org.apache.iotdb.db.pipe.connector.client.IoTDBDataNodeAsyncClientManager;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTsFilePieceReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTsFilePieceWithModReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTsFileSealWithModReq;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBDataRegionAsyncConnector;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferTrackableHandler;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTransferTsFileHandler
extends PipeTransferTrackableHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTransferTsFileHandler.class);
    private final Map<Pair<String, Long>, Double> pipeName2WeightMap;
    private final List<EnrichedEvent> events;
    private final AtomicInteger eventsReferenceCount;
    private final AtomicBoolean eventsHadBeenAddedToRetryQueue;
    private final File tsFile;
    private final File modFile;
    private File currentFile;
    private final boolean transferMod;
    private final String dataBaseName;
    private final int readFileBufferSize;
    private final byte[] readBuffer;
    private long position;
    private RandomAccessFile reader;
    private final AtomicBoolean isSealSignalSent;
    private IoTDBDataNodeAsyncClientManager clientManager;
    private AsyncPipeDataTransferServiceClient client;

    public PipeTransferTsFileHandler(IoTDBDataRegionAsyncConnector connector, Map<Pair<String, Long>, Double> pipeName2WeightMap, List<EnrichedEvent> events, AtomicInteger eventsReferenceCount, AtomicBoolean eventsHadBeenAddedToRetryQueue, File tsFile, File modFile, boolean transferMod, String dataBaseName) throws FileNotFoundException {
        super(connector);
        this.pipeName2WeightMap = pipeName2WeightMap;
        this.events = events;
        this.eventsReferenceCount = eventsReferenceCount;
        this.eventsHadBeenAddedToRetryQueue = eventsHadBeenAddedToRetryQueue;
        this.tsFile = tsFile;
        this.modFile = modFile;
        this.transferMod = transferMod;
        this.dataBaseName = dataBaseName;
        this.currentFile = transferMod ? modFile : tsFile;
        this.readFileBufferSize = PipeConfig.getInstance().getPipeConnectorReadFileBufferSize();
        this.readBuffer = new byte[this.readFileBufferSize];
        this.position = 0L;
        this.reader = Objects.nonNull(modFile) ? new RandomAccessFile(modFile, "r") : new RandomAccessFile(tsFile, "r");
        this.isSealSignalSent = new AtomicBoolean(false);
    }

    public void transfer(IoTDBDataNodeAsyncClientManager clientManager, AsyncPipeDataTransferServiceClient client) throws TException, IOException {
        this.clientManager = clientManager;
        this.client = client;
        client.setShouldReturnSelf(false);
        client.setTimeoutDynamically(clientManager.getConnectionTimeout());
        int readLength = this.reader.read(this.readBuffer);
        if (readLength == -1) {
            if (this.currentFile == this.modFile) {
                this.currentFile = this.tsFile;
                this.position = 0L;
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to close file reader when successfully transferred mod file.", (Throwable)e);
                }
                this.reader = new RandomAccessFile(this.tsFile, "r");
                this.transfer(clientManager, client);
            } else if (this.currentFile == this.tsFile) {
                this.isSealSignalSent.set(true);
                PipeTransferTsFileSealWithModReq uncompressedReq = this.transferMod ? PipeTransferTsFileSealWithModReq.toTPipeTransferReq(this.modFile.getName(), this.modFile.length(), this.tsFile.getName(), this.tsFile.length(), this.dataBaseName) : PipeTransferTsFileSealWithModReq.toTPipeTransferReq(this.tsFile.getName(), this.tsFile.length(), this.dataBaseName);
                PipeTransferTsFileSealWithModReq req = this.connector.isRpcCompressionEnabled() ? PipeTransferCompressedReq.toTPipeTransferReq((TPipeTransferReq)uncompressedReq, (List)this.connector.getCompressors()) : uncompressedReq;
                this.pipeName2WeightMap.forEach((arg_0, arg_1) -> this.lambda$transfer$0(client, (TPipeTransferReq)req, arg_0, arg_1));
                if (!this.tryTransfer(client, (TPipeTransferReq)req)) {
                    return;
                }
            }
            return;
        }
        byte[] payload = readLength == this.readFileBufferSize ? this.readBuffer : Arrays.copyOfRange(this.readBuffer, 0, readLength);
        PipeTransferFilePieceReq uncompressedReq = this.transferMod ? PipeTransferTsFilePieceWithModReq.toTPipeTransferReq(this.currentFile.getName(), this.position, payload) : PipeTransferTsFilePieceReq.toTPipeTransferReq(this.currentFile.getName(), this.position, payload);
        PipeTransferFilePieceReq req = this.connector.isRpcCompressionEnabled() ? PipeTransferCompressedReq.toTPipeTransferReq((TPipeTransferReq)uncompressedReq, (List)this.connector.getCompressors()) : uncompressedReq;
        this.pipeName2WeightMap.forEach((arg_0, arg_1) -> this.lambda$transfer$1(client, (TPipeTransferReq)req, arg_0, arg_1));
        if (!this.tryTransfer(client, (TPipeTransferReq)req)) {
            return;
        }
        this.position += (long)readLength;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean onCompleteInternal(TPipeTransferResp response) {
        if (this.isSealSignalSent.get()) {
            int referenceCount;
            block22: {
                try {
                    TSStatus status = response.getStatus();
                    if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                        this.connector.statusHandler().handle(status, String.format("Seal file %s error, result status %s.", this.tsFile, response.getStatus()), this.tsFile.getName());
                    }
                }
                catch (Exception e) {
                    this.onError(e);
                    return false;
                }
                try {
                    if (this.reader != null) {
                        this.reader.close();
                    }
                    if (this.events.stream().anyMatch(event -> !(event instanceof PipeTsFileInsertionEvent))) {
                        RetryUtils.retryOnException(() -> {
                            FileUtils.delete((File)this.currentFile);
                            return null;
                        });
                    }
                    if ((referenceCount = this.eventsReferenceCount.decrementAndGet()) > 0) break block22;
                }
                catch (IOException e) {
                    int referenceCount2;
                    block23: {
                        try {
                            LOGGER.warn("Failed to close file reader or delete tsFile when successfully transferred file.", (Throwable)e);
                            referenceCount2 = this.eventsReferenceCount.decrementAndGet();
                            if (referenceCount2 > 0) break block23;
                        }
                        catch (Throwable throwable) {
                            int referenceCount3 = this.eventsReferenceCount.decrementAndGet();
                            if (referenceCount3 <= 0) {
                                this.events.forEach(event -> event.decreaseReferenceCount(PipeTransferTsFileHandler.class.getName(), true));
                            }
                            if (this.events.size() <= 1 || LOGGER.isDebugEnabled()) {
                                LOGGER.info("Successfully transferred file {} (committer key={}, commit id={}, reference count={}).", new Object[]{this.tsFile, this.events.stream().map(EnrichedEvent::getCommitterKey).collect(Collectors.toList()), this.events.stream().map(EnrichedEvent::getCommitId).collect(Collectors.toList()), referenceCount3});
                            } else {
                                LOGGER.info("Successfully transferred file {} (batched TableInsertionEvents, reference count={}).", (Object)this.tsFile, (Object)referenceCount3);
                            }
                            if (this.client == null) throw throwable;
                            this.client.setShouldReturnSelf(true);
                            this.client.returnSelf();
                            throw throwable;
                        }
                        this.events.forEach(event -> event.decreaseReferenceCount(PipeTransferTsFileHandler.class.getName(), true));
                    }
                    if (this.events.size() <= 1 || LOGGER.isDebugEnabled()) {
                        LOGGER.info("Successfully transferred file {} (committer key={}, commit id={}, reference count={}).", new Object[]{this.tsFile, this.events.stream().map(EnrichedEvent::getCommitterKey).collect(Collectors.toList()), this.events.stream().map(EnrichedEvent::getCommitId).collect(Collectors.toList()), referenceCount2});
                    } else {
                        LOGGER.info("Successfully transferred file {} (batched TableInsertionEvents, reference count={}).", (Object)this.tsFile, (Object)referenceCount2);
                    }
                    if (this.client == null) return true;
                    this.client.setShouldReturnSelf(true);
                    this.client.returnSelf();
                    return true;
                }
                this.events.forEach(event -> event.decreaseReferenceCount(PipeTransferTsFileHandler.class.getName(), true));
            }
            if (this.events.size() <= 1 || LOGGER.isDebugEnabled()) {
                LOGGER.info("Successfully transferred file {} (committer key={}, commit id={}, reference count={}).", new Object[]{this.tsFile, this.events.stream().map(EnrichedEvent::getCommitterKey).collect(Collectors.toList()), this.events.stream().map(EnrichedEvent::getCommitId).collect(Collectors.toList()), referenceCount});
            } else {
                LOGGER.info("Successfully transferred file {} (batched TableInsertionEvents, reference count={}).", (Object)this.tsFile, (Object)referenceCount);
            }
            if (this.client == null) return true;
            this.client.setShouldReturnSelf(true);
            this.client.returnSelf();
            return true;
        }
        try {
            PipeTransferFilePieceResp resp = PipeTransferFilePieceResp.fromTPipeTransferResp((TPipeTransferResp)response);
            long code = resp.getStatus().getCode();
            if (code == (long)TSStatusCode.PIPE_TRANSFER_FILE_OFFSET_RESET.getStatusCode()) {
                this.position = resp.getEndWritingOffset();
                this.reader.seek(this.position);
                LOGGER.info("Redirect file position to {}.", (Object)this.position);
            } else {
                TSStatus status = response.getStatus();
                if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                    this.connector.statusHandler().handle(status, response.getStatus().getMessage(), this.tsFile.getName());
                }
            }
            this.transfer(this.clientManager, this.client);
            return false;
        }
        catch (Exception e) {
            this.onError(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onErrorInternal(Exception exception) {
        try {
            if (this.events.size() <= 1 || LOGGER.isDebugEnabled()) {
                LOGGER.warn("Failed to transfer TsFileInsertionEvent {} (committer key {}, commit id {}).", new Object[]{this.tsFile, this.events.stream().map(EnrichedEvent::getCommitterKey).collect(Collectors.toList()), this.events.stream().map(EnrichedEvent::getCommitId).collect(Collectors.toList()), exception});
            } else {
                LOGGER.warn("Failed to transfer TsFileInsertionEvent {} (batched TableInsertionEvents)", (Object)this.tsFile, (Object)exception);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to log error when failed to transfer file.", (Throwable)e);
        }
        try {
            if (Objects.nonNull(this.clientManager)) {
                this.clientManager.adjustTimeoutIfNecessary(exception);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to adjust timeout when failed to transfer file.", (Throwable)e);
        }
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.events.stream().anyMatch(event -> !(event instanceof PipeTsFileInsertionEvent))) {
                RetryUtils.retryOnException(() -> {
                    FileUtils.delete((File)this.currentFile);
                    return null;
                });
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to close file reader or delete tsFile when failed to transfer file.", (Throwable)e);
        }
        finally {
            try {
                if (this.client != null) {
                    this.client.setShouldReturnSelf(true);
                    this.client.returnSelf();
                }
            }
            finally {
                if (this.eventsHadBeenAddedToRetryQueue.compareAndSet(false, true)) {
                    this.connector.addFailureEventsToRetryQueue(this.events);
                }
            }
        }
    }

    @Override
    protected void doTransfer(AsyncPipeDataTransferServiceClient client, TPipeTransferReq req) throws TException {
        client.pipeTransfer(req, (AsyncMethodCallback)this);
    }

    @Override
    public void clearEventsReferenceCount() {
        this.events.forEach(event -> event.clearReferenceCount(PipeTransferTsFileHandler.class.getName()));
    }

    private /* synthetic */ void lambda$transfer$1(AsyncPipeDataTransferServiceClient client, TPipeTransferReq req, Pair pipePair, Double weight) {
        this.connector.rateLimitIfNeeded((String)pipePair.getLeft(), (Long)pipePair.getRight(), client.getEndPoint(), (long)((double)req.getBody().length * weight));
    }

    private /* synthetic */ void lambda$transfer$0(AsyncPipeDataTransferServiceClient client, TPipeTransferReq req, Pair pipePair, Double weight) {
        this.connector.rateLimitIfNeeded((String)pipePair.getLeft(), (Long)pipePair.getRight(), client.getEndPoint(), (long)((double)req.getBody().length * weight));
    }
}

