/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache.node;

import java.util.List;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.load.cache.node.BaseNodeCache;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeStatistics;

public class ConfigNodeHeartbeatCache
extends BaseNodeCache {
    public static final int CURRENT_NODE_ID = ConfigNodeDescriptor.getInstance().getConf().getConfigNodeId();
    public static final NodeStatistics CURRENT_NODE_STATISTICS = new NodeStatistics(0L, NodeStatus.Running, null, 0L);

    public ConfigNodeHeartbeatCache(int configNodeId) {
        super(configNodeId);
    }

    public ConfigNodeHeartbeatCache(int configNodeId, NodeStatistics statistics) {
        super(configNodeId);
        this.currentStatistics.set(statistics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateCurrentStatistics(boolean forceUpdate) {
        NodeHeartbeatSample lastSample;
        if (this.nodeId == CURRENT_NODE_ID || NodeStatus.Removing.equals((Object)this.getNodeStatus())) {
            return;
        }
        List list = this.slidingWindow;
        synchronized (list) {
            lastSample = (NodeHeartbeatSample)this.getLastSample();
        }
        long lastSendTime = lastSample == null ? 0L : lastSample.getSampleLogicalTimestamp();
        long currentNanoTime = System.nanoTime();
        NodeStatus status = lastSample == null ? NodeStatus.Unknown : (currentNanoTime - lastSendTime > 20000000000L ? NodeStatus.Unknown : lastSample.getStatus());
        long loadScore = NodeStatus.isNormalStatus((NodeStatus)status) ? 0L : Long.MAX_VALUE;
        this.currentStatistics.set(new NodeStatistics(currentNanoTime, status, null, loadScore));
    }
}

