/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.FunctionType;
import org.apache.iotdb.common.rpc.thrift.Model;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.udf.UDFInformation;
import org.apache.iotdb.commons.udf.UDFType;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.client.async.CnToDnInternalServiceAsyncRequestManager;
import org.apache.iotdb.confignode.client.async.handlers.DataNodeAsyncRequestContext;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.read.function.GetAllFunctionTablePlan;
import org.apache.iotdb.confignode.consensus.request.read.function.GetFunctionTablePlan;
import org.apache.iotdb.confignode.consensus.request.read.function.GetUDFJarPlan;
import org.apache.iotdb.confignode.consensus.request.write.function.CreateFunctionPlan;
import org.apache.iotdb.confignode.consensus.request.write.function.DropTableModelFunctionPlan;
import org.apache.iotdb.confignode.consensus.request.write.function.DropTreeModelFunctionPlan;
import org.apache.iotdb.confignode.consensus.request.write.function.UpdateFunctionPlan;
import org.apache.iotdb.confignode.consensus.response.JarResp;
import org.apache.iotdb.confignode.consensus.response.function.FunctionTableResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.persistence.UDFInfo;
import org.apache.iotdb.confignode.rpc.thrift.TCreateFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetUDFTableResp;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.mpp.rpc.thrift.TCreateFunctionInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TDropFunctionInstanceReq;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDFManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDFManager.class);
    private final ConfigManager configManager;
    private final UDFInfo udfInfo;
    private final long planSizeLimit = ConfigNodeDescriptor.getInstance().getConf().getConfigNodeRatisConsensusLogAppenderBufferSize() - 48L;

    public UDFManager(ConfigManager configManager, UDFInfo udfInfo) {
        this.configManager = configManager;
        this.udfInfo = udfInfo;
    }

    public UDFInfo getUdfInfo() {
        return this.udfInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus createFunction(TCreateFunctionReq req) {
        this.udfInfo.acquireUDFTableLock();
        try {
            boolean isUsingURI = req.isIsUsingURI();
            String udfName = req.udfName.toUpperCase();
            String jarMD5 = req.getJarMD5();
            String jarName = req.getJarName();
            byte[] jarFile = req.getJarFile();
            Model model = req.getModel();
            FunctionType functionType = req.getFunctionType();
            this.udfInfo.validate(model, udfName, jarName, jarMD5);
            UDFInformation udfInformation = new UDFInformation(udfName, req.getClassName(), UDFType.of((Model)model, (FunctionType)functionType, (boolean)false), isUsingURI, jarName, jarMD5);
            boolean needToSaveJar = isUsingURI && this.udfInfo.needToSaveJar(jarName);
            LOGGER.info("Start to add UDF [{}] in UDF_Table on Config Nodes", (Object)udfName);
            CreateFunctionPlan createFunctionPlan = new CreateFunctionPlan(udfInformation, needToSaveJar ? new Binary(jarFile) : null);
            if (needToSaveJar && (long)createFunctionPlan.getSerializedSize() > this.planSizeLimit) {
                TSStatus tSStatus = new TSStatus(TSStatusCode.CREATE_UDF_ERROR.getStatusCode()).setMessage(String.format("Fail to create UDF[%s], the size of Jar is too large, you can increase the value of property 'config_node_ratis_log_appender_buffer_size_max' on ConfigNode", udfName));
                return tSStatus;
            }
            TSStatus preCreateStatus = this.configManager.getConsensusManager().write(createFunctionPlan);
            if (preCreateStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus = preCreateStatus;
                return tSStatus;
            }
            udfInformation = new UDFInformation(udfName, req.getClassName(), UDFType.of((Model)model, (FunctionType)functionType, (boolean)true), isUsingURI, jarName, jarMD5);
            LOGGER.info("Start to create UDF [{}] on Data Nodes, needToSaveJar[{}]", (Object)udfName, (Object)needToSaveJar);
            TSStatus dataNodesStatus = RpcUtils.squashResponseStatusList(this.createFunctionOnDataNodes(udfInformation, (byte[])(needToSaveJar ? jarFile : null)));
            if (dataNodesStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus = dataNodesStatus;
                return tSStatus;
            }
            LOGGER.info("Start to activate UDF [{}] in UDF_Table on Config Nodes", (Object)udfName);
            TSStatus tSStatus = this.configManager.getConsensusManager().write(new UpdateFunctionPlan(udfInformation));
            return tSStatus;
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            TSStatus tSStatus = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(e.getMessage());
            return tSStatus;
        }
        finally {
            this.udfInfo.releaseUDFTableLock();
        }
    }

    private List<TSStatus> createFunctionOnDataNodes(UDFInformation udfInformation, byte[] jarFile) throws IOException {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        TCreateFunctionInstanceReq req = new TCreateFunctionInstanceReq(udfInformation.serialize()).setJarFile(jarFile);
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.CREATE_FUNCTION, req, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus dropFunction(Model model, String functionName) {
        functionName = functionName.toUpperCase();
        this.udfInfo.acquireUDFTableLock();
        try {
            UDFInformation information = this.udfInfo.getUDFInformation(model, functionName);
            information.setAvailable(false);
            TSStatus preDropStatus = this.configManager.getConsensusManager().write(new UpdateFunctionPlan(information));
            if (preDropStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus = preDropStatus;
                return tSStatus;
            }
            TSStatus result = RpcUtils.squashResponseStatusList(this.dropFunctionOnDataNodes(model, functionName));
            if (result.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus = result;
                return tSStatus;
            }
            if (Model.TREE.equals((Object)model)) {
                TSStatus tSStatus = this.configManager.getConsensusManager().write(new DropTreeModelFunctionPlan(functionName));
                return tSStatus;
            }
            TSStatus tSStatus = this.configManager.getConsensusManager().write(new DropTableModelFunctionPlan(functionName));
            return tSStatus;
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            TSStatus tSStatus = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(e.getMessage());
            return tSStatus;
        }
        finally {
            this.udfInfo.releaseUDFTableLock();
        }
    }

    private List<TSStatus> dropFunctionOnDataNodes(Model model, String functionName) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        TDropFunctionInstanceReq request = new TDropFunctionInstanceReq(functionName, false).setModel(model);
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.DROP_FUNCTION, request, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    public TGetUDFTableResp getUDFTable(Model model) {
        try {
            return ((FunctionTableResp)this.configManager.getConsensusManager().read(new GetFunctionTablePlan(model))).convertToThriftResponse();
        }
        catch (IOException | ConsensusException e) {
            LOGGER.error("Fail to get UDFTable", e);
            return new TGetUDFTableResp(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(e.getMessage()), Collections.emptyList());
        }
    }

    public TGetUDFTableResp getAllUDFTable() {
        try {
            return ((FunctionTableResp)this.configManager.getConsensusManager().read(new GetAllFunctionTablePlan())).convertToThriftResponse();
        }
        catch (IOException | ConsensusException e) {
            LOGGER.error("Fail to get AllUDFTable", e);
            return new TGetUDFTableResp(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(e.getMessage()), Collections.emptyList());
        }
    }

    public TGetJarInListResp getUDFJar(TGetJarInListReq req) {
        try {
            return ((JarResp)this.configManager.getConsensusManager().read(new GetUDFJarPlan(req.getJarNameList()))).convertToThriftResponse();
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the read API executing the consensus layer due to: ", (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return new JarResp(res, Collections.emptyList()).convertToThriftResponse();
        }
    }
}

