/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.RepairUnsortedFileCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.IInnerSeqSpaceSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.IInnerUnseqSpaceSelector;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SizeTieredCompactionSelector
implements IInnerSeqSpaceSelector,
IInnerUnseqSpaceSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    protected static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    protected String storageGroupName;
    protected String dataRegionId;
    protected long timePartition;
    protected List<TsFileResource> tsFileResources;
    protected boolean sequence;
    protected TsFileManager tsFileManager;
    protected boolean hasNextTimePartition;

    public SizeTieredCompactionSelector(String storageGroupName, String dataRegionId, long timePartition, boolean sequence, TsFileManager tsFileManager) {
        this.storageGroupName = storageGroupName;
        this.dataRegionId = dataRegionId;
        this.timePartition = timePartition;
        this.sequence = sequence;
        this.tsFileManager = tsFileManager;
        this.hasNextTimePartition = tsFileManager.hasNextTimePartition(timePartition, sequence);
    }

    private List<List<TsFileResource>> selectTsFileResourcesByLevel(int level) throws IOException {
        ArrayList<TsFileResource> selectedFileList = new ArrayList<TsFileResource>();
        long selectedFileSize = 0L;
        long targetCompactionFileSize = config.getTargetCompactionFileSize();
        int fileLimit = config.getInnerCompactionCandidateFileNum();
        ArrayList<List<TsFileResource>> taskList = new ArrayList<List<TsFileResource>>();
        for (TsFileResource currentFile : this.tsFileResources) {
            boolean canNotAddCurrentFileIntoCurrentTask;
            TsFileNameGenerator.TsFileName currentName = TsFileNameGenerator.getTsFileName(currentFile.getTsFile().getName());
            if (currentName.getInnerCompactionCnt() != level) {
                if (selectedFileList.size() > 1) {
                    taskList.add(new ArrayList(selectedFileList));
                }
                selectedFileList = new ArrayList();
                selectedFileSize = 0L;
                continue;
            }
            if (this.cannotSelectCurrentFileToNormalCompaction(currentFile)) {
                selectedFileList.clear();
                selectedFileSize = 0L;
                continue;
            }
            long totalSizeIfSelectCurrentFile = selectedFileSize + currentFile.getTsFileSize();
            boolean bl = canNotAddCurrentFileIntoCurrentTask = totalSizeIfSelectCurrentFile > targetCompactionFileSize || selectedFileList.size() >= fileLimit;
            if (canNotAddCurrentFileIntoCurrentTask) {
                if (selectedFileList.size() > 1) {
                    taskList.add(new ArrayList(selectedFileList));
                }
                selectedFileList = new ArrayList();
                selectedFileList.add(currentFile);
                selectedFileSize = currentFile.getTsFileSize();
                continue;
            }
            LOGGER.debug("Current File is {}, size is {}", (Object)currentFile, (Object)currentFile.getTsFileSize());
            selectedFileList.add(currentFile);
            LOGGER.debug("Add tsfile {}, current select file num is {}, size is {}", new Object[]{currentFile, selectedFileList.size(), selectedFileSize += currentFile.getTsFileSize()});
        }
        if (selectedFileList.size() == fileLimit) {
            taskList.add(new ArrayList(selectedFileList));
            selectedFileList.clear();
            selectedFileSize = 0L;
        }
        if (this.hasNextTimePartition && selectedFileList.size() > 1) {
            taskList.add(new ArrayList(selectedFileList));
        }
        return taskList;
    }

    private boolean cannotSelectCurrentFileToNormalCompaction(TsFileResource resource) {
        return resource.getStatus() != TsFileResourceStatus.NORMAL || !resource.getTsFileRepairStatus().isNormalCompactionCandidate();
    }

    @Override
    public List<InnerSpaceCompactionTask> selectInnerSpaceTask(List<TsFileResource> tsFileResources) {
        this.tsFileResources = tsFileResources;
        try {
            List<InnerSpaceCompactionTask> taskList = this.selectFileNeedToRepair();
            if (!taskList.isEmpty() || !CompactionUtils.isDiskHasSpace()) {
                return taskList;
            }
            return this.selectTaskBaseOnLevel();
        }
        catch (Exception e) {
            LOGGER.error("Exception occurs while selecting files", (Throwable)e);
            return Collections.emptyList();
        }
    }

    protected List<InnerSpaceCompactionTask> selectTaskBaseOnLevel() throws IOException, DiskSpaceInsufficientException {
        int maxLevel = this.searchMaxFileLevel();
        for (int currentLevel = 0; currentLevel <= maxLevel; ++currentLevel) {
            List<List<TsFileResource>> selectedResourceList = this.selectTsFileResourcesByLevel(currentLevel);
            if (selectedResourceList.isEmpty()) continue;
            return this.createCompactionTasks(selectedResourceList);
        }
        return Collections.emptyList();
    }

    private List<InnerSpaceCompactionTask> selectFileNeedToRepair() {
        if (!config.isEnableAutoRepairCompaction()) {
            return Collections.emptyList();
        }
        ArrayList<InnerSpaceCompactionTask> taskList = new ArrayList<InnerSpaceCompactionTask>();
        for (TsFileResource resource : this.tsFileResources) {
            if (resource.getStatus() != TsFileResourceStatus.NORMAL || !resource.getTsFileRepairStatus().isRepairCompactionCandidate()) continue;
            taskList.add(new RepairUnsortedFileCompactionTask(this.timePartition, this.tsFileManager, resource, this.sequence, this.tsFileManager.getNextCompactionTaskId()));
        }
        return taskList;
    }

    protected ICompactionPerformer createCompactionPerformer() {
        return this.sequence ? IoTDBDescriptor.getInstance().getConfig().getInnerSeqCompactionPerformer().createInstance() : IoTDBDescriptor.getInstance().getConfig().getInnerUnseqCompactionPerformer().createInstance();
    }

    protected int searchMaxFileLevel() throws IOException {
        int maxLevel = -1;
        for (TsFileResource currentFile : this.tsFileResources) {
            TsFileNameGenerator.TsFileName currentName = TsFileNameGenerator.getTsFileName(currentFile.getTsFile().getName());
            if (currentName.getInnerCompactionCnt() <= maxLevel) continue;
            maxLevel = currentName.getInnerCompactionCnt();
        }
        return maxLevel;
    }

    private List<InnerSpaceCompactionTask> createCompactionTasks(List<List<TsFileResource>> selectedTsFileResourceList) {
        ArrayList<InnerSpaceCompactionTask> tasks = new ArrayList<InnerSpaceCompactionTask>();
        for (List<TsFileResource> tsFileResourceList : selectedTsFileResourceList) {
            tasks.add(this.createCompactionTask(tsFileResourceList));
        }
        return tasks;
    }

    private InnerSpaceCompactionTask createCompactionTask(List<TsFileResource> fileResources) {
        return new InnerSpaceCompactionTask(this.timePartition, this.tsFileManager, fileResources, this.sequence, this.createCompactionPerformer(), this.tsFileManager.getNextCompactionTaskId());
    }
}

