/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.buffer;

import java.nio.ByteBuffer;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntry;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntryType;

public class WALSignalEntry
extends WALEntry {
    public WALSignalEntry(WALEntryType signalType) {
        this(signalType, false);
    }

    public WALSignalEntry(WALEntryType signalType, boolean wait) {
        super(signalType, Long.MIN_VALUE, null, wait);
        switch (signalType) {
            case CLOSE_SIGNAL: 
            case ROLL_WAL_LOG_WRITER_SIGNAL: 
            case WAL_FILE_INFO_END_MARKER: {
                break;
            }
            default: {
                throw new RuntimeException("Cannot use wal info type as wal signal type");
            }
        }
    }

    @Override
    public int serializedSize() {
        return 1;
    }

    @Override
    public void serialize(IWALByteBufferView buffer) {
        buffer.put(this.type.getCode());
    }

    public void serialize(ByteBuffer buffer) {
        buffer.put(this.type.getCode());
    }

    @Override
    public boolean isSignal() {
        return true;
    }

    @Override
    public long getMemorySize() {
        return 1L;
    }
}

