/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.confignode.rpc.thrift.TGetTimeSlotListResp;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.GetTimeSlotListStatement;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;

public class GetTimeSlotListTask
implements IConfigTask {
    private final GetTimeSlotListStatement getTimeSlotListStatement;

    public GetTimeSlotListTask(GetTimeSlotListStatement getTimeSlotListStatement) {
        this.getTimeSlotListStatement = getTimeSlotListStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) {
        return configTaskExecutor.getTimeSlotList(this.getTimeSlotListStatement);
    }

    public static void buildTSBlockRow(TsBlockBuilder builder, TTimePartitionSlot timePartitionSlot) {
        builder.getTimeColumnBuilder().writeLong(0L);
        builder.getColumnBuilder(0).writeLong(TimePartitionUtils.getTimePartitionId((long)timePartitionSlot.getStartTime()));
        builder.getColumnBuilder(1).writeBinary(new Binary(DateTimeUtils.convertLongToDate(timePartitionSlot.getStartTime()), TSFileConfig.STRING_CHARSET));
        builder.declarePosition();
    }

    public static void buildTSBlock(TGetTimeSlotListResp getTimeSlotListResp, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.getTimeSlotListColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        getTimeSlotListResp.getTimeSlotList().forEach(e -> GetTimeSlotListTask.buildTSBlockRow(builder, e));
        DatasetHeader datasetHeader = DatasetHeaderFactory.getGetTimeSlotListHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

