/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.tsfile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.iotdb.cli.type.ExitType;
import org.apache.iotdb.cli.utils.CliContext;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.cli.utils.JlineUtils;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.tool.tsfile.AbstractTsFileTool;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.write.WriteProcessException;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.fileSystem.FSFactoryProducer;
import org.apache.tsfile.read.common.Field;
import org.apache.tsfile.read.common.Path;
import org.apache.tsfile.read.common.RowRecord;
import org.apache.tsfile.write.TsFileWriter;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.jline.reader.LineReader;

public class ExportTsFile
extends AbstractTsFileTool {
    private static final String TARGET_DIR_ARGS = "t";
    private static final String TARGET_DIR_NAME = "targetDirectory";
    private static final String TARGET_FILE_ARGS = "tfn";
    private static final String TARGET_FILE_NAME = "targetFileName";
    private static final String SQL_FILE_ARGS = "s";
    private static final String SQL_FILE_NAME = "sourceSqlFile";
    private static final String QUERY_COMMAND_ARGS = "q";
    private static final String QUERY_COMMAND_NAME = "queryCommand";
    private static final String DUMP_FILE_NAME_DEFAULT = "dump";
    private static final String TSFILEDB_CLI_PREFIX = "ExportTsFile";
    private static Session session;
    private static String targetDirectory;
    private static String targetFile;
    private static String queryCommand;
    private static long timeout;
    private static final IoTPrinter ioTPrinter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ExportTsFile.createOptions();
        HelpFormatter hf = new HelpFormatter();
        CommandLine commandLine = null;
        DefaultParser parser = new DefaultParser();
        hf.setOptionComparator(null);
        hf.setWidth(92);
        if (args == null || args.length == 0) {
            ioTPrinter.println("Too few params input, please check the following hint.");
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            System.exit(1);
        }
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            ioTPrinter.println(e.getMessage());
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            System.exit(1);
        }
        if (commandLine.hasOption("help")) {
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            System.exit(1);
        }
        int exitCode = 0;
        try {
            ExportTsFile.parseBasicParams(commandLine);
            ExportTsFile.parseSpecialParams(commandLine);
            session = new Session(host, Integer.parseInt(port), username, password);
            session.open(false);
            if (queryCommand == null) {
                String sqlFile = commandLine.getOptionValue(SQL_FILE_ARGS);
                if (sqlFile == null) {
                    LineReader lineReader = JlineUtils.getLineReader(new CliContext(System.in, System.out, System.err, ExitType.EXCEPTION), username, host, port);
                    String sql = lineReader.readLine("ExportTsFile> please input query: ");
                    ioTPrinter.println(sql);
                    String[] values = sql.trim().split(";");
                    for (int i = 0; i < values.length; ++i) {
                        ExportTsFile.legalCheck(values[i]);
                        ExportTsFile.dumpResult(values[i], i);
                    }
                } else {
                    ExportTsFile.dumpFromSqlFile(sqlFile);
                }
            } else {
                ExportTsFile.legalCheck(queryCommand);
                ExportTsFile.dumpResult(queryCommand, 0);
            }
        }
        catch (IOException e) {
            ioTPrinter.println("Failed to operate on file, because " + e.getMessage());
            exitCode = 1;
        }
        catch (ArgsErrorException e) {
            ioTPrinter.println("Invalid args: " + e.getMessage());
            exitCode = 1;
        }
        catch (IoTDBConnectionException e) {
            ioTPrinter.println("Connect failed because " + e.getMessage());
            exitCode = 1;
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (IoTDBConnectionException e) {
                    exitCode = 1;
                    ioTPrinter.println("Encounter an error when closing session, error is: " + e.getMessage());
                }
            }
        }
        System.exit(exitCode);
    }

    private static void legalCheck(String sql) {
        String sqlLower = sql.toLowerCase();
        if (sqlLower.contains("count(") || sqlLower.contains("sum(") || sqlLower.contains("avg(") || sqlLower.contains("extreme(") || sqlLower.contains("max_value(") || sqlLower.contains("min_value(") || sqlLower.contains("first_value(") || sqlLower.contains("last_value(") || sqlLower.contains("max_time(") || sqlLower.contains("min_time(") || sqlLower.contains("stddev(") || sqlLower.contains("stddev_pop(") || sqlLower.contains("stddev_samp(") || sqlLower.contains("variance(") || sqlLower.contains("var_pop(") || sqlLower.contains("var_samp(") || sqlLower.contains("max_by(") || sqlLower.contains("min_by(")) {
            ioTPrinter.println("The sql you entered is invalid, please don't use aggregate query.");
            System.exit(1);
        }
    }

    private static void parseSpecialParams(CommandLine commandLine) throws ArgsErrorException {
        targetDirectory = ExportTsFile.checkRequiredArg(TARGET_DIR_ARGS, TARGET_DIR_NAME, commandLine);
        queryCommand = commandLine.getOptionValue(QUERY_COMMAND_ARGS);
        targetFile = commandLine.getOptionValue(TARGET_FILE_ARGS);
        String timeoutString = commandLine.getOptionValue("timeout");
        if (timeoutString != null) {
            timeout = Long.parseLong(timeoutString);
        }
        if (targetFile == null) {
            targetFile = DUMP_FILE_NAME_DEFAULT;
        }
        if (!targetDirectory.endsWith("/") && !targetDirectory.endsWith("\\")) {
            targetDirectory = targetDirectory + File.separator;
        }
    }

    private static void createOptions() {
        ExportTsFile.createBaseOptions();
        Option opTargetFile = Option.builder((String)TARGET_DIR_ARGS).required().argName(TARGET_DIR_NAME).hasArg().desc("Target File Directory (required)").build();
        options.addOption(opTargetFile);
        Option targetFileName = Option.builder((String)TARGET_FILE_ARGS).argName(TARGET_FILE_NAME).hasArg().desc("Export file name (optional)").build();
        options.addOption(targetFileName);
        Option opSqlFile = Option.builder((String)SQL_FILE_ARGS).argName(SQL_FILE_NAME).hasArg().desc("SQL File Path (optional)").build();
        options.addOption(opSqlFile);
        Option opQuery = Option.builder((String)QUERY_COMMAND_ARGS).argName(QUERY_COMMAND_NAME).hasArg().desc("The query command that you want to execute. (optional)").build();
        options.addOption(opQuery);
        Option opHelp = Option.builder((String)"help").longOpt("help").hasArg(false).desc("Display help information").build();
        options.addOption(opHelp);
        Option opTimeout = Option.builder((String)"timeout").argName("queryTimeout").hasArg().desc("Timeout for session query").build();
        options.addOption(opTimeout);
    }

    private static void dumpFromSqlFile(String filePath) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String sql;
            int i = 0;
            while ((sql = reader.readLine()) != null) {
                ExportTsFile.legalCheck(sql);
                ExportTsFile.dumpResult(sql, i++);
            }
        }
    }

    private static void dumpResult(String sql, int index) {
        String path = targetDirectory + targetFile + index + ".tsfile";
        try (SessionDataSet sessionDataSet = session.executeQueryStatement(sql, timeout);){
            long start = System.currentTimeMillis();
            ExportTsFile.writeWithTablets(sessionDataSet, path);
            long end = System.currentTimeMillis();
            ioTPrinter.println("Export completely!cost: " + (end - start) + " ms.");
        }
        catch (IOException | IoTDBConnectionException | StatementExecutionException | WriteProcessException e) {
            ioTPrinter.println("Cannot dump result because: " + e.getMessage());
        }
    }

    private static void collectSchemas(List<String> columnNames, List<String> columnTypes, Map<String, List<MeasurementSchema>> deviceSchemaMap, Set<String> alignedDevices, Map<String, List<Integer>> deviceColumnIndices) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < columnNames.size(); ++i) {
            String column = columnNames.get(i);
            if (!column.startsWith("root.")) continue;
            TSDataType tsDataType = ExportTsFile.getTsDataType(columnTypes.get(i));
            Path path = new Path(column, true);
            String deviceId = path.getDevice();
            try (SessionDataSet deviceDataSet = session.executeQueryStatement("show devices " + deviceId, timeout);){
                List deviceList = deviceDataSet.next().getFields();
                if (deviceList.size() > 1 && "true".equals(((Field)deviceList.get(1)).getStringValue())) {
                    alignedDevices.add(deviceId);
                }
            }
            MeasurementSchema measurementSchema = new MeasurementSchema(path.getMeasurement(), tsDataType);
            List seriesList = session.executeQueryStatement("show timeseries " + column, timeout).next().getFields();
            measurementSchema.setEncoding(TSEncoding.valueOf((String)((Field)seriesList.get(4)).getStringValue()).serialize());
            measurementSchema.setCompressor(CompressionType.valueOf((String)((Field)seriesList.get(5)).getStringValue()).serialize());
            deviceSchemaMap.computeIfAbsent(deviceId, key -> new ArrayList()).add(measurementSchema);
            deviceColumnIndices.computeIfAbsent(deviceId, key -> new ArrayList()).add(i);
        }
    }

    private static List<Tablet> constructTablets(Map<String, List<MeasurementSchema>> deviceSchemaMap, Set<String> alignedDevices, TsFileWriter tsFileWriter) throws WriteProcessException {
        ArrayList<Tablet> tabletList = new ArrayList<Tablet>(deviceSchemaMap.size());
        for (Map.Entry<String, List<MeasurementSchema>> stringListEntry : deviceSchemaMap.entrySet()) {
            String deviceId = stringListEntry.getKey();
            List<MeasurementSchema> schemaList = stringListEntry.getValue();
            Tablet tablet = new Tablet(deviceId, schemaList);
            tablet.initBitMaps();
            Path path = new Path(tablet.deviceId);
            if (alignedDevices.contains(tablet.deviceId)) {
                tsFileWriter.registerAlignedTimeseries(path, schemaList);
            } else {
                tsFileWriter.registerTimeseries(path, schemaList);
            }
            tabletList.add(tablet);
        }
        return tabletList;
    }

    private static void writeWithTablets(SessionDataSet sessionDataSet, List<Tablet> tabletList, Set<String> alignedDevices, TsFileWriter tsFileWriter, Map<String, List<Integer>> deviceColumnIndices) throws IoTDBConnectionException, StatementExecutionException, IOException, WriteProcessException {
        while (sessionDataSet.hasNext()) {
            RowRecord rowRecord = sessionDataSet.next();
            List fields = rowRecord.getFields();
            for (Tablet tablet : tabletList) {
                int rowIndex;
                String deviceId = tablet.deviceId;
                List<Integer> columnIndices = deviceColumnIndices.get(deviceId);
                ++tablet.rowSize;
                tablet.addTimestamp(rowIndex, rowRecord.getTimestamp());
                List schemas = tablet.getSchemas();
                int columnIndicesSize = columnIndices.size();
                for (int i = 0; i < columnIndicesSize; ++i) {
                    Integer columnIndex = columnIndices.get(i);
                    MeasurementSchema measurementSchema = (MeasurementSchema)schemas.get(i);
                    Object value = ((Field)fields.get(columnIndex - 1)).getObjectValue(measurementSchema.getType());
                    if (value == null) {
                        tablet.bitMaps[i].mark(rowIndex);
                    }
                    tablet.addValue(measurementSchema.getMeasurementId(), rowIndex, value);
                }
                if (tablet.rowSize != tablet.getMaxRowNumber()) continue;
                ExportTsFile.writeToTsFile(alignedDevices, tsFileWriter, tablet);
                tablet.initBitMaps();
                tablet.reset();
            }
        }
        for (Tablet tablet : tabletList) {
            if (tablet.rowSize == 0) continue;
            ExportTsFile.writeToTsFile(alignedDevices, tsFileWriter, tablet);
        }
    }

    public static void writeWithTablets(SessionDataSet sessionDataSet, String filePath) throws IOException, IoTDBConnectionException, StatementExecutionException, WriteProcessException {
        List columnNames = sessionDataSet.getColumnNames();
        List columnTypes = sessionDataSet.getColumnTypes();
        File f = FSFactoryProducer.getFSFactory().getFile(filePath);
        if (f.exists()) {
            Files.delete(f.toPath());
        }
        try (TsFileWriter tsFileWriter = new TsFileWriter(f);){
            HashMap<String, List<Integer>> deviceColumnIndices = new HashMap<String, List<Integer>>();
            HashSet<String> alignedDevices = new HashSet<String>();
            LinkedHashMap<String, List<MeasurementSchema>> deviceSchemaMap = new LinkedHashMap<String, List<MeasurementSchema>>();
            ExportTsFile.collectSchemas(columnNames, columnTypes, deviceSchemaMap, alignedDevices, deviceColumnIndices);
            List<Tablet> tabletList = ExportTsFile.constructTablets(deviceSchemaMap, alignedDevices, tsFileWriter);
            if (tabletList.isEmpty()) {
                ioTPrinter.println("!!!Warning:Tablet is empty,no data can be exported.");
                System.exit(1);
            }
            ExportTsFile.writeWithTablets(sessionDataSet, tabletList, alignedDevices, tsFileWriter, deviceColumnIndices);
            tsFileWriter.flushAllChunkGroups();
        }
    }

    private static void writeToTsFile(Set<String> deviceFilterSet, TsFileWriter tsFileWriter, Tablet tablet) throws IOException, WriteProcessException {
        if (deviceFilterSet.contains(tablet.deviceId)) {
            tsFileWriter.writeAligned(tablet);
        } else {
            tsFileWriter.write(tablet);
        }
    }

    private static TSDataType getTsDataType(String type) {
        return TSDataType.valueOf((String)type);
    }

    static {
        targetFile = DUMP_FILE_NAME_DEFAULT;
        timeout = -1L;
        ioTPrinter = new IoTPrinter(System.out);
    }
}

