/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.List;
import org.apache.iotdb.db.utils.datastructure.AlignedTVList;
import org.apache.iotdb.db.utils.datastructure.QuickSort;
import org.apache.tsfile.enums.TSDataType;

public class QuickAlignedTVList
extends AlignedTVList
implements QuickSort {
    QuickAlignedTVList(List<TSDataType> types) {
        super(types);
    }

    @Override
    public void sort() {
        if (!this.sorted) {
            this.qsort(0, this.rowCount - 1);
        }
        this.sorted = true;
    }

    @Override
    protected void set(int src, int dest) {
        long srcT = this.getTime(src);
        int srcV = this.getValueIndex(src);
        this.set(dest, srcT, srcV);
    }

    @Override
    public int compare(int idx1, int idx2) {
        long t1 = this.getTime(idx1);
        long t2 = this.getTime(idx2);
        return Long.compare(t1, t2);
    }

    @Override
    public void swap(int p, int q) {
        int valueP = this.getValueIndex(p);
        long timeP = this.getTime(p);
        int valueQ = this.getValueIndex(q);
        long timeQ = this.getTime(q);
        this.set(p, timeQ, valueQ);
        this.set(q, timeP, valueP);
    }
}

