/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event.batch;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.batch.PipeTabletEventTsFileBatch;
import org.apache.iotdb.db.subscription.broker.SubscriptionPrefetchingTsFileQueue;
import org.apache.iotdb.db.subscription.event.SubscriptionEvent;
import org.apache.iotdb.db.subscription.event.batch.SubscriptionPipeEventBatch;
import org.apache.iotdb.db.subscription.event.pipe.SubscriptionPipeEvents;
import org.apache.iotdb.db.subscription.event.pipe.SubscriptionPipeTsFileBatchEvents;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.rpc.subscription.payload.poll.FileInitPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponse;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponseType;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SubscriptionPipeTsFileEventBatch
extends SubscriptionPipeEventBatch {
    private final PipeTabletEventTsFileBatch batch;
    private final List<EnrichedEvent> enrichedEvents;

    public SubscriptionPipeTsFileEventBatch(int regionId, SubscriptionPrefetchingTsFileQueue prefetchingQueue, int maxDelayInMs, long maxBatchSizeInBytes) {
        super(regionId, prefetchingQueue, maxDelayInMs, maxBatchSizeInBytes);
        this.batch = new PipeTabletEventTsFileBatch(maxDelayInMs, maxBatchSizeInBytes);
        this.enrichedEvents = new ArrayList<EnrichedEvent>();
    }

    @Override
    public synchronized boolean onEvent(Consumer<SubscriptionEvent> consumer) throws Exception {
        if (this.batch.shouldEmit() && !this.enrichedEvents.isEmpty()) {
            if (Objects.isNull(this.events)) {
                this.events = this.generateSubscriptionEvents();
            }
            if (Objects.nonNull(this.events)) {
                this.events.forEach(consumer);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public synchronized boolean onEvent(@NonNull EnrichedEvent event, Consumer<SubscriptionEvent> consumer) throws Exception {
        if (event instanceof TabletInsertionEvent) {
            this.batch.onEvent((TabletInsertionEvent)event);
            this.enrichedEvents.add(event);
            event.decreaseReferenceCount(SubscriptionPipeTsFileEventBatch.class.getName(), false);
        }
        return this.onEvent(consumer);
    }

    @Override
    public synchronized void cleanUp() {
        this.batch.close();
        this.enrichedEvents.clear();
    }

    public synchronized void ack() {
        this.batch.decreaseEventsReferenceCount(this.getClass().getName(), true);
    }

    private List<SubscriptionEvent> generateSubscriptionEvents() throws Exception {
        if (this.batch.isEmpty()) {
            return null;
        }
        ArrayList<SubscriptionEvent> events = new ArrayList<SubscriptionEvent>();
        List<File> tsFiles = this.batch.sealTsFiles();
        AtomicInteger referenceCount = new AtomicInteger(tsFiles.size());
        for (File tsFile : tsFiles) {
            SubscriptionCommitContext commitContext = this.prefetchingQueue.generateSubscriptionCommitContext();
            events.add(new SubscriptionEvent((SubscriptionPipeEvents)new SubscriptionPipeTsFileBatchEvents(this, tsFile, referenceCount), new SubscriptionPollResponse(SubscriptionPollResponseType.FILE_INIT.getType(), (SubscriptionPollPayload)new FileInitPayload(tsFile.getName()), commitContext)));
        }
        return events;
    }

    public String toString() {
        return "SubscriptionPipeTsFileEventBatch" + this.coreReportMessage();
    }

    @Override
    protected Map<String, String> coreReportMessage() {
        Map<String, String> coreReportMessage = super.coreReportMessage();
        coreReportMessage.put("batch", this.batch.toString());
        return coreReportMessage;
    }

    public int getPipeEventCount() {
        return this.enrichedEvents.size();
    }
}

