/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.NodeRef;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.AnalyzeVisitor;
import org.apache.iotdb.db.queryengine.plan.analyze.ColumnPaginationController;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.TemplatedAnalyze;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.optimization.LimitOffsetPushDown;
import org.apache.iotdb.db.queryengine.plan.statement.component.ResultColumn;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class TemplatedAggregationAnalyze {
    static boolean canBuildAggregationPlanUseTemplate(Analysis analysis, QueryStatement queryStatement, IPartitionFetcher partitionFetcher, ISchemaTree schemaTree, MPPQueryContext context, Template template) {
        ArrayList<Pair<Expression, String>> outputExpressions;
        boolean valid;
        if (queryStatement.hasOrderByExpression() || !template.isDirectAligned()) {
            return false;
        }
        analysis.setNoWhereAndAggregation(false);
        List<PartialPath> deviceList = TemplatedAnalyze.analyzeFrom(queryStatement, schemaTree);
        if (LimitOffsetPushDown.canPushDownLimitOffsetInGroupByTimeForDevice(queryStatement)) {
            deviceList = LimitOffsetPushDown.pushDownLimitOffsetInGroupByTimeForDevice(deviceList, queryStatement);
        }
        if (!(valid = TemplatedAggregationAnalyze.analyzeSelect(queryStatement, analysis, outputExpressions = new ArrayList<Pair<Expression, String>>(), template))) {
            analysis.setDeviceTemplate(null);
            return false;
        }
        TemplatedAnalyze.analyzeDeviceToWhere(analysis, queryStatement);
        if (deviceList.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
            return true;
        }
        analysis.setDeviceList(deviceList);
        if (analysis.getWhereExpression() != null && ConstantOperand.FALSE.equals(analysis.getWhereExpression())) {
            AnalyzeVisitor.analyzeOutput(analysis, queryStatement, outputExpressions);
            analysis.setFinishQueryAfterAnalyze(true);
            return true;
        }
        valid = TemplatedAggregationAnalyze.analyzeHaving(analysis, queryStatement);
        if (!valid) {
            analysis.setDeviceTemplate(null);
            return false;
        }
        TemplatedAggregationAnalyze.analyzeDeviceToExpressions(analysis);
        TemplatedAnalyze.analyzeDeviceViewOutput(analysis, queryStatement);
        AnalyzeVisitor.analyzeOutput(analysis, queryStatement, outputExpressions);
        AnalyzeVisitor.analyzeGroupByTime(analysis, queryStatement);
        context.generateGlobalTimeFilter(analysis);
        TemplatedAnalyze.analyzeDataPartition(analysis, schemaTree, partitionFetcher, context);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean analyzeSelect(QueryStatement queryStatement, Analysis analysis, List<Pair<Expression, String>> outputExpressions, Template template) {
        LinkedHashSet<Expression> selectExpressions = new LinkedHashSet<Expression>();
        selectExpressions.add(AnalyzeVisitor.DEVICE_EXPRESSION);
        if (queryStatement.isOutputEndTime()) {
            return false;
        }
        analysis.setDeviceTemplate(template);
        ColumnPaginationController paginationController = new ColumnPaginationController(queryStatement.getSeriesLimit(), queryStatement.getSeriesOffset());
        LinkedHashSet<Expression> aggregationExpressions = new LinkedHashSet<Expression>();
        block0: for (ResultColumn resultColumn : queryStatement.getSelectComponent().getResultColumns()) {
            List<Expression> subExpressions;
            Expression selectExpression = resultColumn.getExpression();
            if (selectExpression instanceof FunctionExpression && "count_time".equalsIgnoreCase(((FunctionExpression)selectExpression).getFunctionName())) {
                outputExpressions.add((Pair<Expression, String>)new Pair((Object)selectExpression, (Object)resultColumn.getAlias()));
                selectExpressions.add(selectExpression);
                aggregationExpressions.add(selectExpression);
                analysis.getExpressionTypes().put(NodeRef.of(selectExpression), TSDataType.INT64);
                ((FunctionExpression)selectExpression).setExpressions(Collections.singletonList(new TimestampOperand()));
                continue;
            }
            if (selectExpression.getOutputSymbol().contains("*")) {
                if (!(selectExpression instanceof FunctionExpression) || selectExpression.getExpressions().size() != 1 || !"*".equalsIgnoreCase(selectExpression.getExpressions().get(0).getOutputSymbol())) return false;
                subExpressions = new ArrayList<Expression>();
                FunctionExpression functionExpression = (FunctionExpression)selectExpression;
                for (String measurement : template.getSchemaMap().keySet()) {
                    FunctionExpression subFunctionExpression = new FunctionExpression(functionExpression.getFunctionName(), functionExpression.getFunctionAttributes(), Collections.singletonList(new TimeSeriesOperand(new PartialPath(new String[]{measurement}))));
                    subFunctionExpression.setFunctionType(functionExpression.getFunctionType());
                    subExpressions.add(subFunctionExpression);
                }
            } else {
                subExpressions = Collections.singletonList(selectExpression);
            }
            for (Expression expression : subExpressions) {
                if (paginationController.hasCurOffset()) {
                    paginationController.consumeOffset();
                    continue;
                }
                if (!paginationController.hasCurLimit()) continue block0;
                outputExpressions.add((Pair<Expression, String>)new Pair((Object)expression, (Object)resultColumn.getAlias()));
                selectExpressions.add(expression);
                aggregationExpressions.add(expression);
                AnalyzeVisitor.analyzeExpressionType(analysis, expression);
            }
        }
        ArrayList<String> measurementList = new ArrayList();
        ArrayList<IMeasurementSchema> measurementSchemaList = new ArrayList<IMeasurementSchema>();
        HashSet<String> measurementSet = new HashSet<String>();
        if (queryStatement.isCountTimeAggregation()) {
            measurementList = new ArrayList<String>(template.getSchemaMap().keySet());
            measurementSchemaList = new ArrayList<IMeasurementSchema>(template.getSchemaMap().values());
        } else {
            int idx = 0;
            for (Expression selectExpression : selectExpressions) {
                String measurement;
                if (++idx == 1 || idx == 2 && "__endTime".equalsIgnoreCase(selectExpression.getOutputSymbol())) continue;
                measurement = selectExpression.getExpressions().get(0).getOutputSymbol();
                if (!template.getSchemaMap().containsKey(measurement)) {
                    return false;
                }
                if (measurementSet.contains(measurement)) continue;
                measurementSet.add(measurement);
                measurementList.add(measurement);
                measurementSchemaList.add(template.getSchemaMap().get(measurement));
            }
        }
        analysis.setMeasurementList(measurementList);
        analysis.setMeasurementSchemaList(measurementSchemaList);
        analysis.setAggregationExpressions(aggregationExpressions);
        analysis.setOutputExpressions(outputExpressions);
        analysis.setSelectExpressions(selectExpressions);
        return true;
    }

    private static boolean analyzeHaving(Analysis analysis, QueryStatement queryStatement) {
        if (!queryStatement.hasHaving()) {
            return true;
        }
        HashSet<String> measurementSet = new HashSet<String>(analysis.getMeasurementList());
        Set<Expression> aggregationExpressions = analysis.getAggregationExpressions();
        Expression havingExpression = queryStatement.getHavingCondition().getPredicate();
        for (Expression aggregationExpression : ExpressionAnalyzer.searchAggregationExpressions(havingExpression)) {
            Expression normalizedAggregationExpression = ExpressionAnalyzer.normalizeExpression(aggregationExpression);
            if (!(normalizedAggregationExpression.getExpressions().get(0) instanceof TimeSeriesOperand)) {
                return false;
            }
            String measurement = normalizedAggregationExpression.getExpressions().get(0).getOutputSymbol();
            if (!measurementSet.contains(measurement)) {
                measurementSet.add(measurement);
                analysis.getMeasurementList().add(measurement);
                analysis.getMeasurementSchemaList().add(analysis.getDeviceTemplate().getSchema(measurement));
            }
            AnalyzeVisitor.analyzeExpressionType(analysis, aggregationExpression);
            AnalyzeVisitor.analyzeExpressionType(analysis, normalizedAggregationExpression);
            aggregationExpressions.add(aggregationExpression);
        }
        TSDataType outputType = AnalyzeVisitor.analyzeExpressionType(analysis, havingExpression);
        if (outputType != TSDataType.BOOLEAN) {
            throw new SemanticException(String.format("The output type of the expression in HAVING clause should be BOOLEAN, actual data type: %s.", outputType));
        }
        analysis.setHavingExpression(havingExpression);
        return true;
    }

    private static void analyzeDeviceToExpressions(Analysis analysis) {
        analysis.setDeviceToSourceTransformExpressions(analysis.getDeviceToSelectExpressions());
        analysis.setDeviceToSourceExpressions(analysis.getDeviceToSelectExpressions());
        analysis.setDeviceToOutputExpressions(analysis.getDeviceToSelectExpressions());
        analysis.setDeviceToAggregationExpressions(analysis.getDeviceToSelectExpressions());
    }
}

