/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.parser.ASTVisitor;
import org.apache.iotdb.db.utils.TypeInferenceUtils;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Pair;

public class SelectIntoUtils {
    private SelectIntoUtils() {
    }

    public static PartialPath constructTargetPath(PartialPath sourcePath, PartialPath deviceTemplate, String measurementTemplate) {
        PartialPath targetDevice = SelectIntoUtils.constructTargetDevice(sourcePath.getDevicePath(), deviceTemplate);
        String targetMeasurement = SelectIntoUtils.constructTargetMeasurement(sourcePath, measurementTemplate);
        return targetDevice.concatNode(targetMeasurement);
    }

    public static PartialPath constructTargetDevice(PartialPath sourceDevice, PartialPath deviceTemplate) {
        String[] sourceNodes = sourceDevice.getNodes();
        String[] templateNodes = deviceTemplate.getNodes();
        ArrayList<String> targetNodes = new ArrayList<String>();
        for (int nodeIndex = 0; nodeIndex < templateNodes.length; ++nodeIndex) {
            String curNode = templateNodes[nodeIndex];
            if (curNode.equals("::")) {
                if (nodeIndex != templateNodes.length - 1) {
                    throw new SemanticException("select into: placeholder `::` can only be used at the end of the path.");
                }
                while (nodeIndex < sourceNodes.length) {
                    targetNodes.add(sourceNodes[nodeIndex]);
                    ++nodeIndex;
                }
                break;
            }
            String resNode = SelectIntoUtils.applyLevelPlaceholder(curNode, sourceNodes);
            targetNodes.add(resNode);
        }
        return new PartialPath(targetNodes.toArray(new String[0]));
    }

    public static String constructTargetMeasurement(PartialPath sourcePath, String measurementTemplate) {
        if (measurementTemplate.equals("::")) {
            return sourcePath.getMeasurement();
        }
        return SelectIntoUtils.applyLevelPlaceholder(measurementTemplate, sourcePath.getNodes());
    }

    private static String applyLevelPlaceholder(String templateNode, String[] sourceNodes) {
        String resNode = templateNode;
        Matcher matcher = IoTDBConstant.LEVELED_PATH_TEMPLATE_PATTERN.matcher(resNode);
        while (matcher.find()) {
            int index;
            String param = matcher.group();
            try {
                index = Integer.parseInt(param.substring(2, param.length() - 1).trim());
            }
            catch (NumberFormatException e) {
                throw new SemanticException("select into: the i of ${i} should be an integer.");
            }
            if (index < 1 || index >= sourceNodes.length) {
                throw new SemanticException("select into: the i of ${i} should be greater than 0 and equal to or less than the length of queried path prefix.");
            }
            resNode = matcher.replaceFirst(sourceNodes[index]);
            matcher = IoTDBConstant.LEVELED_PATH_TEMPLATE_PATTERN.matcher(resNode);
        }
        return ASTVisitor.parseNodeString(resNode);
    }

    public static boolean checkIsAllRawSeriesQuery(List<Expression> expressions) {
        for (Expression expression : expressions) {
            if (expression instanceof TimeSeriesOperand) continue;
            return false;
        }
        return true;
    }

    public static List<Pair<String, PartialPath>> bindTypeForSourceTargetPathPairList(List<Pair<String, PartialPath>> sourceTargetPathPairList, Map<String, TSDataType> sourceToDataTypeMap, ISchemaTree targetSchemaTree) {
        ArrayList<Pair<String, PartialPath>> sourceTypeBoundTargetPathPairList = new ArrayList<Pair<String, PartialPath>>();
        for (Pair<String, PartialPath> sourceTargetPathPair : sourceTargetPathPairList) {
            MeasurementPath targetPathWithSchema;
            String sourceColumn = (String)sourceTargetPathPair.left;
            TSDataType sourceColumnType = sourceToDataTypeMap.get(sourceColumn);
            PartialPath targetPath = (PartialPath)sourceTargetPathPair.right;
            List actualTargetPaths = (List)targetSchemaTree.searchMeasurementPaths((PartialPath)targetPath).left;
            if (actualTargetPaths.isEmpty()) {
                targetPathWithSchema = new MeasurementPath(targetPath, sourceColumnType);
            } else {
                Preconditions.checkState((actualTargetPaths.size() == 1 ? 1 : 0) != 0);
                MeasurementPath actualTargetPath = (MeasurementPath)actualTargetPaths.get(0);
                if (actualTargetPath.getMeasurementSchema().isLogicalView()) {
                    LogicalViewSchema viewSchema = (LogicalViewSchema)actualTargetPath.getMeasurementSchema();
                    if (viewSchema.isWritable()) {
                        MeasurementPath viewSourceSeriesPath = (MeasurementPath)((List)targetSchemaTree.searchMeasurementPaths((PartialPath)viewSchema.getSourcePathIfWritable()).left).get(0);
                        actualTargetPath = new MeasurementPath(targetPath, viewSourceSeriesPath.getSeriesType());
                        actualTargetPath.setUnderAlignedEntity(Boolean.valueOf(viewSourceSeriesPath.isUnderAlignedEntity()));
                    } else {
                        throw new SemanticException(String.format("View %s doesn't support data insertion.", targetPath));
                    }
                }
                if (!TypeInferenceUtils.canAutoCast(sourceColumnType, actualTargetPath.getSeriesType())) {
                    throw new SemanticException(String.format("The data type of target path (%s[%s]) is not compatible with the data type of source column (%s[%s]).", targetPath, actualTargetPath.getSeriesType(), sourceColumn, sourceColumnType));
                }
                targetPathWithSchema = actualTargetPath;
            }
            sourceTypeBoundTargetPathPairList.add((Pair<String, PartialPath>)new Pair((Object)sourceColumn, (Object)targetPathWithSchema));
        }
        return sourceTypeBoundTargetPathPairList;
    }

    public static Map<PartialPath, Map<String, TSDataType>> convertSourceTargetPathPairListToTargetPathDataTypeMap(List<Pair<String, PartialPath>> sourceTargetPathPairList) {
        HashMap<PartialPath, Map<String, TSDataType>> targetPathToDataTypeMap = new HashMap<PartialPath, Map<String, TSDataType>>();
        for (Pair<String, PartialPath> sourceTargetPathPair : sourceTargetPathPairList) {
            PartialPath targetPath = (PartialPath)sourceTargetPathPair.right;
            targetPathToDataTypeMap.computeIfAbsent(targetPath.getDevicePath(), key -> new HashMap()).put(targetPath.getMeasurement(), targetPath.getSeriesType());
        }
        return targetPathToDataTypeMap;
    }
}

