/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.dataregion;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.datastructure.options.PipeInclusionOptions;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.tsfile.utils.Pair;

public class DataRegionListeningFilter {
    private static final Set<PartialPath> OPTION_SET = new HashSet<PartialPath>();

    public static boolean shouldDataRegionBeListened(PipeParameters parameters) throws IllegalPathException {
        Pair<Boolean, Boolean> insertionDeletionListeningOptionPair = DataRegionListeningFilter.parseInsertionDeletionListeningOptionPair(parameters);
        return (Boolean)insertionDeletionListeningOptionPair.getLeft() != false || (Boolean)insertionDeletionListeningOptionPair.getRight() != false;
    }

    public static Pair<Boolean, Boolean> parseInsertionDeletionListeningOptionPair(PipeParameters parameters) throws IllegalPathException, IllegalArgumentException {
        HashSet listeningOptions = new HashSet();
        Set inclusionOptions = PipeInclusionOptions.parseOptions((String)parameters.getStringOrDefault(Arrays.asList("extractor.inclusion", "source.inclusion"), "data.insert"));
        Set exclusionOptions = PipeInclusionOptions.parseOptions((String)parameters.getStringOrDefault(Arrays.asList("extractor.inclusion.exclusion", "source.inclusion.exclusion"), ""));
        inclusionOptions.forEach(inclusion -> listeningOptions.addAll(OPTION_SET.stream().filter(path -> path.overlapWithFullPathPrefix(inclusion)).map(PartialPath::getFullPath).collect(Collectors.toSet())));
        exclusionOptions.forEach(exclusion -> listeningOptions.removeAll(OPTION_SET.stream().filter(path -> path.overlapWithFullPathPrefix(exclusion)).map(PartialPath::getFullPath).collect(Collectors.toSet())));
        return new Pair((Object)listeningOptions.contains("data.insert"), (Object)listeningOptions.contains("data.delete"));
    }

    static {
        try {
            OPTION_SET.add(new PartialPath("data.insert"));
            OPTION_SET.add(new PartialPath("data.delete"));
        }
        catch (IllegalPathException illegalPathException) {
            // empty catch block
        }
    }
}

