/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription.util;

import org.apache.iotdb.rpc.subscription.exception.SubscriptionIdentifierSemanticException;
import org.apache.tsfile.common.constant.TsFileConstant;
import org.apache.tsfile.read.common.parser.PathVisitor;

public class IdentifierUtils {
    public static String parseIdentifier(String src) {
        if (src.startsWith("`") && src.endsWith("`")) {
            return src.substring(1, src.length() - 1).replace("``", "`");
        }
        IdentifierUtils.checkIdentifier(src);
        return src;
    }

    private static void checkIdentifier(String src) {
        if (!TsFileConstant.IDENTIFIER_PATTERN.matcher(src).matches() || PathVisitor.isRealNumber((String)src)) {
            throw new SubscriptionIdentifierSemanticException(String.format("%s is illegal, identifier not enclosed with backticks can only consist of digits, characters and underscore.", src));
        }
    }
}

