/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription.payload;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionIncompatibleHandlerException;
import org.apache.iotdb.session.subscription.payload.SubscriptionMessageHandler;
import org.apache.iotdb.session.subscription.payload.SubscriptionSessionDataSetsHandler;

public abstract class SubscriptionFileHandler
implements SubscriptionMessageHandler {
    protected final String absolutePath;

    public SubscriptionFileHandler(String absolutePath) {
        this.absolutePath = absolutePath;
    }

    public synchronized File getFile() {
        return new File(this.absolutePath);
    }

    public synchronized Path getPath() {
        return Paths.get(this.absolutePath, new String[0]);
    }

    public synchronized Path deleteFile() throws IOException {
        Path sourcePath = this.getPath();
        Files.delete(sourcePath);
        return sourcePath;
    }

    public synchronized Path moveFile(String target) throws IOException {
        return this.moveFile(Paths.get(target, new String[0]));
    }

    public synchronized Path moveFile(Path target) throws IOException {
        if (!Files.exists(target.getParent(), new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
        }
        return Files.move(this.getPath(), target, StandardCopyOption.REPLACE_EXISTING);
    }

    public synchronized Path copyFile(String target) throws IOException {
        return this.copyFile(Paths.get(target, new String[0]));
    }

    public synchronized Path copyFile(Path target) throws IOException {
        if (!Files.exists(target.getParent(), new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
        }
        return Files.copy(this.getPath(), target, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
    }

    @Override
    public SubscriptionSessionDataSetsHandler getSessionDataSetsHandler() {
        throw new SubscriptionIncompatibleHandlerException("SubscriptionFileHandler do not support getSessionDataSetsHandler().");
    }
}

