/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.conf;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.enums.HandleSystemErrorStrategy;
import org.apache.iotdb.commons.enums.PipeRemainingTimeRateAverageTime;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.commons.utils.KillPoint.KillPoint;
import org.apache.tsfile.fileSystem.FSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonConfig {
    public static final String OLD_CONFIG_NODE_CONFIG_NAME = "iotdb-confignode.properties";
    public static final String OLD_DATA_NODE_CONFIG_NAME = "iotdb-datanode.properties";
    public static final String OLD_COMMON_CONFIG_NAME = "iotdb-common.properties";
    public static final String SYSTEM_CONFIG_NAME = "iotdb-system.properties";
    public static final String SYSTEM_CONFIG_TEMPLATE_NAME = "iotdb-system.properties.template";
    private static final Logger logger = LoggerFactory.getLogger(CommonConfig.class);
    private String openIdProviderUrl = "";
    private String authorizerProvider = "org.apache.iotdb.commons.auth.authorizer.LocalFileAuthorizer";
    private String encryptDecryptProvider = "org.apache.iotdb.commons.security.encrypt.MessageDigestEncrypt";
    private String encryptDecryptProviderParameter;
    private String adminName = "root";
    private String adminPassword = "root";
    private String oldUserFolder = IoTDBConstant.DN_DEFAULT_DATA_DIR + File.separator + "system" + File.separator + "users";
    private String oldRoleFolder = IoTDBConstant.DN_DEFAULT_DATA_DIR + File.separator + "system" + File.separator + "roles";
    private String oldProcedureWalFolder = IoTDBConstant.DN_DEFAULT_DATA_DIR + File.separator + "system" + File.separator + "procedure";
    private String userFolder = IoTDBConstant.CN_DEFAULT_DATA_DIR + File.separator + "system" + File.separator + "users";
    private String roleFolder = IoTDBConstant.CN_DEFAULT_DATA_DIR + File.separator + "system" + File.separator + "roles";
    private String procedureWalFolder = IoTDBConstant.CN_DEFAULT_DATA_DIR + File.separator + "system" + File.separator + "procedure";
    private String syncDir = IoTDBConstant.DN_DEFAULT_DATA_DIR + File.separator + "sync";
    private String[] walDirs = new String[]{IoTDBConstant.DN_DEFAULT_DATA_DIR + File.separator + "wal"};
    private FSType systemFileStorageFs = FSType.LOCAL;
    private long[] tierTTLInMs = new long[]{Long.MAX_VALUE};
    private int ttlRuleCapacity = 1000;
    private int connectionTimeoutInMS = (int)TimeUnit.SECONDS.toMillis(60L);
    private int selectorNumOfClientManager = 1;
    private boolean isRpcThriftCompressionEnabled = false;
    private int maxClientNumForEachNode = 300;
    private HandleSystemErrorStrategy handleSystemErrorStrategy = HandleSystemErrorStrategy.CHANGE_TO_READ_ONLY;
    private volatile NodeStatus status = NodeStatus.Running;
    private NodeStatus lastStatus = NodeStatus.Unknown;
    private String lastStatusReason = "";
    private volatile boolean isStopping = false;
    private volatile String statusReason = null;
    private final int TTimePartitionSlotTransmitLimit = 1000;
    private double diskSpaceWarningThreshold = 0.05;
    private TEndPoint targetAINodeEndPoint = new TEndPoint("127.0.0.1", 10810);
    private long timePartitionOrigin = 0L;
    private long timePartitionInterval = 604800000L;
    private String timestampPrecision = "ms";
    private boolean timestampPrecisionCheckEnabled = true;
    private int modelInferenceExecutionThreadCount = 5;
    private String pipeHardlinkBaseDirName = "pipe";
    private String pipeHardlinkTsFileDirName = "tsfile";
    private String pipeHardlinkWALDirName = "wal";
    private boolean pipeHardLinkWALEnabled = false;
    private int pipeRealTimeQueuePollHistoryThreshold = 100;
    private int pipeSubtaskExecutorMaxThreadNum = Math.min(5, Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
    private int pipeNonForwardingEventsProgressReportInterval = 100;
    private int pipeDataStructureTabletRowSize = 2048;
    private int pipeDataStructureTabletSizeInBytes = 0x200000;
    private double pipeDataStructureTabletMemoryBlockAllocationRejectThreshold = 0.4;
    private int pipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount = 10000;
    private long pipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration = 10000L;
    private long pipeSubtaskExecutorPendingQueueMaxBlockingTimeMs = 1000L;
    private long pipeSubtaskExecutorCronHeartbeatEventIntervalSeconds = 20L;
    private long pipeSubtaskExecutorForcedRestartIntervalMs = Long.MAX_VALUE;
    private int pipeExtractorAssignerDisruptorRingBufferSize = 65536;
    private long pipeExtractorAssignerDisruptorRingBufferEntrySizeInBytes = 50L;
    private int pipeExtractorMatcherCacheSize = 1024;
    private int pipeConnectorHandshakeTimeoutMs = 10000;
    private int pipeConnectorTransferTimeoutMs = 900000;
    private int pipeConnectorReadFileBufferSize = 0x800000;
    private long pipeConnectorRetryIntervalMs = 1000L;
    private boolean pipeConnectorRPCThriftCompressionEnabled = false;
    private int pipeAsyncConnectorSelectorNumber = 4;
    private int pipeAsyncConnectorMaxClientNumber = 16;
    private double pipeAllSinksRateLimitBytesPerSecond = -1.0;
    private int rateLimiterHotReloadCheckIntervalMs = 1000;
    private int pipeConnectorRequestSliceThresholdBytes = 0x19999999;
    private boolean isSeperatedPipeHeartbeatEnabled = true;
    private int pipeHeartbeatIntervalSecondsForCollectingPipeMeta = 100;
    private long pipeMetaSyncerInitialSyncDelayMinutes = 3L;
    private long pipeMetaSyncerSyncIntervalMinutes = 3L;
    private long pipeMetaSyncerAutoRestartPipeCheckIntervalRound = 1L;
    private boolean pipeAutoRestartEnabled = true;
    private boolean pipeAirGapReceiverEnabled = false;
    private int pipeAirGapReceiverPort = 9780;
    private int pipeMaxAllowedHistoricalTsFilePerDataRegion = 100;
    private int pipeMaxAllowedPendingTsFileEpochPerDataRegion = 2;
    private int pipeMaxAllowedPinnedMemTableCount = 50;
    private long pipeMaxAllowedLinkedTsFileCount = 100L;
    private float pipeMaxAllowedLinkedDeletedTsFileDiskUsagePercentage = 0.1f;
    private long pipeStuckRestartIntervalSeconds = 120L;
    private int pipeMetaReportMaxLogNumPerRound = 10;
    private int pipeMetaReportMaxLogIntervalRounds = 36;
    private int pipeTsFilePinMaxLogNumPerRound = 10;
    private int pipeTsFilePinMaxLogIntervalRounds = 90;
    private int pipeWalPinMaxLogNumPerRound = 10;
    private int pipeWalPinMaxLogIntervalRounds = 90;
    private boolean pipeMemoryManagementEnabled = true;
    private long pipeMemoryAllocateRetryIntervalMs = 1000L;
    private int pipeMemoryAllocateMaxRetries = 10;
    private long pipeMemoryAllocateMinSizeInBytes = 32L;
    private long pipeMemoryAllocateForTsFileSequenceReaderInBytes = 0x200000L;
    private long pipeMemoryExpanderIntervalSeconds = 180L;
    private float pipeLeaderCacheMemoryUsagePercentage = 0.1f;
    private long pipeListeningQueueTransferSnapshotThreshold = 1000L;
    private int pipeSnapshotExecutionMaxBatchSize = 1000;
    private long pipeRemainingTimeCommitRateAutoSwitchSeconds = 30L;
    private PipeRemainingTimeRateAverageTime pipeRemainingTimeCommitRateAverageTime = PipeRemainingTimeRateAverageTime.MEAN;
    private double pipeTsFileScanParsingThreshold = 0.05;
    private long twoStageAggregateMaxCombinerLiveTimeInMs = 480000L;
    private long twoStageAggregateDataRegionInfoCacheTimeInMs = 180000L;
    private long twoStageAggregateSenderEndPointsCacheInMs = 180000L;
    private float subscriptionCacheMemoryUsagePercentage = 0.2f;
    private int subscriptionSubtaskExecutorMaxThreadNum = Math.min(5, Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
    private int subscriptionPrefetchTabletBatchMaxDelayInMs = 1000;
    private long subscriptionPrefetchTabletBatchMaxSizeInBytes = 0x1000000L;
    private int subscriptionPrefetchTsFileBatchMaxDelayInMs = 5000;
    private long subscriptionPrefetchTsFileBatchMaxSizeInBytes = 0x5000000L;
    private int subscriptionPollMaxBlockingTimeMs = 500;
    private int subscriptionSerializeMaxBlockingTimeMs = 100;
    private long subscriptionLaunchRetryIntervalMs = 1000L;
    private int subscriptionRecycleUncommittedEventIntervalMs = 600000;
    private long subscriptionReadFileBufferSize = 0x800000L;
    private long subscriptionReadTabletBufferSize = 0x800000L;
    private long subscriptionTsFileDeduplicationWindowSeconds = 120L;
    private String schemaEngineMode = "Memory";
    private boolean lastCacheEnable = true;
    private int tagAttributeTotalSize = 700;
    private int databaseLimitThreshold = -1;
    private long datanodeTokenTimeoutMS = 180000L;
    private long seriesLimitThreshold = -1L;
    private long deviceLimitThreshold = -1L;
    private final long startUpNanosecond = System.nanoTime();
    private final boolean isIntegrationTest = System.getProperties().containsKey("integrationTestKillPoints");
    private final Set<String> enabledKillPoints = KillPoint.parseKillPoints(System.getProperty("integrationTestKillPoints"));
    private volatile boolean retryForUnknownErrors = false;
    private volatile long remoteWriteMaxRetryDurationInMs = 60000L;

    CommonConfig() {
    }

    public void updatePath(String homeDir) {
        if (homeDir == null) {
            return;
        }
        File homeFile = new File(homeDir);
        try {
            homeDir = homeFile.getCanonicalPath();
        }
        catch (IOException e) {
            logger.error("Fail to get canonical path of {}", (Object)homeFile, (Object)e);
        }
        this.userFolder = FileUtils.addPrefix2FilePath(homeDir, this.userFolder);
        this.roleFolder = FileUtils.addPrefix2FilePath(homeDir, this.roleFolder);
        this.procedureWalFolder = FileUtils.addPrefix2FilePath(homeDir, this.procedureWalFolder);
        this.syncDir = FileUtils.addPrefix2FilePath(homeDir, this.syncDir);
        for (int i = 0; i < this.walDirs.length; ++i) {
            this.walDirs[i] = FileUtils.addPrefix2FilePath(homeDir, this.walDirs[i]);
        }
    }

    public String getEncryptDecryptProvider() {
        return this.encryptDecryptProvider;
    }

    public void setEncryptDecryptProvider(String encryptDecryptProvider) {
        this.encryptDecryptProvider = encryptDecryptProvider;
    }

    public String getEncryptDecryptProviderParameter() {
        return this.encryptDecryptProviderParameter;
    }

    public void setEncryptDecryptProviderParameter(String encryptDecryptProviderParameter) {
        this.encryptDecryptProviderParameter = encryptDecryptProviderParameter;
    }

    public String getOpenIdProviderUrl() {
        return this.openIdProviderUrl;
    }

    public void setOpenIdProviderUrl(String openIdProviderUrl) {
        this.openIdProviderUrl = openIdProviderUrl;
    }

    public String getAuthorizerProvider() {
        return this.authorizerProvider;
    }

    public void setAuthorizerProvider(String authorizerProvider) {
        this.authorizerProvider = authorizerProvider;
    }

    public String getAdminName() {
        return this.adminName;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getOldUserFolder() {
        return this.oldUserFolder;
    }

    public String getOldRoleFolder() {
        return this.oldRoleFolder;
    }

    public String getOldProcedureWalFolder() {
        return this.oldProcedureWalFolder;
    }

    public String getUserFolder() {
        return this.userFolder;
    }

    public void setUserFolder(String userFolder) {
        this.userFolder = userFolder;
    }

    public String getRoleFolder() {
        return this.roleFolder;
    }

    public void setRoleFolder(String roleFolder) {
        this.roleFolder = roleFolder;
    }

    public String getProcedureWalFolder() {
        return this.procedureWalFolder;
    }

    public void setProcedureWalFolder(String procedureWalFolder) {
        this.procedureWalFolder = procedureWalFolder;
    }

    public String getSyncDir() {
        return this.syncDir;
    }

    public void setSyncDir(String syncDir) {
        this.syncDir = syncDir;
    }

    public String[] getWalDirs() {
        return this.walDirs;
    }

    public void setWalDirs(String[] walDirs) {
        this.walDirs = walDirs;
    }

    public FSType getSystemFileStorageFs() {
        return this.systemFileStorageFs;
    }

    public void setSystemFileStorageFs(FSType systemFileStorageFs) {
        this.systemFileStorageFs = systemFileStorageFs;
    }

    public long[] getTierTTLInMs() {
        return this.tierTTLInMs;
    }

    public void setTierTTLInMs(long[] tierTTLInMs) {
        this.tierTTLInMs = tierTTLInMs;
    }

    public int getTTlRuleCapacity() {
        return this.ttlRuleCapacity;
    }

    public void setTTlRuleCapacity(int ttlRuleCapacity) {
        this.ttlRuleCapacity = ttlRuleCapacity;
    }

    public int getConnectionTimeoutInMS() {
        return this.connectionTimeoutInMS;
    }

    public void setConnectionTimeoutInMS(int connectionTimeoutInMS) {
        this.connectionTimeoutInMS = connectionTimeoutInMS;
    }

    public int getSelectorNumOfClientManager() {
        return this.selectorNumOfClientManager;
    }

    public void setSelectorNumOfClientManager(int selectorNumOfClientManager) {
        this.selectorNumOfClientManager = selectorNumOfClientManager;
    }

    public boolean isRpcThriftCompressionEnabled() {
        return this.isRpcThriftCompressionEnabled;
    }

    public void setRpcThriftCompressionEnabled(boolean rpcThriftCompressionEnabled) {
        this.isRpcThriftCompressionEnabled = rpcThriftCompressionEnabled;
    }

    public int getMaxClientNumForEachNode() {
        return this.maxClientNumForEachNode;
    }

    public void setMaxClientNumForEachNode(int maxClientNumForEachNode) {
        this.maxClientNumForEachNode = maxClientNumForEachNode;
    }

    HandleSystemErrorStrategy getHandleSystemErrorStrategy() {
        return this.handleSystemErrorStrategy;
    }

    void setHandleSystemErrorStrategy(HandleSystemErrorStrategy handleSystemErrorStrategy) {
        this.handleSystemErrorStrategy = handleSystemErrorStrategy;
    }

    public void handleUnrecoverableError() {
        this.handleSystemErrorStrategy.handle();
    }

    public double getDiskSpaceWarningThreshold() {
        return this.diskSpaceWarningThreshold;
    }

    public void setDiskSpaceWarningThreshold(double diskSpaceWarningThreshold) {
        this.diskSpaceWarningThreshold = diskSpaceWarningThreshold;
    }

    public boolean isReadOnly() {
        return this.status == NodeStatus.ReadOnly;
    }

    public boolean isRunning() {
        return this.status == NodeStatus.Running;
    }

    public NodeStatus getNodeStatus() {
        return this.status;
    }

    public void setNodeStatus(NodeStatus newStatus) {
        logger.info("Set system mode from {} to {}.", (Object)this.status, (Object)newStatus);
        this.status = newStatus;
        this.statusReason = null;
        switch (newStatus) {
            case ReadOnly: {
                logger.warn("Change system status to ReadOnly! Only query statements are permitted!");
                break;
            }
            case Removing: {
                logger.info("Change system status to Removing! The current Node is being removed from cluster!");
                break;
            }
        }
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public NodeStatus getStatus() {
        return this.status;
    }

    public void setStatus(NodeStatus status) {
        this.status = status;
    }

    public TEndPoint getTargetAINodeEndPoint() {
        return this.targetAINodeEndPoint;
    }

    public void setTargetAINodeEndPoint(TEndPoint targetAINodeEndPoint) {
        this.targetAINodeEndPoint = targetAINodeEndPoint;
    }

    public int getTTimePartitionSlotTransmitLimit() {
        return 1000;
    }

    public boolean isStopping() {
        return this.isStopping;
    }

    public void setStopping(boolean stopping) {
        this.isStopping = stopping;
    }

    public long getTimePartitionOrigin() {
        return this.timePartitionOrigin;
    }

    public void setTimePartitionOrigin(long timePartitionOrigin) {
        this.timePartitionOrigin = timePartitionOrigin;
    }

    public long getTimePartitionInterval() {
        return this.timePartitionInterval;
    }

    public void setTimePartitionInterval(long timePartitionInterval) {
        this.timePartitionInterval = timePartitionInterval;
    }

    public void setTimestampPrecision(String timestampPrecision) {
        if (!("ms".equals(timestampPrecision) || "us".equals(timestampPrecision) || "ns".equals(timestampPrecision))) {
            logger.error("Wrong timestamp precision, please set as: ms, us or ns ! Current is: {}", (Object)timestampPrecision);
            System.exit(-1);
        }
        this.timestampPrecision = timestampPrecision;
    }

    public String getTimestampPrecision() {
        return this.timestampPrecision;
    }

    public void setTimestampPrecisionCheckEnabled(boolean timestampPrecisionCheckEnabled) {
        this.timestampPrecisionCheckEnabled = timestampPrecisionCheckEnabled;
    }

    public boolean isTimestampPrecisionCheckEnabled() {
        return this.timestampPrecisionCheckEnabled;
    }

    public int getPipeNonForwardingEventsProgressReportInterval() {
        return this.pipeNonForwardingEventsProgressReportInterval;
    }

    public void setPipeNonForwardingEventsProgressReportInterval(int pipeNonForwardingEventsProgressReportInterval) {
        this.pipeNonForwardingEventsProgressReportInterval = pipeNonForwardingEventsProgressReportInterval;
    }

    public String getPipeHardlinkBaseDirName() {
        return this.pipeHardlinkBaseDirName;
    }

    public void setPipeHardlinkBaseDirName(String pipeHardlinkBaseDirName) {
        this.pipeHardlinkBaseDirName = pipeHardlinkBaseDirName;
    }

    public String getPipeHardlinkTsFileDirName() {
        return this.pipeHardlinkTsFileDirName;
    }

    public void setPipeHardlinkTsFileDirName(String pipeTsFileDirName) {
        this.pipeHardlinkTsFileDirName = pipeTsFileDirName;
    }

    public String getPipeHardlinkWALDirName() {
        return this.pipeHardlinkWALDirName;
    }

    public void setPipeHardlinkWALDirName(String pipeWALDirName) {
        this.pipeHardlinkWALDirName = pipeWALDirName;
    }

    public boolean getPipeHardLinkWALEnabled() {
        return this.pipeHardLinkWALEnabled;
    }

    public void setPipeHardLinkWALEnabled(boolean pipeHardLinkWALEnabled) {
        this.pipeHardLinkWALEnabled = pipeHardLinkWALEnabled;
    }

    public int getPipeDataStructureTabletRowSize() {
        return this.pipeDataStructureTabletRowSize;
    }

    public void setPipeDataStructureTabletRowSize(int pipeDataStructureTabletRowSize) {
        this.pipeDataStructureTabletRowSize = pipeDataStructureTabletRowSize;
    }

    public int getPipeDataStructureTabletSizeInBytes() {
        return this.pipeDataStructureTabletSizeInBytes;
    }

    public void setPipeDataStructureTabletSizeInBytes(int pipeDataStructureTabletSizeInBytes) {
        this.pipeDataStructureTabletSizeInBytes = pipeDataStructureTabletSizeInBytes;
    }

    public double getPipeDataStructureTabletMemoryBlockAllocationRejectThreshold() {
        return this.pipeDataStructureTabletMemoryBlockAllocationRejectThreshold;
    }

    public void setPipeDataStructureTabletMemoryBlockAllocationRejectThreshold(double pipeDataStructureTabletMemoryBlockAllocationRejectThreshold) {
        this.pipeDataStructureTabletMemoryBlockAllocationRejectThreshold = pipeDataStructureTabletMemoryBlockAllocationRejectThreshold;
    }

    public int getPipeExtractorAssignerDisruptorRingBufferSize() {
        return this.pipeExtractorAssignerDisruptorRingBufferSize;
    }

    public void setPipeExtractorAssignerDisruptorRingBufferSize(int pipeExtractorAssignerDisruptorRingBufferSize) {
        this.pipeExtractorAssignerDisruptorRingBufferSize = pipeExtractorAssignerDisruptorRingBufferSize;
    }

    public long getPipeExtractorAssignerDisruptorRingBufferEntrySizeInBytes() {
        return this.pipeExtractorAssignerDisruptorRingBufferEntrySizeInBytes;
    }

    public void setPipeExtractorAssignerDisruptorRingBufferEntrySizeInBytes(long pipeExtractorAssignerDisruptorRingBufferEntrySize) {
        this.pipeExtractorAssignerDisruptorRingBufferEntrySizeInBytes = pipeExtractorAssignerDisruptorRingBufferEntrySize;
    }

    public int getPipeExtractorMatcherCacheSize() {
        return this.pipeExtractorMatcherCacheSize;
    }

    public void setPipeExtractorMatcherCacheSize(int pipeExtractorMatcherCacheSize) {
        this.pipeExtractorMatcherCacheSize = pipeExtractorMatcherCacheSize;
    }

    public int getPipeConnectorHandshakeTimeoutMs() {
        return this.pipeConnectorHandshakeTimeoutMs;
    }

    public void setPipeConnectorHandshakeTimeoutMs(long pipeConnectorHandshakeTimeoutMs) {
        try {
            this.pipeConnectorHandshakeTimeoutMs = Math.toIntExact(pipeConnectorHandshakeTimeoutMs);
        }
        catch (ArithmeticException e) {
            this.pipeConnectorHandshakeTimeoutMs = Integer.MAX_VALUE;
            logger.warn("Given pipe connector handshake timeout is too large, set to {} ms.", (Object)Integer.MAX_VALUE);
        }
    }

    public int getPipeConnectorTransferTimeoutMs() {
        return this.pipeConnectorTransferTimeoutMs;
    }

    public void setPipeConnectorTransferTimeoutMs(long pipeConnectorTransferTimeoutMs) {
        try {
            this.pipeConnectorTransferTimeoutMs = Math.toIntExact(pipeConnectorTransferTimeoutMs);
        }
        catch (ArithmeticException e) {
            this.pipeConnectorTransferTimeoutMs = Integer.MAX_VALUE;
            logger.warn("Given pipe connector transfer timeout is too large, set to {} ms.", (Object)Integer.MAX_VALUE);
        }
    }

    public int getPipeConnectorReadFileBufferSize() {
        return this.pipeConnectorReadFileBufferSize;
    }

    public void setPipeConnectorReadFileBufferSize(int pipeConnectorReadFileBufferSize) {
        this.pipeConnectorReadFileBufferSize = pipeConnectorReadFileBufferSize;
    }

    public void setPipeConnectorRPCThriftCompressionEnabled(boolean pipeConnectorRPCThriftCompressionEnabled) {
        this.pipeConnectorRPCThriftCompressionEnabled = pipeConnectorRPCThriftCompressionEnabled;
    }

    public boolean isPipeConnectorRPCThriftCompressionEnabled() {
        return this.pipeConnectorRPCThriftCompressionEnabled;
    }

    public int getPipeAsyncConnectorSelectorNumber() {
        return this.pipeAsyncConnectorSelectorNumber;
    }

    public void setPipeAsyncConnectorSelectorNumber(int pipeAsyncConnectorSelectorNumber) {
        this.pipeAsyncConnectorSelectorNumber = pipeAsyncConnectorSelectorNumber;
    }

    public int getPipeAsyncConnectorMaxClientNumber() {
        return this.pipeAsyncConnectorMaxClientNumber;
    }

    public void setPipeAsyncConnectorMaxClientNumber(int pipeAsyncConnectorMaxClientNumber) {
        this.pipeAsyncConnectorMaxClientNumber = pipeAsyncConnectorMaxClientNumber;
    }

    public boolean isSeperatedPipeHeartbeatEnabled() {
        return this.isSeperatedPipeHeartbeatEnabled;
    }

    public void setSeperatedPipeHeartbeatEnabled(boolean isSeperatedPipeHeartbeatEnabled) {
        this.isSeperatedPipeHeartbeatEnabled = isSeperatedPipeHeartbeatEnabled;
    }

    public int getPipeHeartbeatIntervalSecondsForCollectingPipeMeta() {
        return this.pipeHeartbeatIntervalSecondsForCollectingPipeMeta;
    }

    public void setPipeHeartbeatIntervalSecondsForCollectingPipeMeta(int pipeHeartbeatIntervalSecondsForCollectingPipeMeta) {
        this.pipeHeartbeatIntervalSecondsForCollectingPipeMeta = pipeHeartbeatIntervalSecondsForCollectingPipeMeta;
    }

    public long getPipeMetaSyncerInitialSyncDelayMinutes() {
        return this.pipeMetaSyncerInitialSyncDelayMinutes;
    }

    public void setPipeMetaSyncerInitialSyncDelayMinutes(long pipeMetaSyncerInitialSyncDelayMinutes) {
        this.pipeMetaSyncerInitialSyncDelayMinutes = pipeMetaSyncerInitialSyncDelayMinutes;
    }

    public long getPipeMetaSyncerSyncIntervalMinutes() {
        return this.pipeMetaSyncerSyncIntervalMinutes;
    }

    public void setPipeMetaSyncerSyncIntervalMinutes(long pipeMetaSyncerSyncIntervalMinutes) {
        this.pipeMetaSyncerSyncIntervalMinutes = pipeMetaSyncerSyncIntervalMinutes;
    }

    public long getPipeMetaSyncerAutoRestartPipeCheckIntervalRound() {
        return this.pipeMetaSyncerAutoRestartPipeCheckIntervalRound;
    }

    public void setPipeMetaSyncerAutoRestartPipeCheckIntervalRound(long pipeMetaSyncerAutoRestartPipeCheckIntervalRound) {
        this.pipeMetaSyncerAutoRestartPipeCheckIntervalRound = pipeMetaSyncerAutoRestartPipeCheckIntervalRound;
    }

    public boolean getPipeAutoRestartEnabled() {
        return this.pipeAutoRestartEnabled;
    }

    public void setPipeAutoRestartEnabled(boolean pipeAutoRestartEnabled) {
        this.pipeAutoRestartEnabled = pipeAutoRestartEnabled;
    }

    public long getPipeConnectorRetryIntervalMs() {
        return this.pipeConnectorRetryIntervalMs;
    }

    public void setPipeConnectorRetryIntervalMs(long pipeConnectorRetryIntervalMs) {
        this.pipeConnectorRetryIntervalMs = pipeConnectorRetryIntervalMs;
    }

    public int getPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount() {
        return this.pipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount;
    }

    public void setPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount(int pipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount) {
        this.pipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount = pipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount;
    }

    public long getPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration() {
        return this.pipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration;
    }

    public void setPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration(long pipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration) {
        this.pipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration = pipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration;
    }

    public int getPipeSubtaskExecutorMaxThreadNum() {
        return this.pipeSubtaskExecutorMaxThreadNum;
    }

    public void setPipeSubtaskExecutorMaxThreadNum(int pipeSubtaskExecutorMaxThreadNum) {
        this.pipeSubtaskExecutorMaxThreadNum = Math.min(pipeSubtaskExecutorMaxThreadNum, Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
    }

    public long getPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs() {
        return this.pipeSubtaskExecutorPendingQueueMaxBlockingTimeMs;
    }

    public void setPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs(long pipeSubtaskExecutorPendingQueueMaxBlockingTimeMs) {
        this.pipeSubtaskExecutorPendingQueueMaxBlockingTimeMs = pipeSubtaskExecutorPendingQueueMaxBlockingTimeMs;
    }

    public long getPipeSubtaskExecutorCronHeartbeatEventIntervalSeconds() {
        return this.pipeSubtaskExecutorCronHeartbeatEventIntervalSeconds;
    }

    public void setPipeSubtaskExecutorCronHeartbeatEventIntervalSeconds(long pipeSubtaskExecutorCronHeartbeatEventIntervalSeconds) {
        this.pipeSubtaskExecutorCronHeartbeatEventIntervalSeconds = pipeSubtaskExecutorCronHeartbeatEventIntervalSeconds;
    }

    public long getPipeSubtaskExecutorForcedRestartIntervalMs() {
        return this.pipeSubtaskExecutorForcedRestartIntervalMs;
    }

    public void setPipeSubtaskExecutorForcedRestartIntervalMs(long pipeSubtaskExecutorForcedRestartIntervalMs) {
        this.pipeSubtaskExecutorForcedRestartIntervalMs = pipeSubtaskExecutorForcedRestartIntervalMs;
    }

    public int getPipeRealTimeQueuePollHistoryThreshold() {
        return this.pipeRealTimeQueuePollHistoryThreshold;
    }

    public void setPipeRealTimeQueuePollHistoryThreshold(int pipeRealTimeQueuePollHistoryThreshold) {
        this.pipeRealTimeQueuePollHistoryThreshold = pipeRealTimeQueuePollHistoryThreshold;
    }

    public void setPipeAirGapReceiverEnabled(boolean pipeAirGapReceiverEnabled) {
        this.pipeAirGapReceiverEnabled = pipeAirGapReceiverEnabled;
    }

    public boolean getPipeAirGapReceiverEnabled() {
        return this.pipeAirGapReceiverEnabled;
    }

    public void setPipeAirGapReceiverPort(int pipeAirGapReceiverPort) {
        this.pipeAirGapReceiverPort = pipeAirGapReceiverPort;
    }

    public int getPipeAirGapReceiverPort() {
        return this.pipeAirGapReceiverPort;
    }

    public int getPipeMaxAllowedHistoricalTsFilePerDataRegion() {
        return this.pipeMaxAllowedHistoricalTsFilePerDataRegion;
    }

    public void setPipeMaxAllowedHistoricalTsFilePerDataRegion(int pipeMaxAllowedPendingTsFileEpochPerDataRegion) {
        this.pipeMaxAllowedHistoricalTsFilePerDataRegion = pipeMaxAllowedPendingTsFileEpochPerDataRegion;
    }

    public int getPipeMaxAllowedPendingTsFileEpochPerDataRegion() {
        return this.pipeMaxAllowedPendingTsFileEpochPerDataRegion;
    }

    public void setPipeMaxAllowedPendingTsFileEpochPerDataRegion(int pipeExtractorPendingQueueTsfileLimit) {
        this.pipeMaxAllowedPendingTsFileEpochPerDataRegion = pipeExtractorPendingQueueTsfileLimit;
    }

    public int getPipeMaxAllowedPinnedMemTableCount() {
        return this.pipeMaxAllowedPinnedMemTableCount;
    }

    public void setPipeMaxAllowedPinnedMemTableCount(int pipeMaxAllowedPinnedMemTableCount) {
        this.pipeMaxAllowedPinnedMemTableCount = pipeMaxAllowedPinnedMemTableCount;
    }

    public long getPipeMaxAllowedLinkedTsFileCount() {
        return this.pipeMaxAllowedLinkedTsFileCount;
    }

    public void setPipeMaxAllowedLinkedTsFileCount(long pipeMaxAllowedLinkedTsFileCount) {
        this.pipeMaxAllowedLinkedTsFileCount = pipeMaxAllowedLinkedTsFileCount;
    }

    public float getPipeMaxAllowedLinkedDeletedTsFileDiskUsagePercentage() {
        return this.pipeMaxAllowedLinkedDeletedTsFileDiskUsagePercentage;
    }

    public void setPipeMaxAllowedLinkedDeletedTsFileDiskUsagePercentage(float pipeMaxAllowedLinkedDeletedTsFileDiskUsagePercentage) {
        this.pipeMaxAllowedLinkedDeletedTsFileDiskUsagePercentage = pipeMaxAllowedLinkedDeletedTsFileDiskUsagePercentage;
    }

    public long getPipeStuckRestartIntervalSeconds() {
        return this.pipeStuckRestartIntervalSeconds;
    }

    public void setPipeStuckRestartIntervalSeconds(long pipeStuckRestartIntervalSeconds) {
        this.pipeStuckRestartIntervalSeconds = pipeStuckRestartIntervalSeconds;
    }

    public int getPipeMetaReportMaxLogNumPerRound() {
        return this.pipeMetaReportMaxLogNumPerRound;
    }

    public void setPipeMetaReportMaxLogNumPerRound(int pipeMetaReportMaxLogNumPerRound) {
        this.pipeMetaReportMaxLogNumPerRound = pipeMetaReportMaxLogNumPerRound;
    }

    public int getPipeMetaReportMaxLogIntervalRounds() {
        return this.pipeMetaReportMaxLogIntervalRounds;
    }

    public void setPipeMetaReportMaxLogIntervalRounds(int pipeMetaReportMaxLogIntervalRounds) {
        this.pipeMetaReportMaxLogIntervalRounds = pipeMetaReportMaxLogIntervalRounds;
    }

    public int getPipeTsFilePinMaxLogNumPerRound() {
        return this.pipeTsFilePinMaxLogNumPerRound;
    }

    public void setPipeTsFilePinMaxLogNumPerRound(int pipeTsFilePinMaxLogNumPerRound) {
        this.pipeTsFilePinMaxLogNumPerRound = pipeTsFilePinMaxLogNumPerRound;
    }

    public int getPipeTsFilePinMaxLogIntervalRounds() {
        return this.pipeTsFilePinMaxLogIntervalRounds;
    }

    public void setPipeTsFilePinMaxLogIntervalRounds(int pipeTsFilePinMaxLogIntervalRounds) {
        this.pipeTsFilePinMaxLogIntervalRounds = pipeTsFilePinMaxLogIntervalRounds;
    }

    public int getPipeWalPinMaxLogNumPerRound() {
        return this.pipeWalPinMaxLogNumPerRound;
    }

    public void setPipeWalPinMaxLogNumPerRound(int pipeWalPinMaxLogNumPerRound) {
        this.pipeWalPinMaxLogNumPerRound = pipeWalPinMaxLogNumPerRound;
    }

    public int getPipeWalPinMaxLogIntervalRounds() {
        return this.pipeWalPinMaxLogIntervalRounds;
    }

    public void setPipeWalPinMaxLogIntervalRounds(int pipeWalPinMaxLogIntervalRounds) {
        this.pipeWalPinMaxLogIntervalRounds = pipeWalPinMaxLogIntervalRounds;
    }

    public boolean getPipeMemoryManagementEnabled() {
        return this.pipeMemoryManagementEnabled;
    }

    public void setPipeMemoryManagementEnabled(boolean pipeMemoryManagementEnabled) {
        this.pipeMemoryManagementEnabled = pipeMemoryManagementEnabled;
    }

    public long getPipeMemoryAllocateForTsFileSequenceReaderInBytes() {
        return this.pipeMemoryAllocateForTsFileSequenceReaderInBytes;
    }

    public void setPipeMemoryAllocateForTsFileSequenceReaderInBytes(long pipeMemoryAllocateForTsFileSequenceReaderInBytes) {
        this.pipeMemoryAllocateForTsFileSequenceReaderInBytes = pipeMemoryAllocateForTsFileSequenceReaderInBytes;
    }

    public long getPipeMemoryExpanderIntervalSeconds() {
        return this.pipeMemoryExpanderIntervalSeconds;
    }

    public void setPipeMemoryExpanderIntervalSeconds(long pipeMemoryExpanderIntervalSeconds) {
        this.pipeMemoryExpanderIntervalSeconds = pipeMemoryExpanderIntervalSeconds;
    }

    public int getPipeMemoryAllocateMaxRetries() {
        return this.pipeMemoryAllocateMaxRetries;
    }

    public void setPipeMemoryAllocateMaxRetries(int pipeMemoryAllocateMaxRetries) {
        this.pipeMemoryAllocateMaxRetries = pipeMemoryAllocateMaxRetries;
    }

    public long getPipeMemoryAllocateRetryIntervalInMs() {
        return this.pipeMemoryAllocateRetryIntervalMs;
    }

    public void setPipeMemoryAllocateRetryIntervalInMs(long pipeMemoryAllocateRetryIntervalMs) {
        this.pipeMemoryAllocateRetryIntervalMs = pipeMemoryAllocateRetryIntervalMs;
    }

    public long getPipeMemoryAllocateMinSizeInBytes() {
        return this.pipeMemoryAllocateMinSizeInBytes;
    }

    public void setPipeMemoryAllocateMinSizeInBytes(long pipeMemoryAllocateMinSizeInBytes) {
        this.pipeMemoryAllocateMinSizeInBytes = pipeMemoryAllocateMinSizeInBytes;
    }

    public float getPipeLeaderCacheMemoryUsagePercentage() {
        return this.pipeLeaderCacheMemoryUsagePercentage;
    }

    public void setPipeLeaderCacheMemoryUsagePercentage(float pipeLeaderCacheMemoryUsagePercentage) {
        this.pipeLeaderCacheMemoryUsagePercentage = pipeLeaderCacheMemoryUsagePercentage;
    }

    public long getPipeListeningQueueTransferSnapshotThreshold() {
        return this.pipeListeningQueueTransferSnapshotThreshold;
    }

    public void setPipeListeningQueueTransferSnapshotThreshold(long pipeListeningQueueTransferSnapshotThreshold) {
        this.pipeListeningQueueTransferSnapshotThreshold = pipeListeningQueueTransferSnapshotThreshold;
    }

    public int getPipeSnapshotExecutionMaxBatchSize() {
        return this.pipeSnapshotExecutionMaxBatchSize;
    }

    public void setPipeSnapshotExecutionMaxBatchSize(int pipeSnapshotExecutionMaxBatchSize) {
        this.pipeSnapshotExecutionMaxBatchSize = pipeSnapshotExecutionMaxBatchSize;
    }

    public long getPipeRemainingTimeCommitRateAutoSwitchSeconds() {
        return this.pipeRemainingTimeCommitRateAutoSwitchSeconds;
    }

    public void setPipeRemainingTimeCommitRateAutoSwitchSeconds(long pipeRemainingTimeCommitRateAutoSwitchSeconds) {
        this.pipeRemainingTimeCommitRateAutoSwitchSeconds = pipeRemainingTimeCommitRateAutoSwitchSeconds;
    }

    public PipeRemainingTimeRateAverageTime getPipeRemainingTimeCommitRateAverageTime() {
        return this.pipeRemainingTimeCommitRateAverageTime;
    }

    public void setPipeRemainingTimeCommitRateAverageTime(PipeRemainingTimeRateAverageTime pipeRemainingTimeCommitRateAverageTime) {
        this.pipeRemainingTimeCommitRateAverageTime = pipeRemainingTimeCommitRateAverageTime;
    }

    public double getPipeTsFileScanParsingThreshold() {
        return this.pipeTsFileScanParsingThreshold;
    }

    public void setPipeTsFileScanParsingThreshold(double pipeTsFileScanParsingThreshold) {
        this.pipeTsFileScanParsingThreshold = pipeTsFileScanParsingThreshold;
    }

    public double getPipeAllSinksRateLimitBytesPerSecond() {
        return this.pipeAllSinksRateLimitBytesPerSecond;
    }

    public void setPipeAllSinksRateLimitBytesPerSecond(double pipeAllSinksRateLimitBytesPerSecond) {
        this.pipeAllSinksRateLimitBytesPerSecond = pipeAllSinksRateLimitBytesPerSecond;
    }

    public int getRateLimiterHotReloadCheckIntervalMs() {
        return this.rateLimiterHotReloadCheckIntervalMs;
    }

    public void setRateLimiterHotReloadCheckIntervalMs(int rateLimiterHotReloadCheckIntervalMs) {
        this.rateLimiterHotReloadCheckIntervalMs = rateLimiterHotReloadCheckIntervalMs;
    }

    public int getPipeConnectorRequestSliceThresholdBytes() {
        return this.pipeConnectorRequestSliceThresholdBytes;
    }

    public void setPipeConnectorRequestSliceThresholdBytes(int pipeConnectorRequestSliceThresholdBytes) {
        this.pipeConnectorRequestSliceThresholdBytes = pipeConnectorRequestSliceThresholdBytes;
    }

    public long getTwoStageAggregateMaxCombinerLiveTimeInMs() {
        return this.twoStageAggregateMaxCombinerLiveTimeInMs;
    }

    public void setTwoStageAggregateMaxCombinerLiveTimeInMs(long twoStageAggregateMaxCombinerLiveTimeInMs) {
        this.twoStageAggregateMaxCombinerLiveTimeInMs = twoStageAggregateMaxCombinerLiveTimeInMs;
    }

    public long getTwoStageAggregateDataRegionInfoCacheTimeInMs() {
        return this.twoStageAggregateDataRegionInfoCacheTimeInMs;
    }

    public void setTwoStageAggregateDataRegionInfoCacheTimeInMs(long twoStageAggregateDataRegionInfoCacheTimeInMs) {
        this.twoStageAggregateDataRegionInfoCacheTimeInMs = twoStageAggregateDataRegionInfoCacheTimeInMs;
    }

    public long getTwoStageAggregateSenderEndPointsCacheInMs() {
        return this.twoStageAggregateSenderEndPointsCacheInMs;
    }

    public void setTwoStageAggregateSenderEndPointsCacheInMs(long twoStageAggregateSenderEndPointsCacheInMs) {
        this.twoStageAggregateSenderEndPointsCacheInMs = twoStageAggregateSenderEndPointsCacheInMs;
    }

    public float getSubscriptionCacheMemoryUsagePercentage() {
        return this.subscriptionCacheMemoryUsagePercentage;
    }

    public void setSubscriptionCacheMemoryUsagePercentage(float subscriptionCacheMemoryUsagePercentage) {
        this.subscriptionCacheMemoryUsagePercentage = subscriptionCacheMemoryUsagePercentage;
    }

    public int getSubscriptionSubtaskExecutorMaxThreadNum() {
        return this.subscriptionSubtaskExecutorMaxThreadNum;
    }

    public void setSubscriptionSubtaskExecutorMaxThreadNum(int subscriptionSubtaskExecutorMaxThreadNum) {
        this.subscriptionSubtaskExecutorMaxThreadNum = Math.min(subscriptionSubtaskExecutorMaxThreadNum, Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
    }

    public int getSubscriptionPrefetchTabletBatchMaxDelayInMs() {
        return this.subscriptionPrefetchTabletBatchMaxDelayInMs;
    }

    public void setSubscriptionPrefetchTabletBatchMaxDelayInMs(int subscriptionPrefetchTabletBatchMaxDelayInMs) {
        this.subscriptionPrefetchTabletBatchMaxDelayInMs = subscriptionPrefetchTabletBatchMaxDelayInMs;
    }

    public long getSubscriptionPrefetchTabletBatchMaxSizeInBytes() {
        return this.subscriptionPrefetchTabletBatchMaxSizeInBytes;
    }

    public void setSubscriptionPrefetchTabletBatchMaxSizeInBytes(long subscriptionPrefetchTabletBatchMaxSizeInBytes) {
        this.subscriptionPrefetchTabletBatchMaxSizeInBytes = subscriptionPrefetchTabletBatchMaxSizeInBytes;
    }

    public int getSubscriptionPrefetchTsFileBatchMaxDelayInMs() {
        return this.subscriptionPrefetchTsFileBatchMaxDelayInMs;
    }

    public void setSubscriptionPrefetchTsFileBatchMaxDelayInMs(int subscriptionPrefetchTsFileBatchMaxDelayInMs) {
        this.subscriptionPrefetchTsFileBatchMaxDelayInMs = subscriptionPrefetchTsFileBatchMaxDelayInMs;
    }

    public long getSubscriptionPrefetchTsFileBatchMaxSizeInBytes() {
        return this.subscriptionPrefetchTsFileBatchMaxSizeInBytes;
    }

    public void setSubscriptionPrefetchTsFileBatchMaxSizeInBytes(long subscriptionPrefetchTsFileBatchMaxSizeInBytes) {
        this.subscriptionPrefetchTsFileBatchMaxSizeInBytes = subscriptionPrefetchTsFileBatchMaxSizeInBytes;
    }

    public int getSubscriptionPollMaxBlockingTimeMs() {
        return this.subscriptionPollMaxBlockingTimeMs;
    }

    public void setSubscriptionPollMaxBlockingTimeMs(int subscriptionPollMaxBlockingTimeMs) {
        this.subscriptionPollMaxBlockingTimeMs = subscriptionPollMaxBlockingTimeMs;
    }

    public int getSubscriptionSerializeMaxBlockingTimeMs() {
        return this.subscriptionSerializeMaxBlockingTimeMs;
    }

    public void setSubscriptionSerializeMaxBlockingTimeMs(int subscriptionSerializeMaxBlockingTimeMs) {
        this.subscriptionSerializeMaxBlockingTimeMs = subscriptionSerializeMaxBlockingTimeMs;
    }

    public long getSubscriptionLaunchRetryIntervalMs() {
        return this.subscriptionLaunchRetryIntervalMs;
    }

    public void setSubscriptionLaunchRetryIntervalMs(long subscriptionLaunchRetryIntervalMs) {
        this.subscriptionLaunchRetryIntervalMs = subscriptionLaunchRetryIntervalMs;
    }

    public int getSubscriptionRecycleUncommittedEventIntervalMs() {
        return this.subscriptionRecycleUncommittedEventIntervalMs;
    }

    public void setSubscriptionRecycleUncommittedEventIntervalMs(int subscriptionRecycleUncommittedEventIntervalMs) {
        this.subscriptionRecycleUncommittedEventIntervalMs = subscriptionRecycleUncommittedEventIntervalMs;
    }

    public long getSubscriptionReadFileBufferSize() {
        return this.subscriptionReadFileBufferSize;
    }

    public void setSubscriptionReadFileBufferSize(long subscriptionReadFileBufferSize) {
        this.subscriptionReadFileBufferSize = subscriptionReadFileBufferSize;
    }

    public long getSubscriptionReadTabletBufferSize() {
        return this.subscriptionReadTabletBufferSize;
    }

    public void setSubscriptionReadTabletBufferSize(long subscriptionReadTabletBufferSize) {
        this.subscriptionReadTabletBufferSize = subscriptionReadTabletBufferSize;
    }

    public long getSubscriptionTsFileDeduplicationWindowSeconds() {
        return this.subscriptionTsFileDeduplicationWindowSeconds;
    }

    public void setSubscriptionTsFileDeduplicationWindowSeconds(long subscriptionTsFileDeduplicationWindowSeconds) {
        this.subscriptionTsFileDeduplicationWindowSeconds = subscriptionTsFileDeduplicationWindowSeconds;
    }

    public String getSchemaEngineMode() {
        return this.schemaEngineMode;
    }

    public void setSchemaEngineMode(String schemaEngineMode) {
        this.schemaEngineMode = schemaEngineMode;
    }

    public boolean isLastCacheEnable() {
        return this.lastCacheEnable;
    }

    public void setLastCacheEnable(boolean lastCacheEnable) {
        this.lastCacheEnable = lastCacheEnable;
    }

    public int getTagAttributeTotalSize() {
        return this.tagAttributeTotalSize;
    }

    public void setTagAttributeTotalSize(int tagAttributeTotalSize) {
        this.tagAttributeTotalSize = tagAttributeTotalSize;
    }

    public int getDatabaseLimitThreshold() {
        return this.databaseLimitThreshold;
    }

    public void setDatabaseLimitThreshold(int databaseLimitThreshold) {
        this.databaseLimitThreshold = databaseLimitThreshold;
    }

    public int getModelInferenceExecutionThreadCount() {
        return this.modelInferenceExecutionThreadCount;
    }

    public void setModelInferenceExecutionThreadCount(int modelInferenceExecutionThreadCount) {
        this.modelInferenceExecutionThreadCount = modelInferenceExecutionThreadCount;
    }

    public long getDatanodeTokenTimeoutMS() {
        return this.datanodeTokenTimeoutMS;
    }

    public void setDatanodeTokenTimeoutMS(long timeoutMS) {
        this.datanodeTokenTimeoutMS = timeoutMS;
    }

    public long getSeriesLimitThreshold() {
        return this.seriesLimitThreshold;
    }

    public void setSeriesLimitThreshold(long seriesLimitThreshold) {
        this.seriesLimitThreshold = seriesLimitThreshold;
    }

    public long getDeviceLimitThreshold() {
        return this.deviceLimitThreshold;
    }

    public void setDeviceLimitThreshold(long deviceLimitThreshold) {
        this.deviceLimitThreshold = deviceLimitThreshold;
    }

    public long getStartUpNanosecond() {
        return this.startUpNanosecond;
    }

    public boolean isIntegrationTest() {
        return this.isIntegrationTest;
    }

    public Set<String> getEnabledKillPoints() {
        return this.enabledKillPoints;
    }

    public boolean isRetryForUnknownErrors() {
        return this.retryForUnknownErrors;
    }

    public void setRetryForUnknownErrors(boolean retryForUnknownErrors) {
        this.retryForUnknownErrors = retryForUnknownErrors;
    }

    public long getRemoteWriteMaxRetryDurationInMs() {
        return this.remoteWriteMaxRetryDurationInMs;
    }

    public void setRemoteWriteMaxRetryDurationInMs(long remoteWriteMaxRetryDurationInMs) {
        this.remoteWriteMaxRetryDurationInMs = remoteWriteMaxRetryDurationInMs;
    }
}

