/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.service.thrift;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TNodeLocations;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSetConfigurationReq;
import org.apache.iotdb.common.rpc.thrift.TSetSpaceQuotaReq;
import org.apache.iotdb.common.rpc.thrift.TSetTTLReq;
import org.apache.iotdb.common.rpc.thrift.TSetThrottleQuotaReq;
import org.apache.iotdb.common.rpc.thrift.TShowConfigurationResp;
import org.apache.iotdb.common.rpc.thrift.TShowTTLReq;
import org.apache.iotdb.common.rpc.thrift.TTestConnectionResp;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.conf.SystemPropertiesUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.read.ainode.GetAINodeConfigurationPlan;
import org.apache.iotdb.confignode.consensus.request.read.auth.AuthorReadPlan;
import org.apache.iotdb.confignode.consensus.request.read.database.CountDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.read.database.GetDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.read.datanode.GetDataNodeConfigurationPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetOrCreateDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.region.GetRegionInfoListPlan;
import org.apache.iotdb.confignode.consensus.request.read.ttl.ShowTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.ainode.RemoveAINodePlan;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.RemoveConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetDataReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetSchemaReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTimePartitionIntervalPlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.RemoveDataNodePlan;
import org.apache.iotdb.confignode.consensus.response.ainode.AINodeConfigurationResp;
import org.apache.iotdb.confignode.consensus.response.ainode.AINodeRegisterResp;
import org.apache.iotdb.confignode.consensus.response.auth.PermissionInfoResp;
import org.apache.iotdb.confignode.consensus.response.database.CountDatabaseResp;
import org.apache.iotdb.confignode.consensus.response.database.DatabaseSchemaResp;
import org.apache.iotdb.confignode.consensus.response.datanode.ConfigurationResp;
import org.apache.iotdb.confignode.consensus.response.datanode.DataNodeConfigurationResp;
import org.apache.iotdb.confignode.consensus.response.datanode.DataNodeRegisterResp;
import org.apache.iotdb.confignode.consensus.response.datanode.DataNodeToStatusResp;
import org.apache.iotdb.confignode.consensus.response.partition.RegionInfoListResp;
import org.apache.iotdb.confignode.consensus.response.ttl.ShowTTLResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.consensus.ConsensusManager;
import org.apache.iotdb.confignode.rpc.thrift.IConfigNodeRPCService;
import org.apache.iotdb.confignode.rpc.thrift.TAINodeConfigurationResp;
import org.apache.iotdb.confignode.rpc.thrift.TAINodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TAINodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TAINodeRemoveReq;
import org.apache.iotdb.confignode.rpc.thrift.TAINodeRestartReq;
import org.apache.iotdb.confignode.rpc.thrift.TAINodeRestartResp;
import org.apache.iotdb.confignode.rpc.thrift.TAddConsensusGroupReq;
import org.apache.iotdb.confignode.rpc.thrift.TAlterLogicalViewReq;
import org.apache.iotdb.confignode.rpc.thrift.TAlterPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TAlterSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TAuthizedPatternTreeResp;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerReq;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerResp;
import org.apache.iotdb.confignode.rpc.thrift.TCheckUserPrivilegesReq;
import org.apache.iotdb.confignode.rpc.thrift.TCloseConsumerReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeHeartbeatReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeHeartbeatResp;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TCountDatabaseResp;
import org.apache.iotdb.confignode.rpc.thrift.TCountTimeSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TCountTimeSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TCreateCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateConsumerReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateModelReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipePluginReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTopicReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeConfigurationResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRemoveReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRemoveResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRestartReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRestartResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchemaResp;
import org.apache.iotdb.confignode.rpc.thrift.TDeactivateSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteDatabaseReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteDatabasesReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteLogicalViewReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteTimeSeriesReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropModelReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropPipePluginReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropTopicReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllPipeInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllSubscriptionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllTopicInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetClusterIdResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetDataNodeLocationsResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetDatabaseReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetLocationForTriggerResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetModelInfoReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetModelInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPathsSetTemplatesReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetPathsSetTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPipePluginTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetRegionIdReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetRegionIdResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetSeriesSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetSeriesSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTemplateResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTimeSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetTimeSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTriggerTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetUDFTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TLoginReq;
import org.apache.iotdb.confignode.rpc.thrift.TMigrateRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TPipeConfigTransferReq;
import org.apache.iotdb.confignode.rpc.thrift.TPipeConfigTransferResp;
import org.apache.iotdb.confignode.rpc.thrift.TRegionRouteMapResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementReq;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionReq;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TSetDataNodeStatusReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetDataReplicationFactorReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetSchemaReplicationFactorReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetTimePartitionIntervalReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowAINodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowCQResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowClusterResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowConfigNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowDataNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowDatabaseResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowModelReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowModelResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowSubscriptionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowSubscriptionResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowTTLResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowThrottleReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowTopicReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowTopicResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowVariablesResp;
import org.apache.iotdb.confignode.rpc.thrift.TSpaceQuotaResp;
import org.apache.iotdb.confignode.rpc.thrift.TSubscribeReq;
import org.apache.iotdb.confignode.rpc.thrift.TSystemConfigurationResp;
import org.apache.iotdb.confignode.rpc.thrift.TTestOperation;
import org.apache.iotdb.confignode.rpc.thrift.TThrottleQuotaResp;
import org.apache.iotdb.confignode.rpc.thrift.TUnsetSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TUnsubscribeReq;
import org.apache.iotdb.confignode.service.ConfigNode;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.db.queryengine.plan.statement.AuthorType;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeRPCServiceProcessor
implements IConfigNodeRPCService.Iface {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNodeRPCServiceProcessor.class);
    protected final CommonConfig commonConfig;
    protected final ConfigNodeConfig configNodeConfig;
    protected final ConfigNode configNode;
    protected final ConfigManager configManager;

    public ConfigNodeRPCServiceProcessor(ConfigManager configManager) {
        this.commonConfig = CommonDescriptor.getInstance().getConfig();
        this.configNodeConfig = ConfigNodeDescriptor.getInstance().getConf();
        this.configNode = ConfigNode.getInstance();
        this.configManager = configManager;
    }

    public ConfigNodeRPCServiceProcessor(CommonConfig commonConfig, ConfigNodeConfig configNodeConfig, ConfigNode configNode, ConfigManager configManager) {
        this.commonConfig = commonConfig;
        this.configNodeConfig = configNodeConfig;
        this.configNode = configNode;
        this.configManager = configManager;
    }

    public void close() throws IOException {
        this.configManager.close();
    }

    public ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    public TSystemConfigurationResp getSystemConfiguration() {
        TSystemConfigurationResp resp = ((ConfigurationResp)this.configManager.getSystemConfiguration()).convertToRpcSystemConfigurationResp();
        LOGGER.info("Execute GetSystemConfiguration with result {}", (Object)resp);
        return resp;
    }

    public TGetClusterIdResp getClusterId() {
        TGetClusterIdResp resp = new TGetClusterIdResp();
        String clusterId = this.configManager.getClusterManager().getClusterId();
        if (clusterId == null) {
            LOGGER.error("clusterId not generated yet, should never happen.");
            return resp.setClusterId("").setStatus(new TSStatus(TSStatusCode.GET_CLUSTER_ID_ERROR.getStatusCode()));
        }
        resp.setClusterId(clusterId).setStatus(RpcUtils.SUCCESS_STATUS);
        LOGGER.info("Execute getClusterId with result {}", (Object)resp);
        return resp;
    }

    public TDataNodeRegisterResp registerDataNode(TDataNodeRegisterReq req) {
        TDataNodeRegisterResp resp = ((DataNodeRegisterResp)this.configManager.registerDataNode(req)).convertToRpcDataNodeRegisterResp();
        LOGGER.info("Execute RegisterDataNodeRequest {} with result {}", (Object)req, (Object)resp);
        return resp;
    }

    public TDataNodeRestartResp restartDataNode(TDataNodeRestartReq req) {
        TDataNodeRestartResp resp = this.configManager.restartDataNode(req);
        LOGGER.info("Execute RestartDataNodeRequest {} with result {}", (Object)req, (Object)resp);
        return resp;
    }

    public TAINodeRegisterResp registerAINode(TAINodeRegisterReq req) {
        TAINodeRegisterResp resp = ((AINodeRegisterResp)this.configManager.registerAINode(req)).convertToAINodeRegisterResp();
        LOGGER.info("Execute RegisterAINodeRequest {} with result {}", (Object)req, (Object)resp);
        return resp;
    }

    public TAINodeRestartResp restartAINode(TAINodeRestartReq req) {
        TAINodeRestartResp resp = this.configManager.restartAINode(req);
        LOGGER.info("Execute RestartAINodeRequest {} with result {}", (Object)req, (Object)resp);
        return resp;
    }

    public TSStatus removeAINode(TAINodeRemoveReq req) {
        LOGGER.info("ConfigNode RPC Service start to remove AINode, req: {}", (Object)req);
        RemoveAINodePlan removeAINodePlan = new RemoveAINodePlan(req.getAiNodeLocation());
        TSStatus status = this.configManager.removeAINode(removeAINodePlan);
        LOGGER.info("ConfigNode RPC Service finished to remove AINode, req: {}, result: {}", (Object)req, (Object)status);
        return status;
    }

    public TShowAINodesResp showAINodes() throws TException {
        return this.configManager.showAINodes();
    }

    public TAINodeConfigurationResp getAINodeConfiguration(int aiNodeId) throws TException {
        GetAINodeConfigurationPlan getAINodeConfigurationPlan = new GetAINodeConfigurationPlan(aiNodeId);
        AINodeConfigurationResp aiNodeConfigurationResp = (AINodeConfigurationResp)this.configManager.getAINodeConfiguration(getAINodeConfigurationPlan);
        TAINodeConfigurationResp resp = new TAINodeConfigurationResp();
        aiNodeConfigurationResp.convertToRpcAINodeLocationResp(resp);
        return resp;
    }

    public TDataNodeRemoveResp removeDataNode(TDataNodeRemoveReq req) {
        LOGGER.info("ConfigNode RPC Service start to remove DataNode, req: {}", (Object)req);
        RemoveDataNodePlan removeDataNodePlan = new RemoveDataNodePlan(req.getDataNodeLocations());
        DataNodeToStatusResp removeResp = (DataNodeToStatusResp)this.configManager.removeDataNode(removeDataNodePlan);
        TDataNodeRemoveResp resp = removeResp.convertToRpCDataNodeRemoveResp();
        LOGGER.info("ConfigNode RPC Service finished to remove DataNode, req: {}, result: {}", (Object)req, (Object)resp);
        return resp;
    }

    public TSStatus reportDataNodeShutdown(TDataNodeLocation dataNodeLocation) {
        return this.configManager.reportDataNodeShutdown(dataNodeLocation);
    }

    public TDataNodeConfigurationResp getDataNodeConfiguration(int dataNodeID) {
        GetDataNodeConfigurationPlan queryReq = new GetDataNodeConfigurationPlan(dataNodeID);
        DataNodeConfigurationResp queryResp = (DataNodeConfigurationResp)this.configManager.getDataNodeConfiguration(queryReq);
        TDataNodeConfigurationResp resp = new TDataNodeConfigurationResp();
        queryResp.convertToRpcDataNodeLocationResp(resp);
        return resp;
    }

    public TShowClusterResp showCluster() {
        return this.configManager.showCluster();
    }

    public TShowVariablesResp showVariables() {
        return this.configManager.showVariables();
    }

    public TSStatus setDatabase(TDatabaseSchema databaseSchema) {
        TSStatus errorResp = null;
        boolean isSystemDatabase = databaseSchema.getName().equals("root.__system");
        if (databaseSchema.getTTL() < 0L) {
            errorResp = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()).setMessage("Failed to create database. The TTL should be positive.");
        }
        if (isSystemDatabase) {
            databaseSchema.setSchemaReplicationFactor(1);
        } else if (!databaseSchema.isSetSchemaReplicationFactor()) {
            databaseSchema.setSchemaReplicationFactor(this.configNodeConfig.getSchemaReplicationFactor());
        } else if (databaseSchema.getSchemaReplicationFactor() <= 0) {
            errorResp = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()).setMessage("Failed to create database. The schemaReplicationFactor should be positive.");
        }
        if (isSystemDatabase) {
            databaseSchema.setDataReplicationFactor(1);
        } else if (!databaseSchema.isSetDataReplicationFactor()) {
            databaseSchema.setDataReplicationFactor(this.configNodeConfig.getDataReplicationFactor());
        } else if (databaseSchema.getDataReplicationFactor() <= 0) {
            errorResp = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()).setMessage("Failed to create database. The dataReplicationFactor should be positive.");
        }
        if (!databaseSchema.isSetTimePartitionOrigin()) {
            databaseSchema.setTimePartitionOrigin(this.commonConfig.getTimePartitionOrigin());
        } else if (databaseSchema.getTimePartitionOrigin() < 0L) {
            errorResp = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()).setMessage("Failed to create database. The timePartitionOrigin should be non-negative.");
        }
        if (!databaseSchema.isSetTimePartitionInterval()) {
            databaseSchema.setTimePartitionInterval(this.commonConfig.getTimePartitionInterval());
        } else if (databaseSchema.getTimePartitionInterval() <= 0L) {
            errorResp = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()).setMessage("Failed to create database. The timePartitionInterval should be positive.");
        }
        if (isSystemDatabase) {
            databaseSchema.setMinSchemaRegionGroupNum(1);
        } else if (!databaseSchema.isSetMinSchemaRegionGroupNum()) {
            databaseSchema.setMinSchemaRegionGroupNum(this.configNodeConfig.getDefaultSchemaRegionGroupNumPerDatabase());
        } else if (databaseSchema.getMinSchemaRegionGroupNum() <= 0) {
            errorResp = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()).setMessage("Failed to create database. The schemaRegionGroupNum should be positive.");
        }
        if (isSystemDatabase) {
            databaseSchema.setMinDataRegionGroupNum(1);
        } else if (!databaseSchema.isSetMinDataRegionGroupNum()) {
            databaseSchema.setMinDataRegionGroupNum(this.configNodeConfig.getDefaultDataRegionGroupNumPerDatabase());
        } else if (databaseSchema.getMinDataRegionGroupNum() <= 0) {
            errorResp = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()).setMessage("Failed to create database. The dataRegionGroupNum should be positive.");
        }
        if (errorResp != null) {
            LOGGER.warn("Execute SetDatabase: {} with result: {}", (Object)databaseSchema, (Object)errorResp);
            return errorResp;
        }
        databaseSchema.setMaxSchemaRegionGroupNum(databaseSchema.getMinSchemaRegionGroupNum());
        databaseSchema.setMaxDataRegionGroupNum(databaseSchema.getMinDataRegionGroupNum());
        DatabaseSchemaPlan setPlan = new DatabaseSchemaPlan(ConfigPhysicalPlanType.CreateDatabase, databaseSchema);
        TSStatus resp = this.configManager.setDatabase(setPlan);
        LOGGER.info("Execute SetDatabase: {} with result: {}", (Object)databaseSchema, (Object)resp);
        return resp;
    }

    public TSStatus alterDatabase(TDatabaseSchema databaseSchema) {
        TSStatus errorResp = null;
        if (databaseSchema.isSetTTL()) {
            errorResp = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()).setMessage("Failed to alter database. Doesn't support ALTER TTL yet.");
        }
        if (databaseSchema.isSetSchemaReplicationFactor()) {
            errorResp = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()).setMessage("Failed to alter database. Doesn't support ALTER SchemaReplicationFactor yet.");
        }
        if (databaseSchema.isSetDataReplicationFactor()) {
            errorResp = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()).setMessage("Failed to alter database. Doesn't support ALTER DataReplicationFactor yet.");
        }
        if (databaseSchema.isSetTimePartitionOrigin()) {
            errorResp = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()).setMessage("Failed to alter database. Doesn't support ALTER TimePartitionOrigin yet.");
        }
        if (databaseSchema.isSetTimePartitionInterval()) {
            errorResp = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()).setMessage("Failed to alter database. Doesn't support ALTER TimePartitionInterval yet.");
        }
        if (errorResp != null) {
            LOGGER.warn("Execute AlterDatabase: {} with result: {}", (Object)databaseSchema, (Object)errorResp);
            return errorResp;
        }
        DatabaseSchemaPlan alterPlan = new DatabaseSchemaPlan(ConfigPhysicalPlanType.AlterDatabase, databaseSchema);
        TSStatus resp = this.configManager.alterDatabase(alterPlan);
        LOGGER.info("Execute AlterDatabase: {} with result: {}", (Object)databaseSchema, (Object)resp);
        return resp;
    }

    public TSStatus deleteDatabase(TDeleteDatabaseReq tDeleteReq) {
        return this.configManager.deleteDatabases(new TDeleteDatabasesReq(Collections.singletonList(tDeleteReq.getPrefixPath())).setIsGeneratedByPipe(tDeleteReq.isIsGeneratedByPipe()));
    }

    public TSStatus deleteDatabases(TDeleteDatabasesReq tDeleteReq) {
        return this.configManager.deleteDatabases(tDeleteReq);
    }

    public TSStatus setTTL(TSetTTLReq req) throws TException {
        return this.configManager.setTTL(new SetTTLPlan(req.getPathPattern(), req.getTTL()));
    }

    public TSStatus setSchemaReplicationFactor(TSetSchemaReplicationFactorReq req) throws TException {
        return this.configManager.setSchemaReplicationFactor(new SetSchemaReplicationFactorPlan(req.getDatabase(), req.getSchemaReplicationFactor()));
    }

    public TSStatus setDataReplicationFactor(TSetDataReplicationFactorReq req) throws TException {
        return this.configManager.setDataReplicationFactor(new SetDataReplicationFactorPlan(req.getDatabase(), req.getDataReplicationFactor()));
    }

    public TSStatus setTimePartitionInterval(TSetTimePartitionIntervalReq req) throws TException {
        return this.configManager.setTimePartitionInterval(new SetTimePartitionIntervalPlan(req.getDatabase(), req.getTimePartitionInterval()));
    }

    public TCountDatabaseResp countMatchedDatabases(TGetDatabaseReq req) {
        PathPatternTree scope = req.getScopePatternTree() == null ? SchemaConstant.ALL_MATCH_SCOPE : PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getScopePatternTree()));
        CountDatabasePlan plan = new CountDatabasePlan(req.getDatabasePathPattern(), scope);
        CountDatabaseResp countDatabaseResp = (CountDatabaseResp)this.configManager.countMatchedDatabases(plan);
        TCountDatabaseResp resp = new TCountDatabaseResp();
        countDatabaseResp.convertToRPCCountStorageGroupResp(resp);
        return resp;
    }

    public TDatabaseSchemaResp getMatchedDatabaseSchemas(TGetDatabaseReq req) {
        PathPatternTree scope = req.getScopePatternTree() == null ? SchemaConstant.ALL_MATCH_SCOPE : PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getScopePatternTree()));
        GetDatabasePlan plan = new GetDatabasePlan(req.getDatabasePathPattern(), scope);
        DatabaseSchemaResp databaseSchemaResp = (DatabaseSchemaResp)this.configManager.getMatchedDatabaseSchemas(plan);
        return databaseSchemaResp.convertToRPCStorageGroupSchemaResp();
    }

    public TShowTTLResp showTTL(TShowTTLReq req) {
        ShowTTLResp showTTLResp = (ShowTTLResp)this.configManager.showTTL(new ShowTTLPlan(req.getPathPattern().toArray(new String[0])));
        return showTTLResp.convertToRPCTShowTTLResp();
    }

    public TSStatus callSpecialProcedure(TTestOperation operation) {
        switch (operation) {
            case TEST_PROCEDURE_RECOVER: {
                return this.configManager.getProcedureManager().createManyDatabases();
            }
            case TEST_SUB_PROCEDURE: {
                return this.configManager.getProcedureManager().testSubProcedure();
            }
        }
        String msg = String.format("operation %s is not supported", operation);
        LOGGER.error(msg);
        throw new UnsupportedOperationException(msg);
    }

    public TSchemaPartitionTableResp getSchemaPartitionTable(TSchemaPartitionReq req) {
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        return this.configManager.getSchemaPartition(patternTree);
    }

    public TSchemaPartitionTableResp getOrCreateSchemaPartitionTable(TSchemaPartitionReq req) {
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        return this.configManager.getOrCreateSchemaPartition(patternTree);
    }

    public TSchemaNodeManagementResp getSchemaNodeManagementPartition(TSchemaNodeManagementReq req) {
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        PathPatternTree scope = req.getScopePatternTree() == null ? SchemaConstant.ALL_MATCH_SCOPE : PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getScopePatternTree()));
        PartialPath partialPath = (PartialPath)patternTree.getAllPathPatterns().get(0);
        return this.configManager.getNodePathsPartition(partialPath, scope, req.getLevel());
    }

    public TDataPartitionTableResp getDataPartitionTable(TDataPartitionReq req) {
        GetDataPartitionPlan getDataPartitionPlan = GetDataPartitionPlan.convertFromRpcTDataPartitionReq(req);
        return this.configManager.getDataPartition(getDataPartitionPlan);
    }

    public TDataPartitionTableResp getOrCreateDataPartitionTable(TDataPartitionReq req) {
        GetOrCreateDataPartitionPlan getOrCreateDataPartitionReq = GetOrCreateDataPartitionPlan.convertFromRpcTDataPartitionReq(req);
        return this.configManager.getOrCreateDataPartition(getOrCreateDataPartitionReq);
    }

    public TSStatus operatePermission(TAuthorizerReq req) {
        if (req.getAuthorType() < 0 || req.getAuthorType() >= AuthorType.values().length) {
            throw new IndexOutOfBoundsException("Invalid Author Type ordinal");
        }
        return this.configManager.operatePermission(new AuthorPlan(ConfigPhysicalPlanType.values()[req.getAuthorType() + ConfigPhysicalPlanType.CreateUser.ordinal()], req.getUserName(), req.getRoleName(), req.getPassword(), req.getNewPassword(), req.getPermissions(), req.isGrantOpt(), AuthUtils.deserializePartialPathList((ByteBuffer)ByteBuffer.wrap(req.getNodeNameList()))));
    }

    public TAuthorizerResp queryPermission(TAuthorizerReq req) {
        if (req.getAuthorType() < 0 || req.getAuthorType() >= AuthorType.values().length) {
            throw new IndexOutOfBoundsException("Invalid Author Type ordinal");
        }
        PermissionInfoResp dataSet = (PermissionInfoResp)this.configManager.queryPermission(new AuthorReadPlan(ConfigPhysicalPlanType.values()[req.getAuthorType() + ConfigPhysicalPlanType.CreateUser.ordinal()], req.getUserName(), req.getRoleName(), req.getPassword(), req.getNewPassword(), req.getPermissions(), req.isGrantOpt(), AuthUtils.deserializePartialPathList((ByteBuffer)ByteBuffer.wrap(req.getNodeNameList()))));
        TAuthorizerResp resp = new TAuthorizerResp(dataSet.getStatus());
        resp.setMemberInfo(dataSet.getMemberList());
        resp.setPermissionInfo(dataSet.getPermissionInfoResp());
        resp.setTag(dataSet.getTag());
        return resp;
    }

    public TPermissionInfoResp login(TLoginReq req) {
        return this.configManager.login(req.getUserrname(), req.getPassword());
    }

    public TPermissionInfoResp checkUserPrivileges(TCheckUserPrivilegesReq req) {
        List partialPaths = AuthUtils.deserializePartialPathList((ByteBuffer)ByteBuffer.wrap(req.getPaths()));
        return this.configManager.checkUserPrivileges(req.getUsername(), partialPaths, req.getPermission());
    }

    public TAuthizedPatternTreeResp fetchAuthizedPatternTree(TCheckUserPrivilegesReq req) {
        return this.configManager.fetchAuthizedPatternTree(req.getUsername(), req.getPermission());
    }

    public TPermissionInfoResp checkUserPrivilegeGrantOpt(TCheckUserPrivilegesReq req) {
        List partialPath = AuthUtils.deserializePartialPathList((ByteBuffer)ByteBuffer.wrap(req.getPaths()));
        return this.configManager.checkUserPrivilegeGrantOpt(req.getUsername(), partialPath, req.getPermission());
    }

    public TPermissionInfoResp checkRoleOfUser(TAuthorizerReq req) {
        return this.configManager.checkRoleOfUser(req.getUserName(), req.getRoleName());
    }

    public TConfigNodeRegisterResp registerConfigNode(TConfigNodeRegisterReq req) {
        TConfigNodeRegisterResp resp = this.configManager.registerConfigNode(req);
        LOGGER.info("Execute RegisterConfigNodeRequest {} with result {}", (Object)req, (Object)resp);
        return resp;
    }

    public TSStatus addConsensusGroup(TAddConsensusGroupReq registerResp) {
        return this.configManager.createPeerForConsensusGroup(registerResp.getConfigNodeList());
    }

    public TSStatus notifyRegisterSuccess() {
        try {
            SystemPropertiesUtils.storeSystemParameters();
        }
        catch (IOException e) {
            LOGGER.error("Write confignode-system.properties failed", (Throwable)e);
            return new TSStatus(TSStatusCode.WRITE_PROCESS_ERROR.getStatusCode());
        }
        LOGGER.info("{} has successfully started and joined the cluster: {}.", (Object)"IoTDB-ConfigNode", (Object)this.configNodeConfig.getClusterName());
        return StatusUtils.OK;
    }

    public TSStatus removeConfigNode(TConfigNodeLocation configNodeLocation) throws TException {
        RemoveConfigNodePlan removeConfigNodePlan = new RemoveConfigNodePlan(configNodeLocation);
        TSStatus status = this.configManager.removeConfigNode(removeConfigNodePlan);
        LOGGER.info("Execute RemoveConfigNodeRequest {} with result {}", (Object)configNodeLocation, (Object)status);
        return status;
    }

    public TSStatus deleteConfigNodePeer(TConfigNodeLocation configNodeLocation) {
        if (!this.configManager.getNodeManager().getRegisteredConfigNodes().contains(configNodeLocation)) {
            return new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_ERROR.getStatusCode()).setMessage("remove ConsensusGroup failed because the ConfigNode not in current Cluster.");
        }
        ConsensusGroupId groupId = this.configManager.getConsensusManager().getConsensusGroupId();
        try {
            this.configManager.getConsensusManager().getConsensusImpl().deleteLocalPeer(groupId);
        }
        catch (ConsensusException e) {
            return new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_ERROR.getStatusCode()).setMessage("remove ConsensusGroup failed because internal failure. See other logs for more details");
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()).setMessage("remove ConsensusGroup success.");
    }

    public TSStatus reportConfigNodeShutdown(TConfigNodeLocation configNodeLocation) {
        return this.configManager.reportConfigNodeShutdown(configNodeLocation);
    }

    public TSStatus stopConfigNode(TConfigNodeLocation configNodeLocation) {
        new Thread(() -> {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn(e.getMessage());
            }
            finally {
                this.configNode.stop();
            }
        }).start();
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()).setMessage("Stop ConfigNode success.");
    }

    public TSStatus createFunction(TCreateFunctionReq req) {
        return this.configManager.createFunction(req);
    }

    public TSStatus dropFunction(TDropFunctionReq req) {
        return this.configManager.dropFunction(req.getUdfName());
    }

    public TGetUDFTableResp getUDFTable() {
        return this.configManager.getUDFTable();
    }

    public TGetJarInListResp getUDFJar(TGetJarInListReq req) {
        return this.configManager.getUDFJar(req);
    }

    public TSStatus createTrigger(TCreateTriggerReq req) {
        return this.configManager.createTrigger(req);
    }

    public TSStatus dropTrigger(TDropTriggerReq req) {
        return this.configManager.dropTrigger(req);
    }

    public TGetTriggerTableResp getTriggerTable() {
        return this.configManager.getTriggerTable();
    }

    public TGetTriggerTableResp getStatefulTriggerTable() {
        return this.configManager.getStatefulTriggerTable();
    }

    public TGetLocationForTriggerResp getLocationOfStatefulTrigger(String triggerName) {
        return this.configManager.getLocationOfStatefulTrigger(triggerName);
    }

    public TGetJarInListResp getTriggerJar(TGetJarInListReq req) {
        return this.configManager.getTriggerJar(req);
    }

    public TSStatus createPipePlugin(TCreatePipePluginReq req) {
        return this.configManager.createPipePlugin(req);
    }

    public TSStatus dropPipePlugin(TDropPipePluginReq req) {
        return this.configManager.dropPipePlugin(req);
    }

    public TGetPipePluginTableResp getPipePluginTable() {
        return this.configManager.getPipePluginTable();
    }

    public TGetJarInListResp getPipePluginJar(TGetJarInListReq req) {
        return this.configManager.getPipePluginJar(req);
    }

    public TSStatus merge() throws TException {
        return this.configManager.merge();
    }

    public TSStatus flush(TFlushReq req) throws TException {
        List<PartialPath> noExistSg;
        if (req.storageGroups != null && !(noExistSg = this.configManager.getPartitionManager().filterUnExistDatabases(PartialPath.fromStringList((List)req.storageGroups))).isEmpty()) {
            StringBuilder sb = new StringBuilder();
            noExistSg.forEach(storageGroup -> sb.append(storageGroup.getFullPath()).append(","));
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.DATABASE_NOT_EXIST, (String)("storageGroup " + sb.subSequence(0, sb.length() - 1) + " does not exist"));
        }
        return this.configManager.flush(req);
    }

    public TSStatus clearCache() {
        return this.configManager.clearCache();
    }

    public TSStatus setConfiguration(TSetConfigurationReq req) throws TException {
        return this.configManager.setConfiguration(req);
    }

    public TSStatus startRepairData() {
        return this.configManager.startRepairData();
    }

    public TSStatus stopRepairData() throws TException {
        return this.configManager.stopRepairData();
    }

    public TSStatus submitLoadConfigurationTask() throws TException {
        return this.configManager.submitLoadConfigurationTask();
    }

    public TSStatus loadConfiguration() {
        return this.configManager.loadConfiguration();
    }

    public TShowConfigurationResp showConfiguration(int nodeId) throws TException {
        return this.configManager.showConfiguration(nodeId);
    }

    public TSStatus setSystemStatus(String status) {
        return this.configManager.setSystemStatus(status);
    }

    public TSStatus setDataNodeStatus(TSetDataNodeStatusReq req) {
        return this.configManager.setDataNodeStatus(req);
    }

    public TSStatus killQuery(String queryId, int dataNodeId) {
        return this.configManager.killQuery(queryId, dataNodeId);
    }

    public TGetDataNodeLocationsResp getRunningDataNodeLocations() {
        return this.configManager.getRunningDataNodeLocations();
    }

    public TShowRegionResp showRegion(TShowRegionReq showRegionReq) {
        GetRegionInfoListPlan getRegionInfoListPlan = new GetRegionInfoListPlan(showRegionReq);
        RegionInfoListResp dataSet = this.configManager.showRegion(getRegionInfoListPlan);
        TShowRegionResp showRegionResp = new TShowRegionResp();
        showRegionResp.setStatus(dataSet.getStatus());
        showRegionResp.setRegionInfoList(dataSet.getRegionInfoList());
        return showRegionResp;
    }

    public TRegionRouteMapResp getLatestRegionRouteMap() {
        return this.configManager.getLatestRegionRouteMap();
    }

    public TConfigNodeHeartbeatResp getConfigNodeHeartBeat(TConfigNodeHeartbeatReq heartbeatReq) {
        TConfigNodeHeartbeatResp resp = new TConfigNodeHeartbeatResp();
        resp.setTimestamp(heartbeatReq.getTimestamp());
        return resp;
    }

    public TShowDataNodesResp showDataNodes() {
        return this.configManager.showDataNodes();
    }

    public TShowConfigNodesResp showConfigNodes() {
        return this.configManager.showConfigNodes();
    }

    public TShowDatabaseResp showDatabase(TGetDatabaseReq req) {
        return this.configManager.showDatabase(req);
    }

    public TTestConnectionResp submitTestConnectionTask(TNodeLocations nodeLocations) throws TException {
        return this.configManager.getClusterManager().doConnectionTest(nodeLocations);
    }

    public TTestConnectionResp submitTestConnectionTaskToLeader() throws TException {
        return this.configManager.getClusterManager().submitTestConnectionTaskToEveryNode();
    }

    public TSStatus testConnectionEmptyRPC() throws TException {
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus createSchemaTemplate(TCreateSchemaTemplateReq req) {
        return this.configManager.createSchemaTemplate(req);
    }

    public TGetAllTemplatesResp getAllTemplates() {
        return this.configManager.getAllTemplates();
    }

    public TGetTemplateResp getTemplate(String req) {
        return this.configManager.getTemplate(req);
    }

    public TSStatus setSchemaTemplate(TSetSchemaTemplateReq req) {
        return this.configManager.setSchemaTemplate(req);
    }

    public TGetPathsSetTemplatesResp getPathsSetTemplate(TGetPathsSetTemplatesReq req) {
        return this.configManager.getPathsSetTemplate(req);
    }

    public TSStatus deactivateSchemaTemplate(TDeactivateSchemaTemplateReq req) {
        return this.configManager.deactivateSchemaTemplate(req);
    }

    public TSStatus unsetSchemaTemplate(TUnsetSchemaTemplateReq req) {
        return this.configManager.unsetSchemaTemplate(req);
    }

    public TSStatus dropSchemaTemplate(String req) {
        return this.configManager.dropSchemaTemplate(req);
    }

    public TSStatus alterSchemaTemplate(TAlterSchemaTemplateReq req) {
        return this.configManager.alterSchemaTemplate(req);
    }

    public TSStatus deleteTimeSeries(TDeleteTimeSeriesReq req) {
        return this.configManager.deleteTimeSeries(req);
    }

    public TSStatus deleteLogicalView(TDeleteLogicalViewReq req) {
        return this.configManager.deleteLogicalView(req);
    }

    public TSStatus alterLogicalView(TAlterLogicalViewReq req) {
        return this.configManager.alterLogicalView(req);
    }

    public TSStatus createPipe(TCreatePipeReq req) {
        return this.configManager.createPipe(req);
    }

    public TSStatus alterPipe(TAlterPipeReq req) {
        return this.configManager.alterPipe(req);
    }

    public TSStatus startPipe(String pipeName) {
        return this.configManager.startPipe(pipeName);
    }

    public TSStatus stopPipe(String pipeName) {
        return this.configManager.stopPipe(pipeName);
    }

    public TSStatus dropPipe(String pipeName) {
        return this.configManager.dropPipe(new TDropPipeReq().setPipeName(pipeName).setIfExistsCondition(false));
    }

    public TSStatus dropPipeExtended(TDropPipeReq req) {
        return this.configManager.dropPipe(req);
    }

    public TShowPipeResp showPipe(TShowPipeReq req) {
        return this.configManager.showPipe(req);
    }

    public TGetAllPipeInfoResp getAllPipeInfo() {
        return this.configManager.getAllPipeInfo();
    }

    public TPipeConfigTransferResp handleTransferConfigPlan(TPipeConfigTransferReq req) {
        return this.configManager.handleTransferConfigPlan(req);
    }

    public TSStatus handlePipeConfigClientExit(String clientId) {
        return this.configManager.handleClientExit(clientId);
    }

    public TSStatus createTopic(TCreateTopicReq req) {
        return this.configManager.createTopic(req);
    }

    public TSStatus dropTopic(String topicName) {
        return this.configManager.dropTopic(new TDropTopicReq().setTopicName(topicName).setIfExistsCondition(false));
    }

    public TSStatus dropTopicExtended(TDropTopicReq req) throws TException {
        return this.configManager.dropTopic(req);
    }

    public TShowTopicResp showTopic(TShowTopicReq req) {
        return this.configManager.showTopic(req);
    }

    public TGetAllTopicInfoResp getAllTopicInfo() {
        return this.configManager.getAllTopicInfo();
    }

    public TSStatus createConsumer(TCreateConsumerReq req) {
        return this.configManager.createConsumer(req);
    }

    public TSStatus closeConsumer(TCloseConsumerReq req) {
        return this.configManager.closeConsumer(req);
    }

    public TSStatus createSubscription(TSubscribeReq req) {
        return this.configManager.createSubscription(req);
    }

    public TSStatus dropSubscription(TUnsubscribeReq req) {
        return this.configManager.dropSubscription(req);
    }

    public TShowSubscriptionResp showSubscription(TShowSubscriptionReq req) {
        return this.configManager.showSubscription(req);
    }

    public TGetAllSubscriptionInfoResp getAllSubscriptionInfo() {
        return this.configManager.getAllSubscriptionInfo();
    }

    public TGetRegionIdResp getRegionId(TGetRegionIdReq req) {
        return this.configManager.getRegionId(req);
    }

    public TGetTimeSlotListResp getTimeSlotList(TGetTimeSlotListReq req) {
        return this.configManager.getTimeSlotList(req);
    }

    public TCountTimeSlotListResp countTimeSlotList(TCountTimeSlotListReq req) {
        return this.configManager.countTimeSlotList(req);
    }

    public TGetSeriesSlotListResp getSeriesSlotList(TGetSeriesSlotListReq req) {
        return this.configManager.getSeriesSlotList(req);
    }

    public TSStatus migrateRegion(TMigrateRegionReq req) {
        return this.configManager.migrateRegion(req);
    }

    public TSStatus createCQ(TCreateCQReq req) {
        return this.configManager.createCQ(req);
    }

    public TSStatus dropCQ(TDropCQReq req) {
        return this.configManager.dropCQ(req);
    }

    public TShowCQResp showCQ() {
        return this.configManager.showCQ();
    }

    public TSStatus createModel(TCreateModelReq req) {
        return this.configManager.createModel(req);
    }

    public TSStatus dropModel(TDropModelReq req) {
        return this.configManager.dropModel(req);
    }

    public TShowModelResp showModel(TShowModelReq req) {
        return this.configManager.showModel(req);
    }

    public TGetModelInfoResp getModelInfo(TGetModelInfoReq req) {
        return this.configManager.getModelInfo(req);
    }

    public TSStatus setSpaceQuota(TSetSpaceQuotaReq req) throws TException {
        return this.configManager.setSpaceQuota(req);
    }

    public TSpaceQuotaResp showSpaceQuota(List<String> databases) {
        return this.configManager.showSpaceQuota(databases);
    }

    public TSpaceQuotaResp getSpaceQuota() {
        return this.configManager.getSpaceQuota();
    }

    public TSStatus setThrottleQuota(TSetThrottleQuotaReq req) throws TException {
        return this.configManager.setThrottleQuota(req);
    }

    public TThrottleQuotaResp showThrottleQuota(TShowThrottleReq req) {
        return this.configManager.showThrottleQuota(req);
    }

    public TThrottleQuotaResp getThrottleQuota() {
        return this.configManager.getThrottleQuota();
    }
}

