/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.subscription;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerGroupMeta;
import org.apache.iotdb.commons.subscription.meta.topic.TopicMeta;
import org.apache.iotdb.confignode.persistence.subscription.SubscriptionInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.AbstractNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.subscription.SubscriptionOperation;
import org.apache.iotdb.confignode.procedure.impl.subscription.consumer.runtime.ConsumerGroupMetaSyncProcedure;
import org.apache.iotdb.confignode.procedure.impl.subscription.topic.runtime.TopicMetaSyncProcedure;
import org.apache.iotdb.confignode.procedure.state.ProcedureLockState;
import org.apache.iotdb.confignode.procedure.state.subscription.OperateSubscriptionState;
import org.apache.iotdb.mpp.rpc.thrift.TPushConsumerGroupMetaResp;
import org.apache.iotdb.mpp.rpc.thrift.TPushTopicMetaResp;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperateSubscriptionProcedure
extends AbstractNodeProcedure<OperateSubscriptionState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOperateSubscriptionProcedure.class);
    private static final String SKIP_SUBSCRIPTION_PROCEDURE_MESSAGE = "Skip subscription-related operations and do nothing";
    private static final int RETRY_THRESHOLD = 1;
    protected AtomicReference<SubscriptionInfo> subscriptionInfo;

    protected AtomicReference<SubscriptionInfo> acquireLockInternal(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        return configNodeProcedureEnv.getConfigManager().getSubscriptionManager().getSubscriptionCoordinator().lock();
    }

    @Override
    protected ProcedureLockState acquireLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        LOGGER.info("ProcedureId {} try to acquire subscription lock.", (Object)this.getProcId());
        this.subscriptionInfo = this.acquireLockInternal(configNodeProcedureEnv);
        if (this.subscriptionInfo == null) {
            LOGGER.warn("ProcedureId {} failed to acquire subscription lock.", (Object)this.getProcId());
        } else {
            LOGGER.info("ProcedureId {} acquired subscription lock.", (Object)this.getProcId());
        }
        ProcedureLockState procedureLockState = super.acquireLock(configNodeProcedureEnv);
        switch (procedureLockState) {
            case LOCK_ACQUIRED: {
                if (this.subscriptionInfo == null) {
                    LOGGER.warn("ProcedureId {}: LOCK_ACQUIRED. The following procedure should not be executed without subscription lock.", (Object)this.getProcId());
                    break;
                }
                LOGGER.info("ProcedureId {}: LOCK_ACQUIRED. The following procedure should be executed with subscription lock.", (Object)this.getProcId());
                break;
            }
            case LOCK_EVENT_WAIT: {
                if (this.subscriptionInfo == null) {
                    LOGGER.warn("ProcedureId {}: LOCK_EVENT_WAIT. Without acquiring subscription lock.", (Object)this.getProcId());
                    break;
                }
                LOGGER.info("ProcedureId {}: LOCK_EVENT_WAIT. Subscription lock will be released.", (Object)this.getProcId());
                configNodeProcedureEnv.getConfigManager().getSubscriptionManager().getSubscriptionCoordinator().unlock();
                this.subscriptionInfo = null;
                break;
            }
            default: {
                if (this.subscriptionInfo == null) {
                    LOGGER.error("ProcedureId {}: {}. Invalid lock state. Without acquiring subscription lock.", (Object)this.getProcId(), (Object)procedureLockState);
                    break;
                }
                LOGGER.error("ProcedureId {}: {}. Invalid lock state. Subscription lock will be released.", (Object)this.getProcId(), (Object)procedureLockState);
                configNodeProcedureEnv.getConfigManager().getSubscriptionManager().getSubscriptionCoordinator().unlock();
                this.subscriptionInfo = null;
            }
        }
        return procedureLockState;
    }

    @Override
    protected void releaseLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        super.releaseLock(configNodeProcedureEnv);
        if (this.subscriptionInfo == null) {
            LOGGER.warn("ProcedureId {} release lock. No need to release subscription lock.", (Object)this.getProcId());
        } else {
            LOGGER.info("ProcedureId {} release lock. Subscription lock will be released.", (Object)this.getProcId());
            if (this instanceof TopicMetaSyncProcedure || this instanceof ConsumerGroupMetaSyncProcedure) {
                LOGGER.info("Subscription meta sync procedure finished, updating last sync version.");
                configNodeProcedureEnv.getConfigManager().getSubscriptionManager().getSubscriptionCoordinator().updateLastSyncedVersion();
            }
            configNodeProcedureEnv.getConfigManager().getSubscriptionManager().getSubscriptionCoordinator().unlock();
            this.subscriptionInfo = null;
        }
    }

    protected abstract SubscriptionOperation getOperation();

    protected abstract boolean executeFromValidate(ConfigNodeProcedureEnv var1) throws SubscriptionException;

    protected abstract void executeFromOperateOnConfigNodes(ConfigNodeProcedureEnv var1) throws SubscriptionException;

    protected abstract void executeFromOperateOnDataNodes(ConfigNodeProcedureEnv var1) throws SubscriptionException, IOException;

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, OperateSubscriptionState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        if (this.subscriptionInfo == null) {
            LOGGER.warn("ProcedureId {}: Subscription lock is not acquired, executeFromState({})'s execution will be skipped.", (Object)this.getProcId(), (Object)state);
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        try {
            switch (state) {
                case VALIDATE: {
                    if (!this.executeFromValidate(env)) {
                        LOGGER.info("ProcedureId {}: {}", (Object)this.getProcId(), (Object)SKIP_SUBSCRIPTION_PROCEDURE_MESSAGE);
                        this.setResult(SKIP_SUBSCRIPTION_PROCEDURE_MESSAGE.getBytes(StandardCharsets.UTF_8));
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    this.setNextState(OperateSubscriptionState.OPERATE_ON_CONFIG_NODES);
                    break;
                }
                case OPERATE_ON_CONFIG_NODES: {
                    this.executeFromOperateOnConfigNodes(env);
                    this.setNextState(OperateSubscriptionState.OPERATE_ON_DATA_NODES);
                    break;
                }
                case OPERATE_ON_DATA_NODES: {
                    this.executeFromOperateOnDataNodes(env);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unknown state during executing operateSubscriptionProcedure, %s", new Object[]{state}));
                }
            }
        }
        catch (Exception e) {
            if (this.getCycles() < 1) {
                LOGGER.warn("ProcedureId {}: Encountered error when trying to {} at state [{}], retry [{}/{}]", new Object[]{this.getProcId(), this.getOperation(), state, this.getCycles() + 1, 1, e});
                TimeUnit.MILLISECONDS.sleep(3000L);
            }
            LOGGER.warn("ProcedureId {}: All {} retries failed when trying to {} at state [{}], will rollback...", new Object[]{this.getProcId(), 1, this.getOperation(), state, e});
            this.setFailure(new ProcedureException(String.format("ProcedureId %s: Fail to %s because %s", this.getProcId(), this.getOperation().name(), e.getMessage())));
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, OperateSubscriptionState state) throws IOException, InterruptedException, ProcedureException {
        if (this.subscriptionInfo == null) {
            LOGGER.warn("ProcedureId {}: Subscription lock is not acquired, rollbackState({})'s execution will be skipped.", (Object)this.getProcId(), (Object)state);
            return;
        }
        switch (state) {
            case VALIDATE: {
                try {
                    this.rollbackFromValidate(env);
                }
                catch (Exception e) {
                    LOGGER.warn("ProcedureId {}: Failed to rollback from state [{}], because {}", new Object[]{this.getProcId(), state, e.getMessage(), e});
                }
                break;
            }
            case OPERATE_ON_CONFIG_NODES: {
                try {
                    this.rollbackFromOperateOnConfigNodes(env);
                }
                catch (Exception e) {
                    LOGGER.warn("ProcedureId {}: Failed to rollback from state [{}], because {}", new Object[]{this.getProcId(), state, e.getMessage(), e});
                }
                break;
            }
            case OPERATE_ON_DATA_NODES: {
                try {
                    this.rollbackFromOperateOnDataNodes(env);
                }
                catch (Exception e) {
                    LOGGER.warn("ProcedureId {}: Failed to rollback from state [{}], because {}", new Object[]{this.getProcId(), state, e.getMessage(), e});
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unknown state during rollback operateSubscriptionProcedure, %s", new Object[]{state}));
            }
        }
    }

    protected abstract void rollbackFromValidate(ConfigNodeProcedureEnv var1);

    protected abstract void rollbackFromOperateOnConfigNodes(ConfigNodeProcedureEnv var1);

    protected abstract void rollbackFromOperateOnDataNodes(ConfigNodeProcedureEnv var1) throws IOException;

    protected Map<Integer, TPushTopicMetaResp> pushTopicMetaToDataNodes(ConfigNodeProcedureEnv env) throws IOException {
        ArrayList<ByteBuffer> topicMetaBinaryList = new ArrayList<ByteBuffer>();
        for (TopicMeta topicMeta : this.subscriptionInfo.get().getAllTopicMeta()) {
            topicMetaBinaryList.add(topicMeta.serialize());
        }
        return env.pushAllTopicMetaToDataNodes(topicMetaBinaryList);
    }

    public static boolean pushTopicMetaHasException(Map<Integer, TPushTopicMetaResp> respMap) {
        for (TPushTopicMetaResp resp : respMap.values()) {
            if (resp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            return true;
        }
        return false;
    }

    protected Map<Integer, TPushConsumerGroupMetaResp> pushConsumerGroupMetaToDataNodes(ConfigNodeProcedureEnv env) throws IOException {
        ArrayList<ByteBuffer> consumerGroupMetaBinaryList = new ArrayList<ByteBuffer>();
        for (ConsumerGroupMeta consumerGroupMeta : this.subscriptionInfo.get().getAllConsumerGroupMeta()) {
            consumerGroupMetaBinaryList.add(consumerGroupMeta.serialize());
        }
        return env.pushAllConsumerGroupMetaToDataNodes(consumerGroupMetaBinaryList);
    }

    public static boolean pushConsumerGroupMetaHasException(Map<Integer, TPushConsumerGroupMetaResp> respMap) {
        for (TPushConsumerGroupMetaResp resp : respMap.values()) {
            if (resp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected OperateSubscriptionState getState(int stateId) {
        return OperateSubscriptionState.values()[stateId];
    }

    @Override
    protected int getStateId(OperateSubscriptionState state) {
        return state.ordinal();
    }

    @Override
    protected OperateSubscriptionState getInitialState() {
        return OperateSubscriptionState.VALIDATE;
    }
}

