/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.pipe.task;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStatus;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.AlterPipePlanV2;
import org.apache.iotdb.confignode.manager.pipe.coordinator.PipeManager;
import org.apache.iotdb.confignode.persistence.pipe.PipeTaskInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.pipe.AbstractOperatePipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.pipe.PipeTaskOperation;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.confignode.rpc.thrift.TAlterPipeReq;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterPipeProcedureV2
extends AbstractOperatePipeProcedureV2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlterPipeProcedureV2.class);
    private TAlterPipeReq alterPipeRequest;
    private PipeStaticMeta currentPipeStaticMeta;
    private PipeStaticMeta updatedPipeStaticMeta;
    private PipeRuntimeMeta currentPipeRuntimeMeta;
    private PipeRuntimeMeta updatedPipeRuntimeMeta;
    private ProcedureType procedureType;

    public AlterPipeProcedureV2(ProcedureType procedureType) {
        this.procedureType = procedureType;
    }

    public AlterPipeProcedureV2(TAlterPipeReq alterPipeRequest) throws PipeException {
        this.alterPipeRequest = alterPipeRequest;
        this.procedureType = ProcedureType.ALTER_PIPE_PROCEDURE_V3;
    }

    public AlterPipeProcedureV2(TAlterPipeReq alterPipeRequest, ProcedureType procedureType) throws PipeException {
        this.alterPipeRequest = alterPipeRequest;
        this.procedureType = procedureType;
    }

    @Override
    protected PipeTaskOperation getOperation() {
        return PipeTaskOperation.ALTER_PIPE;
    }

    @Override
    public boolean executeFromValidateTask(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("AlterPipeProcedureV2: executeFromValidateTask({})", (Object)this.alterPipeRequest.getPipeName());
        if (!((PipeTaskInfo)this.pipeTaskInfo.get()).checkAndUpdateRequestBeforeAlterPipe(this.alterPipeRequest)) {
            return false;
        }
        PipeManager pipeManager = env.getConfigManager().getPipeManager();
        pipeManager.getPipePluginCoordinator().getPipePluginInfo().checkPipePluginExistence(this.alterPipeRequest.getExtractorAttributes(), this.alterPipeRequest.getProcessorAttributes(), this.alterPipeRequest.getConnectorAttributes());
        return true;
    }

    @Override
    public void executeFromCalculateInfoForTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("AlterPipeProcedureV2: executeFromCalculateInfoForTask({})", (Object)this.alterPipeRequest.getPipeName());
        PipeMeta currentPipeMeta = ((PipeTaskInfo)this.pipeTaskInfo.get()).getPipeMetaByPipeName(this.alterPipeRequest.getPipeName());
        this.currentPipeStaticMeta = currentPipeMeta.getStaticMeta();
        this.currentPipeRuntimeMeta = currentPipeMeta.getRuntimeMeta();
        ConcurrentMap currentConsensusGroupId2PipeTaskMeta = this.currentPipeRuntimeMeta.getConsensusGroupId2TaskMetaMap();
        this.updatedPipeStaticMeta = new PipeStaticMeta(this.alterPipeRequest.getPipeName(), System.currentTimeMillis(), new HashMap(this.alterPipeRequest.getExtractorAttributes()), new HashMap(this.alterPipeRequest.getProcessorAttributes()), new HashMap(this.alterPipeRequest.getConnectorAttributes()));
        ConcurrentHashMap<Integer, PipeTaskMeta> updatedConsensusGroupIdToTaskMetaMap = new ConcurrentHashMap<Integer, PipeTaskMeta>();
        env.getConfigManager().getLoadManager().getRegionLeaderMap().forEach((regionGroupId, regionLeaderNodeId) -> {
            String databaseName = env.getConfigManager().getPartitionManager().getRegionStorageGroup((TConsensusGroupId)regionGroupId);
            PipeTaskMeta currentPipeTaskMeta = (PipeTaskMeta)currentConsensusGroupId2PipeTaskMeta.get(regionGroupId.getId());
            if (databaseName != null && !databaseName.equals("root.__system") && !databaseName.startsWith("root.__system.") && currentPipeTaskMeta.getLeaderNodeId() == regionLeaderNodeId.intValue()) {
                updatedConsensusGroupIdToTaskMetaMap.put(regionGroupId.getId(), new PipeTaskMeta(currentPipeTaskMeta.getProgressIndex(), regionLeaderNodeId.intValue()));
            }
        });
        PipeTaskMeta configRegionTaskMeta = (PipeTaskMeta)currentConsensusGroupId2PipeTaskMeta.get(Integer.MIN_VALUE);
        if (Objects.nonNull(configRegionTaskMeta)) {
            updatedConsensusGroupIdToTaskMetaMap.put(Integer.MIN_VALUE, new PipeTaskMeta(configRegionTaskMeta.getProgressIndex(), ConfigNodeDescriptor.getInstance().getConf().getConfigNodeId()));
        }
        this.updatedPipeRuntimeMeta = new PipeRuntimeMeta(updatedConsensusGroupIdToTaskMetaMap);
        if (!((PipeTaskInfo)this.pipeTaskInfo.get()).isPipeStoppedByUser(this.alterPipeRequest.getPipeName())) {
            this.updatedPipeRuntimeMeta.getStatus().set(PipeStatus.RUNNING);
        }
    }

    @Override
    public void executeFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv env) throws PipeException {
        TSStatus response;
        LOGGER.info("AlterPipeProcedureV2: executeFromWriteConfigNodeConsensus({})", (Object)this.alterPipeRequest.getPipeName());
        try {
            response = env.getConfigManager().getConsensusManager().write(new AlterPipePlanV2(this.updatedPipeStaticMeta, this.updatedPipeRuntimeMeta));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            response = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            response.setMessage(e.getMessage());
        }
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(response.getMessage());
        }
    }

    @Override
    public void executeFromOperateOnDataNodes(ConfigNodeProcedureEnv env) throws IOException {
        String pipeName = this.alterPipeRequest.getPipeName();
        LOGGER.info("AlterPipeProcedureV2: executeFromOperateOnDataNodes({})", (Object)pipeName);
        String exceptionMessage = AlterPipeProcedureV2.parsePushPipeMetaExceptionForPipe(pipeName, this.pushSinglePipeMetaToDataNodes(pipeName, env));
        if (!exceptionMessage.isEmpty()) {
            LOGGER.warn("Failed to alter pipe {}, details: {}, metadata will be synchronized later.", (Object)this.alterPipeRequest.getPipeName(), (Object)exceptionMessage);
        }
    }

    @Override
    public void rollbackFromValidateTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("AlterPipeProcedureV2: rollbackFromValidateTask({})", (Object)this.alterPipeRequest.getPipeName());
    }

    @Override
    public void rollbackFromCalculateInfoForTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("AlterPipeProcedureV2: rollbackFromCalculateInfoForTask({})", (Object)this.alterPipeRequest.getPipeName());
    }

    @Override
    public void rollbackFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv env) {
        TSStatus response;
        LOGGER.info("AlterPipeProcedureV2: rollbackFromWriteConfigNodeConsensus({})", (Object)this.alterPipeRequest.getPipeName());
        try {
            response = env.getConfigManager().getConsensusManager().write(new AlterPipePlanV2(this.currentPipeStaticMeta, this.currentPipeRuntimeMeta));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            response = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            response.setMessage(e.getMessage());
        }
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(response.getMessage());
        }
    }

    @Override
    public void rollbackFromOperateOnDataNodes(ConfigNodeProcedureEnv env) throws IOException {
        LOGGER.info("AlterPipeProcedureV2: rollbackFromOperateOnDataNodes({})", (Object)this.alterPipeRequest.getPipeName());
        String exceptionMessage = AlterPipeProcedureV2.parsePushPipeMetaExceptionForPipe(this.alterPipeRequest.getPipeName(), this.pushPipeMetaToDataNodes(env));
        if (!exceptionMessage.isEmpty()) {
            LOGGER.warn("Failed to rollback alter pipe {}, details: {}, metadata will be synchronized later.", (Object)this.alterPipeRequest.getPipeName(), (Object)exceptionMessage);
        }
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(this.procedureType.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.alterPipeRequest.getPipeName(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.alterPipeRequest.getProcessorAttributesSize(), (OutputStream)stream);
        for (Map.Entry entry : this.alterPipeRequest.getProcessorAttributes().entrySet()) {
            ReadWriteIOUtils.write((String)((String)entry.getKey()), (OutputStream)stream);
            ReadWriteIOUtils.write((String)((String)entry.getValue()), (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.alterPipeRequest.getConnectorAttributesSize(), (OutputStream)stream);
        for (Map.Entry entry : this.alterPipeRequest.getConnectorAttributes().entrySet()) {
            ReadWriteIOUtils.write((String)((String)entry.getKey()), (OutputStream)stream);
            ReadWriteIOUtils.write((String)((String)entry.getValue()), (OutputStream)stream);
        }
        ReadWriteIOUtils.write((Boolean)this.alterPipeRequest.isReplaceAllProcessorAttributes, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.alterPipeRequest.isReplaceAllConnectorAttributes, (OutputStream)stream);
        if (this.currentPipeStaticMeta != null) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            this.currentPipeStaticMeta.serialize((OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
        if (this.updatedPipeStaticMeta != null) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            this.updatedPipeStaticMeta.serialize((OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
        if (this.currentPipeRuntimeMeta != null) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            this.currentPipeRuntimeMeta.serialize((OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
        if (this.updatedPipeRuntimeMeta != null) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            this.updatedPipeRuntimeMeta.serialize((OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
        if (this.procedureType.getTypeCode() == ProcedureType.ALTER_PIPE_PROCEDURE_V3.getTypeCode()) {
            ReadWriteIOUtils.write((int)this.alterPipeRequest.getExtractorAttributesSize(), (OutputStream)stream);
            for (Map.Entry entry : this.alterPipeRequest.getExtractorAttributes().entrySet()) {
                ReadWriteIOUtils.write((String)((String)entry.getKey()), (OutputStream)stream);
                ReadWriteIOUtils.write((String)((String)entry.getValue()), (OutputStream)stream);
            }
            ReadWriteIOUtils.write((Boolean)this.alterPipeRequest.isReplaceAllExtractorAttributes, (OutputStream)stream);
        }
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        int i;
        super.deserialize(byteBuffer);
        this.alterPipeRequest = new TAlterPipeReq().setPipeName(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer)).setExtractorAttributes(new HashMap()).setProcessorAttributes(new HashMap()).setConnectorAttributes(new HashMap());
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (i = 0; i < size; ++i) {
            this.alterPipeRequest.getProcessorAttributes().put(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer), ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (i = 0; i < size; ++i) {
            this.alterPipeRequest.getConnectorAttributes().put(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer), ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        this.alterPipeRequest.isReplaceAllProcessorAttributes = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        this.alterPipeRequest.isReplaceAllConnectorAttributes = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            this.currentPipeStaticMeta = PipeStaticMeta.deserialize((ByteBuffer)byteBuffer);
        }
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            this.updatedPipeStaticMeta = PipeStaticMeta.deserialize((ByteBuffer)byteBuffer);
        }
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            this.currentPipeRuntimeMeta = PipeRuntimeMeta.deserialize((ByteBuffer)byteBuffer);
        }
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            this.updatedPipeRuntimeMeta = PipeRuntimeMeta.deserialize((ByteBuffer)byteBuffer);
        }
        if (this.procedureType.getTypeCode() == ProcedureType.ALTER_PIPE_PROCEDURE_V3.getTypeCode()) {
            size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            for (i = 0; i < size; ++i) {
                this.alterPipeRequest.getExtractorAttributes().put(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer), ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
            }
            this.alterPipeRequest.isReplaceAllExtractorAttributes = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        } else {
            this.alterPipeRequest.setExtractorAttributes(new HashMap());
            this.alterPipeRequest.isReplaceAllExtractorAttributes = false;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlterPipeProcedureV2 that = (AlterPipeProcedureV2)o;
        return this.alterPipeRequest.getPipeName().equals(that.alterPipeRequest.getPipeName()) && this.alterPipeRequest.getExtractorAttributes().toString().equals(that.alterPipeRequest.getExtractorAttributes().toString()) && this.alterPipeRequest.getProcessorAttributes().toString().equals(that.alterPipeRequest.getProcessorAttributes().toString()) && this.alterPipeRequest.getConnectorAttributes().toString().equals(that.alterPipeRequest.getConnectorAttributes().toString());
    }

    public int hashCode() {
        return Objects.hash(this.alterPipeRequest.getPipeName(), this.alterPipeRequest.getExtractorAttributes(), this.alterPipeRequest.getProcessorAttributes(), this.alterPipeRequest.getConnectorAttributes());
    }
}

