/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.pipe;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.pipe.agent.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeMetaKeeper;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStatus;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTemporaryMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeType;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.runtime.PipeHandleLeaderChangePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.runtime.PipeHandleMetaChangePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.AlterPipePlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.CreatePipePlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.DropPipePlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.OperateMultiplePipesPlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.SetPipeStatusPlanV2;
import org.apache.iotdb.confignode.consensus.response.pipe.task.PipeTableResp;
import org.apache.iotdb.confignode.manager.pipe.resource.PipeConfigNodeResourceManager;
import org.apache.iotdb.confignode.rpc.thrift.TAlterPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.mpp.rpc.thrift.TPushPipeMetaResp;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTaskInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTaskInfo.class);
    private static final String SNAPSHOT_FILE_NAME = "pipe_task_info.bin";
    private final PipeMetaKeeper pipeMetaKeeper = new PipeMetaKeeper();
    private final PipeTaskInfoVersion pipeTaskInfoVersion = new PipeTaskInfoVersion();

    private void acquireReadLock() {
        this.pipeMetaKeeper.acquireReadLock();
    }

    private void releaseReadLock() {
        this.pipeMetaKeeper.releaseReadLock();
    }

    private void acquireWriteLock() {
        this.pipeMetaKeeper.acquireWriteLock();
        this.pipeTaskInfoVersion.increaseLatestVersion();
    }

    private void releaseWriteLock() {
        this.pipeMetaKeeper.releaseWriteLock();
    }

    public void updateLastSyncedVersion() {
        this.pipeTaskInfoVersion.updateLastSyncedVersion();
    }

    public boolean canSkipNextSync() {
        return this.pipeTaskInfoVersion.canSkipNextSync();
    }

    public boolean checkBeforeCreatePipe(TCreatePipeReq createPipeRequest) throws PipeException {
        this.acquireReadLock();
        try {
            boolean bl = this.checkBeforeCreatePipeInternal(createPipeRequest);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private boolean checkBeforeCreatePipeInternal(TCreatePipeReq createPipeRequest) throws PipeException {
        if (!this.isPipeExisted(createPipeRequest.getPipeName())) {
            return true;
        }
        if (createPipeRequest.isSetIfNotExistsCondition() && createPipeRequest.isIfNotExistsCondition()) {
            return false;
        }
        String exceptionMessage = String.format("Failed to create pipe %s, the pipe with the same name has been created", createPipeRequest.getPipeName());
        LOGGER.warn(exceptionMessage);
        throw new PipeException(exceptionMessage);
    }

    public boolean checkAndUpdateRequestBeforeAlterPipe(TAlterPipeReq alterPipeRequest) throws PipeException {
        this.acquireReadLock();
        try {
            boolean bl = this.checkAndUpdateRequestBeforeAlterPipeInternal(alterPipeRequest);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private boolean checkAndUpdateRequestBeforeAlterPipeInternal(TAlterPipeReq alterPipeRequest) throws PipeException {
        if (!this.isPipeExisted(alterPipeRequest.getPipeName())) {
            if (alterPipeRequest.isSetIfExistsCondition() && alterPipeRequest.isIfExistsCondition()) {
                return false;
            }
            String exceptionMessage = String.format("Failed to alter pipe %s, the pipe does not exist", alterPipeRequest.getPipeName());
            LOGGER.warn(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
        PipeStaticMeta pipeStaticMetaFromCoordinator = this.getPipeMetaByPipeName(alterPipeRequest.getPipeName()).getStaticMeta();
        PipeStaticMeta copiedPipeStaticMetaFromCoordinator = new PipeStaticMeta(pipeStaticMetaFromCoordinator.getPipeName(), pipeStaticMetaFromCoordinator.getCreationTime(), new HashMap(pipeStaticMetaFromCoordinator.getExtractorParameters().getAttribute()), new HashMap(pipeStaticMetaFromCoordinator.getProcessorParameters().getAttribute()), new HashMap(pipeStaticMetaFromCoordinator.getConnectorParameters().getAttribute()));
        if (!alterPipeRequest.isReplaceAllExtractorAttributes) {
            if (alterPipeRequest.getExtractorAttributes().isEmpty()) {
                alterPipeRequest.setExtractorAttributes(copiedPipeStaticMetaFromCoordinator.getExtractorParameters().getAttribute());
            } else {
                alterPipeRequest.setExtractorAttributes(copiedPipeStaticMetaFromCoordinator.getExtractorParameters().addOrReplaceEquivalentAttributes(new PipeParameters(alterPipeRequest.getExtractorAttributes())).getAttribute());
            }
        }
        if (!alterPipeRequest.isReplaceAllProcessorAttributes) {
            if (alterPipeRequest.getProcessorAttributes().isEmpty()) {
                alterPipeRequest.setProcessorAttributes(copiedPipeStaticMetaFromCoordinator.getProcessorParameters().getAttribute());
            } else {
                alterPipeRequest.setProcessorAttributes(copiedPipeStaticMetaFromCoordinator.getProcessorParameters().addOrReplaceEquivalentAttributes(new PipeParameters(alterPipeRequest.getProcessorAttributes())).getAttribute());
            }
        }
        if (!alterPipeRequest.isReplaceAllConnectorAttributes) {
            if (alterPipeRequest.getConnectorAttributes().isEmpty()) {
                alterPipeRequest.setConnectorAttributes(copiedPipeStaticMetaFromCoordinator.getConnectorParameters().getAttribute());
            } else {
                alterPipeRequest.setConnectorAttributes(copiedPipeStaticMetaFromCoordinator.getConnectorParameters().addOrReplaceEquivalentAttributes(new PipeParameters(alterPipeRequest.getConnectorAttributes())).getAttribute());
            }
        }
        return true;
    }

    public void checkBeforeStartPipe(String pipeName) throws PipeException {
        this.acquireReadLock();
        try {
            this.checkBeforeStartPipeInternal(pipeName);
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void checkBeforeStartPipeInternal(String pipeName) throws PipeException {
        if (!this.isPipeExisted(pipeName)) {
            String exceptionMessage = String.format("Failed to start pipe %s, the pipe does not exist", pipeName);
            LOGGER.warn(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
        PipeStatus pipeStatus = this.getPipeStatus(pipeName);
        if (pipeStatus == PipeStatus.DROPPED) {
            String exceptionMessage = String.format("Failed to start pipe %s, the pipe is already dropped", pipeName);
            LOGGER.warn(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
    }

    public void checkBeforeStopPipe(String pipeName) throws PipeException {
        this.acquireReadLock();
        try {
            this.checkBeforeStopPipeInternal(pipeName);
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void checkBeforeStopPipeInternal(String pipeName) throws PipeException {
        if (!this.isPipeExisted(pipeName)) {
            String exceptionMessage = String.format("Failed to stop pipe %s, the pipe does not exist", pipeName);
            LOGGER.warn(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
        PipeStatus pipeStatus = this.getPipeStatus(pipeName);
        if (pipeStatus == PipeStatus.DROPPED) {
            String exceptionMessage = String.format("Failed to stop pipe %s, the pipe is already dropped", pipeName);
            LOGGER.warn(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
    }

    public void checkBeforeDropPipe(String pipeName) {
        this.acquireReadLock();
        try {
            this.checkBeforeDropPipeInternal(pipeName);
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void checkBeforeDropPipeInternal(String pipeName) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Check before drop pipe {}, pipe exists: {}.", (Object)pipeName, (Object)this.isPipeExisted(pipeName));
        }
    }

    public boolean isPipeExisted(String pipeName) {
        this.acquireReadLock();
        try {
            boolean bl = this.pipeMetaKeeper.containsPipeMeta(pipeName);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private PipeStatus getPipeStatus(String pipeName) {
        this.acquireReadLock();
        try {
            PipeStatus pipeStatus = (PipeStatus)this.pipeMetaKeeper.getPipeMeta(pipeName).getRuntimeMeta().getStatus().get();
            return pipeStatus;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public boolean isPipeRunning(String pipeName) {
        this.acquireReadLock();
        try {
            boolean bl = this.pipeMetaKeeper.containsPipeMeta(pipeName) && PipeStatus.RUNNING.equals((Object)this.getPipeStatus(pipeName));
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public boolean isPipeStoppedByUser(String pipeName) {
        this.acquireReadLock();
        try {
            boolean bl = this.pipeMetaKeeper.containsPipeMeta(pipeName) && PipeStatus.STOPPED.equals((Object)this.getPipeStatus(pipeName)) && !this.isStoppedByRuntimeException(pipeName);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public void validatePipePluginUsageByPipe(String pluginName) {
        this.acquireReadLock();
        try {
            this.validatePipePluginUsageByPipeInternal(pluginName);
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void validatePipePluginUsageByPipeInternal(String pluginName) {
        Iterable<PipeMeta> pipeMetas = this.getPipeMetaList();
        for (PipeMeta pipeMeta : pipeMetas) {
            PipeParameters extractorParameters = pipeMeta.getStaticMeta().getExtractorParameters();
            String extractorPluginName = extractorParameters.getStringOrDefault(Arrays.asList("extractor", "source"), BuiltinPipePlugin.IOTDB_EXTRACTOR.getPipePluginName());
            if (pluginName.equals(extractorPluginName)) {
                String exceptionMessage = String.format("PipePlugin '%s' is already used by Pipe '%s' as a source.", pluginName, pipeMeta.getStaticMeta().getPipeName());
                throw new PipeException(exceptionMessage);
            }
            PipeParameters processorParameters = pipeMeta.getStaticMeta().getProcessorParameters();
            String processorPluginName = processorParameters.getString("processor");
            if (pluginName.equals(processorPluginName)) {
                String exceptionMessage = String.format("PipePlugin '%s' is already used by Pipe '%s' as a processor.", pluginName, pipeMeta.getStaticMeta().getPipeName());
                throw new PipeException(exceptionMessage);
            }
            PipeParameters connectorParameters = pipeMeta.getStaticMeta().getConnectorParameters();
            String connectorPluginName = connectorParameters.getStringOrDefault(Arrays.asList("connector", "sink"), BuiltinPipePlugin.IOTDB_THRIFT_CONNECTOR.getPipePluginName());
            if (!pluginName.equals(connectorPluginName)) continue;
            String exceptionMessage = String.format("PipePlugin '%s' is already used by Pipe '%s' as a sink.", pluginName, pipeMeta.getStaticMeta().getPipeName());
            throw new PipeException(exceptionMessage);
        }
    }

    public TSStatus createPipe(CreatePipePlanV2 plan) {
        this.acquireWriteLock();
        try {
            this.pipeMetaKeeper.addPipeMeta(plan.getPipeStaticMeta().getPipeName(), new PipeMeta(plan.getPipeStaticMeta(), plan.getPipeRuntimeMeta()));
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus operateMultiplePipes(OperateMultiplePipesPlanV2 plan) {
        this.acquireWriteLock();
        try {
            if (plan.getSubPlans() == null || plan.getSubPlans().isEmpty()) {
                TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
                return tSStatus;
            }
            TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            status.setSubStatus(new ArrayList());
            for (ConfigPhysicalPlan subPlan : plan.getSubPlans()) {
                try {
                    if (subPlan instanceof CreatePipePlanV2) {
                        this.createPipe((CreatePipePlanV2)subPlan);
                    } else if (subPlan instanceof AlterPipePlanV2) {
                        this.alterPipe((AlterPipePlanV2)subPlan);
                    } else if (subPlan instanceof SetPipeStatusPlanV2) {
                        this.setPipeStatus((SetPipeStatusPlanV2)subPlan);
                    } else if (subPlan instanceof DropPipePlanV2) {
                        this.dropPipe((DropPipePlanV2)subPlan);
                    } else {
                        throw new PipeException(String.format("Unsupported subPlan type: %s", subPlan.getClass().getName()));
                    }
                    status.getSubStatus().add(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
                }
                catch (Exception e) {
                    LOGGER.error("Failed to operate pipe", (Throwable)e);
                    status.setCode(TSStatusCode.PIPE_ERROR.getStatusCode());
                    status.getSubStatus().add(new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()));
                    break;
                }
            }
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                status.setSubStatus(null);
            }
            TSStatus tSStatus = status;
            return tSStatus;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus alterPipe(AlterPipePlanV2 plan) {
        this.acquireWriteLock();
        try {
            PipeTemporaryMeta temporaryMeta = this.pipeMetaKeeper.getPipeMeta(plan.getPipeStaticMeta().getPipeName()).getTemporaryMeta();
            this.pipeMetaKeeper.removePipeMeta(plan.getPipeStaticMeta().getPipeName());
            this.pipeMetaKeeper.addPipeMeta(plan.getPipeStaticMeta().getPipeName(), new PipeMeta(plan.getPipeStaticMeta(), plan.getPipeRuntimeMeta(), temporaryMeta));
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public TSStatus setPipeStatus(SetPipeStatusPlanV2 plan) {
        this.acquireWriteLock();
        try {
            this.pipeMetaKeeper.getPipeMeta(plan.getPipeName()).getRuntimeMeta().getStatus().set(plan.getPipeStatus());
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public TSStatus dropPipe(DropPipePlanV2 plan) {
        this.acquireWriteLock();
        try {
            this.pipeMetaKeeper.removePipeMeta(plan.getPipeName());
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public DataSet showPipes() {
        this.acquireReadLock();
        try {
            PipeTableResp pipeTableResp = new PipeTableResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), StreamSupport.stream(this.getPipeMetaList().spliterator(), false).collect(Collectors.toList()));
            return pipeTableResp;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public Iterable<PipeMeta> getPipeMetaList() {
        this.acquireReadLock();
        try {
            Iterable iterable = this.pipeMetaKeeper.getPipeMetaList();
            return iterable;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public PipeMeta getPipeMetaByPipeName(String pipeName) {
        this.acquireReadLock();
        try {
            PipeMeta pipeMeta = this.pipeMetaKeeper.getPipeMetaByPipeName(pipeName);
            return pipeMeta;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public boolean isEmpty() {
        this.acquireReadLock();
        try {
            boolean bl = this.pipeMetaKeeper.isEmpty();
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public TSStatus handleLeaderChange(PipeHandleLeaderChangePlan plan) {
        this.acquireWriteLock();
        try {
            TSStatus tSStatus = this.handleLeaderChangeInternal(plan);
            return tSStatus;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private TSStatus handleLeaderChangeInternal(PipeHandleLeaderChangePlan plan) {
        plan.getConsensusGroupId2NewLeaderIdMap().forEach((consensusGroupId, newLeader) -> this.pipeMetaKeeper.getPipeMetaList().forEach(pipeMeta -> {
            if (PipeType.CONSENSUS.equals((Object)pipeMeta.getStaticMeta().getPipeType())) {
                return;
            }
            ConcurrentMap consensusGroupIdToTaskMetaMap = pipeMeta.getRuntimeMeta().getConsensusGroupId2TaskMetaMap();
            if (consensusGroupIdToTaskMetaMap.containsKey(consensusGroupId.getId())) {
                if (newLeader != -1) {
                    ((PipeTaskMeta)consensusGroupIdToTaskMetaMap.get(consensusGroupId.getId())).setLeaderNodeId(newLeader.intValue());
                    pipeMeta.getTemporaryMeta().markDataNodeUncompleted(newLeader.intValue());
                } else {
                    consensusGroupIdToTaskMetaMap.remove(consensusGroupId.getId());
                }
            } else if (newLeader != -1) {
                consensusGroupIdToTaskMetaMap.put(consensusGroupId.getId(), new PipeTaskMeta((ProgressIndex)MinimumProgressIndex.INSTANCE, newLeader.intValue()));
            }
        }));
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus handleMetaChanges(PipeHandleMetaChangePlan plan) {
        this.acquireWriteLock();
        try {
            TSStatus tSStatus = this.handleMetaChangesInternal(plan);
            return tSStatus;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private TSStatus handleMetaChangesInternal(PipeHandleMetaChangePlan plan) {
        LOGGER.info("Handling pipe meta changes ...");
        this.pipeMetaKeeper.clear();
        Optional logger = PipeConfigNodeResourceManager.log().schedule(PipeTaskInfo.class, PipeConfig.getInstance().getPipeMetaReportMaxLogNumPerRound(), PipeConfig.getInstance().getPipeMetaReportMaxLogIntervalRounds(), this.pipeMetaKeeper.getPipeMetaCount());
        plan.getPipeMetaList().forEach(pipeMeta -> {
            this.pipeMetaKeeper.addPipeMeta(pipeMeta.getStaticMeta().getPipeName(), pipeMeta);
            logger.ifPresent(l -> l.info("Recording pipe meta: {}", pipeMeta));
        });
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public boolean isStoppedByRuntimeException(String pipeName) {
        this.acquireReadLock();
        try {
            boolean bl = this.isStoppedByRuntimeExceptionInternal(pipeName);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private boolean isStoppedByRuntimeExceptionInternal(String pipeName) {
        return this.pipeMetaKeeper.containsPipeMeta(pipeName) && this.pipeMetaKeeper.getPipeMeta(pipeName).getRuntimeMeta().getIsStoppedByRuntimeException();
    }

    public void clearExceptionsAndSetIsStoppedByRuntimeExceptionToFalse(String pipeName) {
        this.acquireWriteLock();
        try {
            this.clearExceptionsAndSetIsStoppedByRuntimeExceptionToFalseInternal(pipeName);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void clearExceptionsAndSetIsStoppedByRuntimeExceptionToFalseInternal(String pipeName) {
        if (!this.pipeMetaKeeper.containsPipeMeta(pipeName)) {
            return;
        }
        PipeRuntimeMeta runtimeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName).getRuntimeMeta();
        runtimeMeta.setIsStoppedByRuntimeException(false);
        runtimeMeta.setExceptionsClearTime(System.currentTimeMillis());
        ConcurrentMap exceptionMap = runtimeMeta.getNodeId2PipeRuntimeExceptionMap();
        if (!exceptionMap.isEmpty()) {
            exceptionMap.clear();
        }
        runtimeMeta.getConsensusGroupId2TaskMetaMap().values().forEach(pipeTaskMeta -> {
            if (pipeTaskMeta.getExceptionMessages().iterator().hasNext()) {
                pipeTaskMeta.clearExceptionMessages();
            }
        });
    }

    public void setIsStoppedByRuntimeExceptionToFalse(String pipeName) {
        this.acquireWriteLock();
        try {
            this.setIsStoppedByRuntimeExceptionToFalseInternal(pipeName);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void setIsStoppedByRuntimeExceptionToFalseInternal(String pipeName) {
        if (!this.pipeMetaKeeper.containsPipeMeta(pipeName)) {
            return;
        }
        this.pipeMetaKeeper.getPipeMeta(pipeName).getRuntimeMeta().setIsStoppedByRuntimeException(false);
    }

    public boolean recordDataNodePushPipeMetaExceptions(Map<Integer, TPushPipeMetaResp> respMap) {
        this.acquireWriteLock();
        try {
            boolean bl = this.recordDataNodePushPipeMetaExceptionsInternal(respMap);
            return bl;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private boolean recordDataNodePushPipeMetaExceptionsInternal(Map<Integer, TPushPipeMetaResp> respMap) {
        boolean hasException = false;
        for (Map.Entry<Integer, TPushPipeMetaResp> respEntry : respMap.entrySet()) {
            int dataNodeId = respEntry.getKey();
            TPushPipeMetaResp resp = respEntry.getValue();
            if (resp.getStatus().getCode() != TSStatusCode.PIPE_PUSH_META_ERROR.getStatusCode()) continue;
            hasException = true;
            if (!resp.isSetExceptionMessages()) continue;
            resp.getExceptionMessages().stream().filter(message -> this.pipeMetaKeeper.containsPipeMeta(message.getPipeName())).forEach(message -> {
                PipeRuntimeMeta runtimeMeta = this.pipeMetaKeeper.getPipeMeta(message.getPipeName()).getRuntimeMeta();
                runtimeMeta.getStatus().set(PipeStatus.STOPPED);
                runtimeMeta.setIsStoppedByRuntimeException(true);
                ConcurrentMap exceptionMap = runtimeMeta.getNodeId2PipeRuntimeExceptionMap();
                if (!exceptionMap.containsKey(dataNodeId) || ((PipeRuntimeException)exceptionMap.get(dataNodeId)).getTimeStamp() < message.getTimeStamp()) {
                    exceptionMap.put(dataNodeId, new PipeRuntimeCriticalException(message.getMessage(), message.getTimeStamp()));
                }
            });
        }
        return hasException;
    }

    public boolean autoRestart() {
        this.acquireWriteLock();
        try {
            boolean bl = this.autoRestartInternal();
            return bl;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private boolean autoRestartInternal() {
        AtomicBoolean needRestart = new AtomicBoolean(false);
        LinkedList pipeToRestart = new LinkedList();
        this.pipeMetaKeeper.getPipeMetaList().forEach(pipeMeta -> {
            if (pipeMeta.getRuntimeMeta().getIsStoppedByRuntimeException()) {
                pipeMeta.getRuntimeMeta().getStatus().set(PipeStatus.RUNNING);
                needRestart.set(true);
                pipeToRestart.add(pipeMeta.getStaticMeta().getPipeName());
            }
        });
        if (needRestart.get()) {
            LOGGER.info("PipeMetaSyncer is trying to restart the pipes: {}", pipeToRestart);
        }
        return needRestart.get();
    }

    public void handleSuccessfulRestart() {
        this.acquireWriteLock();
        try {
            this.handleSuccessfulRestartInternal();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void handleSuccessfulRestartInternal() {
        this.pipeMetaKeeper.getPipeMetaList().forEach(pipeMeta -> {
            if (((PipeStatus)pipeMeta.getRuntimeMeta().getStatus().get()).equals((Object)PipeStatus.RUNNING)) {
                this.clearExceptionsAndSetIsStoppedByRuntimeExceptionToFalse(pipeMeta.getStaticMeta().getPipeName());
            }
        });
    }

    public void removePipeMeta(String pipeName) {
        this.acquireWriteLock();
        try {
            this.removePipeMetaInternal(pipeName);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void removePipeMetaInternal(String pipeName) {
        this.pipeMetaKeeper.removePipeMeta(pipeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processTakeSnapshot(File snapshotDir) throws IOException {
        this.acquireReadLock();
        try {
            File snapshotFile = new File(snapshotDir, SNAPSHOT_FILE_NAME);
            if (snapshotFile.exists() && snapshotFile.isFile()) {
                LOGGER.error("Failed to take snapshot, because snapshot file [{}] is already exist.", (Object)snapshotFile.getAbsolutePath());
                boolean bl = false;
                return bl;
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(snapshotFile);){
                this.pipeMetaKeeper.processTakeSnapshot(fileOutputStream);
                fileOutputStream.getFD().sync();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLoadSnapshot(File snapshotDir) throws IOException {
        this.acquireWriteLock();
        try {
            File snapshotFile = new File(snapshotDir, SNAPSHOT_FILE_NAME);
            if (!snapshotFile.exists() || !snapshotFile.isFile()) {
                LOGGER.error("Failed to load snapshot,snapshot file [{}] is not exist.", (Object)snapshotFile.getAbsolutePath());
                return;
            }
            try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);){
                this.pipeMetaKeeper.processLoadSnapshot(fileInputStream);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public int hashCode() {
        return this.pipeMetaKeeper.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PipeTaskInfo other = (PipeTaskInfo)obj;
        return this.pipeMetaKeeper.equals((Object)other.pipeMetaKeeper);
    }

    public String toString() {
        return this.pipeMetaKeeper.toString();
    }

    public long runningPipeCount() {
        return this.pipeMetaKeeper.runningPipeCount();
    }

    public long droppedPipeCount() {
        return this.pipeMetaKeeper.droppedPipeCount();
    }

    public long userStoppedPipeCount() {
        return this.pipeMetaKeeper.userStoppedPipeCount();
    }

    public long exceptionStoppedPipeCount() {
        return this.pipeMetaKeeper.exceptionStoppedPipeCount();
    }

    private class PipeTaskInfoVersion {
        private final AtomicLong latestVersion = new AtomicLong(0L);
        private long lastSyncedVersion = 0L;
        private boolean isLastSyncedPipeTaskInfoEmpty = false;

        public void increaseLatestVersion() {
            this.latestVersion.incrementAndGet();
        }

        public void updateLastSyncedVersion() {
            this.lastSyncedVersion = this.latestVersion.get();
            this.isLastSyncedPipeTaskInfoEmpty = PipeTaskInfo.this.pipeMetaKeeper.isEmpty();
        }

        public boolean canSkipNextSync() {
            return this.isLastSyncedPipeTaskInfoEmpty && PipeTaskInfo.this.pipeMetaKeeper.isEmpty() && this.lastSyncedVersion == this.latestVersion.get();
        }
    }
}

