/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.ttl.TTLCache;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.confignode.consensus.request.read.ttl.ShowTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.response.ttl.ShowTTLResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TTLInfo
implements SnapshotProcessor {
    public static final String SNAPSHOT_FILENAME = "ttl_info.bin";
    private static final Logger LOGGER = LoggerFactory.getLogger(TTLInfo.class);
    private final TTLCache ttlCache = new TTLCache();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setTTL(SetTTLPlan plan) {
        this.lock.writeLock().lock();
        try {
            int tTlRuleCapacity = CommonDescriptor.getInstance().getConfig().getTTlRuleCapacity();
            if (this.getTTLCount() >= tTlRuleCapacity) {
                TSStatus errorStatus = new TSStatus(TSStatusCode.OVERSIZE_TTL.getStatusCode());
                errorStatus.setMessage(String.format("The number of TTL rules has reached the limit (%d). Please delete some existing rules first.", tTlRuleCapacity));
                TSStatus tSStatus = errorStatus;
                return tSStatus;
            }
            this.ttlCache.setTTL(plan.getPathPattern(), plan.getTTL());
            if (plan.isDataBase()) {
                String[] pathNodes = Arrays.copyOf(plan.getPathPattern(), plan.getPathPattern().length + 1);
                pathNodes[pathNodes.length - 1] = "**";
                this.ttlCache.setTTL(pathNodes, plan.getTTL());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTTL(Map<String, Long> databaseTTLMap) throws IllegalPathException {
        this.lock.writeLock().lock();
        try {
            for (Map.Entry<String, Long> entry : databaseTTLMap.entrySet()) {
                String[] nodesWithWildcard = PathUtils.splitPathToDetachedNodes((String)entry.getKey().concat(".**"));
                this.ttlCache.setTTL(nodesWithWildcard, entry.getValue().longValue());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public TSStatus unsetTTL(SetTTLPlan plan) {
        TSStatus status;
        this.lock.writeLock().lock();
        try {
            status = this.ttlCache.unsetTTL(plan.getPathPattern());
            if (status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode() && plan.isDataBase()) {
                status = this.ttlCache.unsetTTL(new PartialPath(plan.getPathPattern()).concatNode("**").getNodes());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShowTTLResp showTTL(ShowTTLPlan plan) {
        ShowTTLResp resp = new ShowTTLResp();
        HashMap<String, Long> pathTTLMap = new HashMap<String, Long>();
        this.lock.readLock().lock();
        try {
            PartialPath pathPattern = new PartialPath(plan.getPathPattern());
            for (Map.Entry entry : this.ttlCache.getAllTTLs().entrySet()) {
                if (!pathPattern.matchFullPath((String[])entry.getKey())) continue;
                pathTTLMap.put(String.join((CharSequence)String.valueOf('.'), (CharSequence[])entry.getKey()), (Long)entry.getValue());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        resp.setPathTTLMap(pathTTLMap);
        resp.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        return resp;
    }

    public int getTTLCount() {
        this.lock.readLock().lock();
        try {
            int n = this.ttlCache.getTtlCount();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
        if (snapshotFile.exists() && snapshotFile.isFile()) {
            LOGGER.error("Failed to take snapshot of TTLInfo, because snapshot file [{}] is already exist.", (Object)snapshotFile.getAbsolutePath());
            return false;
        }
        this.lock.writeLock().lock();
        try (FileOutputStream fileOutputStream = new FileOutputStream(snapshotFile);
             BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);){
            this.ttlCache.serialize((OutputStream)outputStream);
            fileOutputStream.getFD().sync();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return true;
    }

    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
        if (!snapshotFile.exists() || !snapshotFile.isFile()) {
            LOGGER.error("Failed to load snapshot of TTLInfo, snapshot file [{}] does not exist.", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        this.lock.writeLock().lock();
        try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            this.ttlCache.clear();
            this.ttlCache.deserialize((InputStream)bufferedInputStream);
        }
        catch (IllegalPathException e) {
            throw new IOException(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TTLInfo other = (TTLInfo)o;
        return this.getTTLCount() == other.getTTLCount() && this.showTTL(new ShowTTLPlan()).getPathTTLMap().equals(other.showTTL(new ShowTTLPlan()).getPathTTLMap());
    }

    public int hashCode() {
        return Objects.hash(this.getTTLCount(), this.showTTL(new ShowTTLPlan()).getPathTTLMap());
    }

    public void clear() {
        this.ttlCache.clear();
    }
}

