/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.metric;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTemporaryMeta;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTemporaryMetaMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTemporaryMetaMetrics.class);
    private volatile AbstractMetricService metricService;
    private final Map<String, PipeTemporaryMeta> pipeTemporaryMetaMap = new ConcurrentHashMap<String, PipeTemporaryMeta>();

    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        ImmutableSet.copyOf(this.pipeTemporaryMetaMap.keySet()).forEach(this::createMetrics);
    }

    private void createMetrics(String pipeID) {
        this.createAutoGauge(pipeID);
    }

    private void createAutoGauge(String pipeID) {
        PipeTemporaryMeta pipeTemporaryMeta = this.pipeTemporaryMetaMap.get(pipeID);
        String[] pipeNameAndCreationTime = pipeID.split("_");
        this.metricService.createAutoGauge(Metric.PIPE_GLOBAL_REMAINING_EVENT_COUNT.toString(), MetricLevel.IMPORTANT, (Object)pipeTemporaryMeta, PipeTemporaryMeta::getGlobalRemainingEvents, new String[]{Tag.NAME.toString(), pipeNameAndCreationTime[0], Tag.CREATION_TIME.toString(), pipeNameAndCreationTime[1]});
        this.metricService.createAutoGauge(Metric.PIPE_GLOBAL_REMAINING_TIME.toString(), MetricLevel.IMPORTANT, (Object)pipeTemporaryMeta, PipeTemporaryMeta::getGlobalRemainingTime, new String[]{Tag.NAME.toString(), pipeNameAndCreationTime[0], Tag.CREATION_TIME.toString(), pipeNameAndCreationTime[1]});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        ImmutableSet.copyOf(this.pipeTemporaryMetaMap.keySet()).forEach(this::deregister);
        if (!this.pipeTemporaryMetaMap.isEmpty()) {
            LOGGER.warn("Failed to unbind from pipe temporary meta metrics, PipeTemporaryMeta map not empty");
        }
    }

    private void removeMetrics(String pipeID) {
        this.removeAutoGauge(pipeID);
    }

    private void removeAutoGauge(String pipeID) {
        String[] pipeNameAndCreationTime = pipeID.split("_");
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_GLOBAL_REMAINING_EVENT_COUNT.toString(), new String[]{Tag.NAME.toString(), pipeNameAndCreationTime[0], Tag.CREATION_TIME.toString(), pipeNameAndCreationTime[1]});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_GLOBAL_REMAINING_TIME.toString(), new String[]{Tag.NAME.toString(), pipeNameAndCreationTime[0], Tag.CREATION_TIME.toString(), pipeNameAndCreationTime[1]});
        this.pipeTemporaryMetaMap.remove(pipeID);
    }

    public void register(PipeMeta pipeMeta) {
        String taskID = pipeMeta.getStaticMeta().getPipeName() + "_" + pipeMeta.getStaticMeta().getCreationTime();
        this.pipeTemporaryMetaMap.putIfAbsent(taskID, pipeMeta.getTemporaryMeta());
        if (Objects.nonNull(this.metricService)) {
            this.createMetrics(taskID);
        }
    }

    public void deregister(String pipeID) {
        if (!this.pipeTemporaryMetaMap.containsKey(pipeID)) {
            LOGGER.warn("Failed to deregister pipe temporary meta metrics, PipeTemporaryMeta({}) does not exist", (Object)pipeID);
            return;
        }
        if (Objects.nonNull(this.metricService)) {
            this.removeMetrics(pipeID);
        }
    }

    public void handleTemporaryMetaChanges(Iterable<PipeMeta> pipeMetaList) {
        HashSet pipeTaskIDs = new HashSet();
        pipeMetaList.forEach(pipeMeta -> {
            String pipeTaskID = pipeMeta.getStaticMeta().getPipeName() + "_" + pipeMeta.getStaticMeta().getCreationTime();
            if (!this.pipeTemporaryMetaMap.containsKey(pipeTaskID)) {
                this.register((PipeMeta)pipeMeta);
            }
            pipeTaskIDs.add(pipeTaskID);
        });
        ImmutableSet.copyOf(this.pipeTemporaryMetaMap.keySet()).stream().filter(pipeTaskID -> !pipeTaskIDs.contains(pipeTaskID)).forEach(this::deregister);
    }

    public static PipeTemporaryMetaMetrics getInstance() {
        return PipeTemporaryMetaMetricsHolder.INSTANCE;
    }

    private static class PipeTemporaryMetaMetricsHolder {
        private static final PipeTemporaryMetaMetrics INSTANCE = new PipeTemporaryMetaMetrics();

        private PipeTemporaryMetaMetricsHolder() {
        }
    }
}

