/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event.batch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.subscription.broker.SubscriptionPrefetchingQueue;
import org.apache.iotdb.db.subscription.event.SubscriptionEvent;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class SubscriptionPipeEventBatch {
    private final int regionId;
    protected final SubscriptionPrefetchingQueue prefetchingQueue;
    protected final int maxDelayInMs;
    protected final long maxBatchSizeInBytes;
    protected volatile List<SubscriptionEvent> events = null;

    protected SubscriptionPipeEventBatch(int regionId, SubscriptionPrefetchingQueue prefetchingQueue, int maxDelayInMs, long maxBatchSizeInBytes) {
        this.regionId = regionId;
        this.prefetchingQueue = prefetchingQueue;
        this.maxDelayInMs = maxDelayInMs;
        this.maxBatchSizeInBytes = maxBatchSizeInBytes;
    }

    public abstract boolean onEvent(Consumer<SubscriptionEvent> var1) throws Exception;

    public abstract boolean onEvent(@NonNull EnrichedEvent var1, Consumer<SubscriptionEvent> var2) throws Exception;

    public abstract void cleanUp();

    public int getRegionId() {
        return this.regionId;
    }

    public boolean isSealed() {
        return Objects.nonNull(this.events);
    }

    protected Map<String, String> coreReportMessage() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("regionId", String.valueOf(this.regionId));
        result.put("prefetchingQueue", this.prefetchingQueue.coreReportMessage().toString());
        result.put("maxDelayInMs", String.valueOf(this.maxDelayInMs));
        result.put("maxBatchSizeInBytes", String.valueOf(this.maxBatchSizeInBytes));
        return result;
    }
}

