/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.db.subscription.event.SubscriptionEventBinaryCache;
import org.apache.iotdb.db.subscription.event.pipe.SubscriptionPipeEvents;
import org.apache.iotdb.rpc.subscription.payload.poll.FilePiecePayload;
import org.apache.iotdb.rpc.subscription.payload.poll.FileSealPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponse;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponseType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionEvent.class);
    private static final long INVALID_TIMESTAMP = -1L;
    private final SubscriptionPipeEvents pipeEvents;
    private final SubscriptionPollResponse[] responses;
    private int currentResponseIndex = 0;
    private final ByteBuffer[] byteBuffers;
    private final SubscriptionCommitContext commitContext;
    private volatile String lastPolledConsumerId = null;
    private final AtomicLong lastPolledTimestamp = new AtomicLong(-1L);
    private final AtomicLong committedTimestamp = new AtomicLong(-1L);

    public SubscriptionEvent(SubscriptionPipeEvents pipeEvents, SubscriptionPollResponse initialResponse) {
        this.pipeEvents = pipeEvents;
        int responseLength = this.getResponseLength(initialResponse.getResponseType());
        this.responses = new SubscriptionPollResponse[responseLength];
        this.responses[0] = initialResponse;
        this.byteBuffers = new ByteBuffer[responseLength];
        this.commitContext = initialResponse.getCommitContext();
    }

    public SubscriptionEvent(SubscriptionPipeEvents pipeEvents, List<SubscriptionPollResponse> responses) {
        this.pipeEvents = pipeEvents;
        int responseLength = responses.size();
        this.responses = new SubscriptionPollResponse[responseLength];
        for (int i = 0; i < responseLength; ++i) {
            this.responses[i] = responses.get(i);
        }
        this.byteBuffers = new ByteBuffer[responseLength];
        this.commitContext = this.responses[0].getCommitContext();
    }

    private int getResponseLength(short responseType) {
        if (!Objects.equals(SubscriptionPollResponseType.FILE_INIT.getType(), responseType)) {
            LOGGER.warn("unexpected response type: {}", (Object)responseType);
            return 1;
        }
        long fileLength = this.pipeEvents.getTsFile().length();
        long readFileBufferSize = SubscriptionConfig.getInstance().getSubscriptionReadFileBufferSize();
        int length = (int)(fileLength / readFileBufferSize);
        return fileLength % readFileBufferSize != 0L ? length + 3 : length + 2;
    }

    public SubscriptionPollResponse getCurrentResponse() {
        return this.getResponse(this.currentResponseIndex);
    }

    private SubscriptionPollResponse getResponse(int index) {
        return this.responses[index];
    }

    public SubscriptionCommitContext getCommitContext() {
        return this.commitContext;
    }

    public void recordCommittedTimestamp() {
        this.committedTimestamp.set(System.currentTimeMillis());
    }

    public boolean isCommitted() {
        if (this.commitContext.getCommitId() == -1L) {
            return true;
        }
        return this.committedTimestamp.get() != -1L;
    }

    public boolean isCommittable() {
        if (this.commitContext.getCommitId() == -1L) {
            return false;
        }
        return this.currentResponseIndex >= this.responses.length - 1;
    }

    public void ack() {
        this.pipeEvents.ack();
    }

    public void cleanUp() {
        this.resetResponseByteBuffer(true);
        this.pipeEvents.cleanUp();
    }

    public void recordLastPolledTimestamp() {
        long newTimestamp;
        long currentTimestamp;
        while (!this.lastPolledTimestamp.compareAndSet(currentTimestamp = this.lastPolledTimestamp.get(), newTimestamp = Math.max(currentTimestamp, System.currentTimeMillis()))) {
        }
    }

    public boolean pollable() {
        if (this.isCommitted()) {
            return false;
        }
        if (this.lastPolledTimestamp.get() == -1L) {
            return true;
        }
        return this.canRecycle();
    }

    public boolean eagerlyPollable() {
        if (this.isCommitted()) {
            return false;
        }
        return this.lastPolledTimestamp.get() == -1L;
    }

    private boolean canRecycle() {
        return System.currentTimeMillis() - this.lastPolledTimestamp.get() > (long)SubscriptionConfig.getInstance().getSubscriptionRecycleUncommittedEventIntervalMs();
    }

    public void nack() {
        this.currentResponseIndex = 0;
        this.lastPolledTimestamp.set(-1L);
    }

    public void recordLastPolledConsumerId(String consumerId) {
        this.lastPolledConsumerId = consumerId;
    }

    public String getLastPolledConsumerId() {
        return this.lastPolledConsumerId;
    }

    private void prefetchResponse(int index) throws IOException {
        if (index >= this.responses.length || index <= 0) {
            return;
        }
        if (Objects.nonNull(this.responses[index])) {
            return;
        }
        SubscriptionPollResponse previousResponse = this.getResponse(index - 1);
        short responseType = previousResponse.getResponseType();
        SubscriptionPollPayload payload = previousResponse.getPayload();
        if (!SubscriptionPollResponseType.isValidatedResponseType((short)responseType)) {
            LOGGER.warn("unexpected response type: {}", (Object)responseType);
            return;
        }
        switch (SubscriptionPollResponseType.valueOf((short)responseType)) {
            case FILE_INIT: {
                this.responses[index] = this.generateSubscriptionPollResponseWithPieceOrSealPayload(0L);
                break;
            }
            case FILE_PIECE: {
                this.responses[index] = this.generateSubscriptionPollResponseWithPieceOrSealPayload(((FilePiecePayload)payload).getNextWritingOffset());
                break;
            }
            case FILE_SEAL: {
                return;
            }
            default: {
                LOGGER.warn("unexpected message type: {}", (Object)responseType);
            }
        }
    }

    public void prefetchRemainingResponses() throws IOException {
        for (int currentIndex = this.currentResponseIndex; currentIndex < this.responses.length - 1; ++currentIndex) {
            if (!Objects.isNull(this.responses[currentIndex + 1])) continue;
            this.prefetchResponse(currentIndex + 1);
            return;
        }
    }

    public void fetchNextResponse() throws IOException {
        if (this.currentResponseIndex >= this.responses.length - 1) {
            LOGGER.warn("No more responses when fetching next response for {}, do nothing.", (Object)this);
            return;
        }
        if (Objects.isNull(this.responses[this.currentResponseIndex + 1])) {
            this.prefetchRemainingResponses();
        }
        ++this.currentResponseIndex;
    }

    public void trySerializeRemainingResponses() {
        for (int currentIndex = this.currentResponseIndex; !(currentIndex >= this.responses.length - 1 || Objects.nonNull(this.responses[currentIndex + 1]) && this.trySerializeResponse(currentIndex + 1)); ++currentIndex) {
        }
    }

    public boolean trySerializeCurrentResponse() {
        return this.trySerializeResponse(this.currentResponseIndex);
    }

    private boolean trySerializeResponse(int index) {
        if (index >= this.responses.length) {
            return false;
        }
        if (Objects.isNull(this.responses[index])) {
            return false;
        }
        if (Objects.nonNull(this.byteBuffers[index])) {
            return false;
        }
        Optional<ByteBuffer> optionalByteBuffer = SubscriptionEventBinaryCache.getInstance().trySerialize(this.responses[index]);
        if (optionalByteBuffer.isPresent()) {
            this.byteBuffers[index] = optionalByteBuffer.get();
            return true;
        }
        return false;
    }

    public ByteBuffer getCurrentResponseByteBuffer() throws IOException {
        if (Objects.nonNull(this.byteBuffers[this.currentResponseIndex])) {
            return this.byteBuffers[this.currentResponseIndex];
        }
        this.byteBuffers[this.currentResponseIndex] = SubscriptionEventBinaryCache.getInstance().serialize(this.getCurrentResponse());
        return this.byteBuffers[this.currentResponseIndex];
    }

    public void resetResponseByteBuffer(boolean resetAll) {
        if (resetAll) {
            SubscriptionEventBinaryCache.getInstance().invalidateAll(Arrays.stream(this.responses).filter(Objects::nonNull).collect(Collectors.toList()));
            Arrays.fill(this.byteBuffers, null);
        } else {
            if (Objects.nonNull(this.responses[this.currentResponseIndex])) {
                SubscriptionEventBinaryCache.getInstance().invalidate(this.responses[this.currentResponseIndex]);
            }
            this.byteBuffers[this.currentResponseIndex] = null;
        }
    }

    public int getCurrentResponseSize() throws IOException {
        ByteBuffer byteBuffer = this.getCurrentResponseByteBuffer();
        return byteBuffer.limit() - byteBuffer.position();
    }

    private @NonNull SubscriptionPollResponse generateSubscriptionPollResponseWithPieceOrSealPayload(long writingOffset) throws IOException {
        File tsFile = this.pipeEvents.getTsFile();
        long readFileBufferSize = SubscriptionConfig.getInstance().getSubscriptionReadFileBufferSize();
        byte[] readBuffer = new byte[(int)readFileBufferSize];
        try (RandomAccessFile reader = new RandomAccessFile(tsFile, "r");){
            reader.seek(writingOffset);
            int readLength = reader.read(readBuffer);
            if (readLength != -1) {
                byte[] filePiece = (long)readLength == readFileBufferSize ? readBuffer : Arrays.copyOfRange(readBuffer, 0, readLength);
                SubscriptionPollResponse subscriptionPollResponse = new SubscriptionPollResponse(SubscriptionPollResponseType.FILE_PIECE.getType(), (SubscriptionPollPayload)new FilePiecePayload(tsFile.getName(), writingOffset + (long)readLength, filePiece), this.commitContext);
                return subscriptionPollResponse;
            }
            SubscriptionPollResponse subscriptionPollResponse = new SubscriptionPollResponse(SubscriptionPollResponseType.FILE_SEAL.getType(), (SubscriptionPollPayload)new FileSealPayload(tsFile.getName(), tsFile.length()), this.commitContext);
            return subscriptionPollResponse;
        }
    }

    public String getFileName() {
        return this.pipeEvents.getTsFile().getName();
    }

    public int getPipeEventCount() {
        return this.pipeEvents.getPipeEventCount();
    }

    public String toString() {
        return "SubscriptionEvent{responses=" + Arrays.toString(this.responses) + ", responses' byte buffer size=" + Arrays.stream(this.byteBuffers).map(byteBuffer -> Objects.isNull(byteBuffer) ? "<unknown>" : Integer.valueOf(byteBuffer.limit() - byteBuffer.position())).collect(Collectors.toList()) + ", currentResponseIndex=" + this.currentResponseIndex + ", lastPolledConsumerId=" + this.lastPolledConsumerId + ", lastPolledTimestamp=" + this.lastPolledTimestamp + ", committedTimestamp=" + this.committedTimestamp + ", pipeEvents=" + this.pipeEvents + "}";
    }
}

