/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.schedule;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.storageengine.dataregion.compaction.constant.CompactionTaskType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.SettleCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.DeviceInfo;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.file.metadata.IDeviceID;

public class CompactionScheduleContext {
    private int submitSeqInnerSpaceCompactionTaskNum = 0;
    private int submitUnseqInnerSpaceCompactionTaskNum = 0;
    private int submitCrossSpaceCompactionTaskNum = 0;
    private int submitInsertionCrossSpaceCompactionTaskNum = 0;
    private int submitSettleCompactionTaskNum = 0;
    private int fullyDirtyFileNum = 0;
    private int partiallyDirtyFileNum = 0;
    private final Map<TsFileResource, Map<IDeviceID, DeviceInfo>> partitionFileDeviceInfoCache = new HashMap<TsFileResource, Map<IDeviceID, DeviceInfo>>();

    public void addResourceDeviceTimeIndex(TsFileResource tsFileResource, Map<IDeviceID, DeviceInfo> deviceInfoMap) {
        this.partitionFileDeviceInfoCache.put(tsFileResource, deviceInfoMap);
    }

    public Map<IDeviceID, DeviceInfo> getResourceDeviceInfo(TsFileResource resource) {
        return this.partitionFileDeviceInfoCache.get(resource);
    }

    public void clearTimePartitionDeviceInfoCache() {
        this.partitionFileDeviceInfoCache.clear();
    }

    public void incrementSubmitTaskNum(CompactionTaskType taskType, int num) {
        switch (taskType) {
            case INNER_SEQ: {
                this.submitSeqInnerSpaceCompactionTaskNum += num;
                break;
            }
            case INNER_UNSEQ: {
                this.submitUnseqInnerSpaceCompactionTaskNum += num;
                break;
            }
            case CROSS: {
                this.submitCrossSpaceCompactionTaskNum += num;
                break;
            }
            case INSERTION: {
                this.submitInsertionCrossSpaceCompactionTaskNum += num;
                break;
            }
            case SETTLE: {
                this.submitSettleCompactionTaskNum += num;
                break;
            }
        }
    }

    public void updateTTLInfo(AbstractCompactionTask task) {
        switch (task.getCompactionTaskType()) {
            case INNER_SEQ: {
                ++this.submitSeqInnerSpaceCompactionTaskNum;
                this.partiallyDirtyFileNum += task.getProcessedFileNum();
                break;
            }
            case INNER_UNSEQ: {
                ++this.submitUnseqInnerSpaceCompactionTaskNum;
                this.partiallyDirtyFileNum += task.getProcessedFileNum();
                break;
            }
            case SETTLE: {
                ++this.submitSettleCompactionTaskNum;
                this.partiallyDirtyFileNum += ((SettleCompactionTask)task).getPartiallyDirtyFiles().size();
                this.fullyDirtyFileNum += ((SettleCompactionTask)task).getFullyDirtyFiles().size();
                break;
            }
        }
    }

    public int getSubmitCrossSpaceCompactionTaskNum() {
        return this.submitCrossSpaceCompactionTaskNum;
    }

    public int getSubmitInsertionCrossSpaceCompactionTaskNum() {
        return this.submitInsertionCrossSpaceCompactionTaskNum;
    }

    public int getSubmitSeqInnerSpaceCompactionTaskNum() {
        return this.submitSeqInnerSpaceCompactionTaskNum;
    }

    public int getSubmitUnseqInnerSpaceCompactionTaskNum() {
        return this.submitUnseqInnerSpaceCompactionTaskNum;
    }

    public int getSubmitSettleCompactionTaskNum() {
        return this.submitSettleCompactionTaskNum;
    }

    public boolean hasSubmitTask() {
        return this.submitCrossSpaceCompactionTaskNum + this.submitInsertionCrossSpaceCompactionTaskNum + this.submitSeqInnerSpaceCompactionTaskNum + this.submitUnseqInnerSpaceCompactionTaskNum + this.submitSettleCompactionTaskNum > 0;
    }

    public int getFullyDirtyFileNum() {
        return this.fullyDirtyFileNum;
    }

    public int getPartiallyDirtyFileNum() {
        return this.partiallyDirtyFileNum;
    }
}

