/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.visitor;

import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ReconstructVisitor;

public class RemoveRootPrefixVisitor
extends ReconstructVisitor<Void> {
    @Override
    public Expression visitTimeSeriesOperand(TimeSeriesOperand timeSeriesOperand, Void context) {
        PartialPath rawPath = timeSeriesOperand.getPath();
        if (!rawPath.startsWith("root")) {
            return timeSeriesOperand;
        }
        String[] rawPartialNodes = rawPath.getNodes();
        int newPartialNodesLength = rawPartialNodes.length - 1;
        String[] newPartialNodes = new String[newPartialNodesLength];
        System.arraycopy(rawPartialNodes, 1, newPartialNodes, 0, newPartialNodesLength);
        return new TimeSeriesOperand(new PartialPath(newPartialNodes));
    }
}

