/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.transform.statement;

import org.apache.iotdb.db.pipe.receiver.transform.converter.ArrayConverter;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.tsfile.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConvertedInsertTabletStatement
extends InsertTabletStatement {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConvertedInsertTabletStatement.class);

    public PipeConvertedInsertTabletStatement(InsertTabletStatement insertTabletStatement) {
        this.isDebug = insertTabletStatement.isDebug();
        insertTabletStatement.removeAllFailedMeasurementMarks();
        this.devicePath = insertTabletStatement.getDevicePath();
        this.isAligned = insertTabletStatement.isAligned();
        this.measurementSchemas = insertTabletStatement.getMeasurementSchemas();
        this.measurements = insertTabletStatement.getMeasurements();
        this.dataTypes = insertTabletStatement.getDataTypes();
        this.times = insertTabletStatement.getTimes();
        this.bitMaps = insertTabletStatement.getBitMaps();
        this.columns = insertTabletStatement.getColumns();
        this.rowCount = insertTabletStatement.getRowCount();
    }

    @Override
    protected boolean checkAndCastDataType(int columnIndex, TSDataType dataType) {
        LOGGER.info("Pipe: Inserting tablet to {}.{}. Casting type from {} to {}.", new Object[]{this.devicePath, this.measurements[columnIndex], this.dataTypes[columnIndex], dataType});
        this.columns[columnIndex] = ArrayConverter.convert(this.dataTypes[columnIndex], dataType, this.columns[columnIndex]);
        this.dataTypes[columnIndex] = dataType;
        return true;
    }
}

