/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile.container.scan;

import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.container.TsFileInsertionDataContainer;
import org.apache.iotdb.db.pipe.event.common.tsfile.container.scan.AlignedSinglePageWholeChunkReader;
import org.apache.iotdb.db.pipe.event.common.tsfile.container.scan.SinglePageWholeChunkReader;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryWeightUtil;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.MetaMarker;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.IChunkReader;
import org.apache.tsfile.read.reader.chunk.AlignedChunkReader;
import org.apache.tsfile.read.reader.chunk.ChunkReader;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.DateUtils;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class TsFileInsertionScanDataContainer
extends TsFileInsertionDataContainer {
    private static final LocalDate EMPTY_DATE = LocalDate.of(1000, 1, 1);
    private final long startTime;
    private final long endTime;
    private final Filter filter;
    private IChunkReader chunkReader;
    private BatchData data;
    private boolean currentIsMultiPage;
    private String currentDevice;
    private boolean currentIsAligned;
    private final List<MeasurementSchema> currentMeasurements = new ArrayList<MeasurementSchema>();
    private final List<Chunk> timeChunkList = new ArrayList<Chunk>();
    private final List<Boolean> isMultiPageList = new ArrayList<Boolean>();
    private final Map<String, Integer> measurementIndexMap = new HashMap<String, Integer>();
    private int lastIndex = -1;
    private ChunkHeader firstChunkHeader4NextSequentialValueChunks;
    private byte lastMarker = (byte)-128;

    public TsFileInsertionScanDataContainer(File tsFile, PipePattern pattern, long startTime, long endTime, PipeTaskMeta pipeTaskMeta, EnrichedEvent sourceEvent) throws IOException {
        super(pattern, startTime, endTime, pipeTaskMeta, sourceEvent);
        this.startTime = startTime;
        this.endTime = endTime;
        this.filter = Objects.nonNull(this.timeFilterExpression) ? this.timeFilterExpression.getFilter() : null;
        try {
            this.tsFileSequenceReader = new TsFileSequenceReader(tsFile.getAbsolutePath(), false, false);
            this.tsFileSequenceReader.position((long)"TsFile".getBytes().length + 1L);
            this.prepareData();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    @Override
    public Iterable<TabletInsertionEvent> toTabletInsertionEvents() {
        return () -> new Iterator<TabletInsertionEvent>(){

            @Override
            public boolean hasNext() {
                return Objects.nonNull(TsFileInsertionScanDataContainer.this.chunkReader);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TabletInsertionEvent next() {
                if (!this.hasNext()) {
                    TsFileInsertionScanDataContainer.this.close();
                    throw new NoSuchElementException();
                }
                Tablet tablet = TsFileInsertionScanDataContainer.this.getNextTablet();
                boolean hasNext = this.hasNext();
                try {
                    PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent = new PipeRawTabletInsertionEvent(tablet, TsFileInsertionScanDataContainer.this.currentIsAligned, TsFileInsertionScanDataContainer.this.sourceEvent != null ? TsFileInsertionScanDataContainer.this.sourceEvent.getPipeName() : null, TsFileInsertionScanDataContainer.this.sourceEvent != null ? TsFileInsertionScanDataContainer.this.sourceEvent.getCreationTime() : 0L, TsFileInsertionScanDataContainer.this.pipeTaskMeta, TsFileInsertionScanDataContainer.this.sourceEvent, !hasNext);
                    return pipeRawTabletInsertionEvent;
                }
                finally {
                    if (!hasNext) {
                        TsFileInsertionScanDataContainer.this.close();
                    }
                }
            }
        };
    }

    public Iterable<Pair<Tablet, Boolean>> toTabletWithIsAligneds() {
        return () -> new Iterator<Pair<Tablet, Boolean>>(){

            @Override
            public boolean hasNext() {
                return Objects.nonNull(TsFileInsertionScanDataContainer.this.chunkReader);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Pair<Tablet, Boolean> next() {
                if (!this.hasNext()) {
                    TsFileInsertionScanDataContainer.this.close();
                    throw new NoSuchElementException();
                }
                Tablet tablet = TsFileInsertionScanDataContainer.this.getNextTablet();
                boolean hasNext = this.hasNext();
                try {
                    Pair pair = new Pair((Object)tablet, (Object)TsFileInsertionScanDataContainer.this.currentIsAligned);
                    return pair;
                }
                finally {
                    if (!hasNext) {
                        TsFileInsertionScanDataContainer.this.close();
                    }
                }
            }
        };
    }

    private Tablet getNextTablet() {
        try {
            Tablet tablet = null;
            if (!this.data.hasCurrent()) {
                tablet = new Tablet(this.currentDevice, this.currentMeasurements, 1);
                tablet.initBitMaps();
                PipeDataNodeResourceManager.memory().forceResize(this.allocatedMemoryBlockForTablet, 0L);
                return tablet;
            }
            boolean isFirstRow = true;
            while (this.data.hasCurrent()) {
                if (this.currentIsMultiPage || this.data.currentTime() >= this.startTime && this.data.currentTime() <= this.endTime) {
                    if (isFirstRow) {
                        Pair<Integer, Integer> rowCountAndMemorySize = PipeMemoryWeightUtil.calculateTabletRowCountAndMemory(this.data);
                        tablet = new Tablet(this.currentDevice, this.currentMeasurements, ((Integer)rowCountAndMemorySize.getLeft()).intValue());
                        tablet.initBitMaps();
                        PipeDataNodeResourceManager.memory().forceResize(this.allocatedMemoryBlockForTablet, ((Integer)rowCountAndMemorySize.getRight()).intValue());
                        isFirstRow = false;
                    }
                    int rowIndex = tablet.rowSize++;
                    tablet.addTimestamp(rowIndex, this.data.currentTime());
                    this.putValueToColumns(this.data, tablet, rowIndex);
                }
                this.data.next();
                while (!this.data.hasCurrent() && this.chunkReader.hasNextSatisfiedPage()) {
                    this.data = this.chunkReader.nextPageData();
                }
                if (tablet == null || tablet.rowSize != tablet.getMaxRowNumber()) continue;
            }
            if (tablet == null) {
                tablet = new Tablet(this.currentDevice, this.currentMeasurements, 1);
                tablet.initBitMaps();
                PipeDataNodeResourceManager.memory().forceResize(this.allocatedMemoryBlockForTablet, 0L);
            }
            if (!this.data.hasCurrent()) {
                this.prepareData();
            }
            return tablet;
        }
        catch (Exception e) {
            this.close();
            throw new PipeException("Failed to get next tablet insertion event.", (Throwable)e);
        }
    }

    private void prepareData() throws IOException {
        while (true) {
            this.moveToNextChunkReader();
            if (Objects.nonNull(this.chunkReader) && !this.chunkReader.hasNextSatisfiedPage()) continue;
            if (Objects.isNull(this.chunkReader)) {
                this.close();
                break;
            }
            do {
                this.data = this.chunkReader.nextPageData();
            } while (!this.data.hasCurrent() && this.chunkReader.hasNextSatisfiedPage());
            if (this.data.hasCurrent()) break;
        }
    }

    private void putValueToColumns(BatchData data, Tablet tablet, int rowIndex) {
        Object[] columns = tablet.values;
        if (data.getDataType() == TSDataType.VECTOR) {
            block18: for (int i = 0; i < columns.length; ++i) {
                TsPrimitiveType primitiveType = data.getVector()[i];
                if (Objects.isNull(primitiveType)) {
                    tablet.bitMaps[i].mark(rowIndex);
                    TSDataType type = ((MeasurementSchema)tablet.getSchemas().get(i)).getType();
                    if (type == TSDataType.TEXT || type == TSDataType.BLOB || type == TSDataType.STRING) {
                        ((Binary[])columns[i])[rowIndex] = Binary.EMPTY_VALUE;
                    }
                    if (type != TSDataType.DATE) continue;
                    ((LocalDate[])columns[i])[rowIndex] = EMPTY_DATE;
                    continue;
                }
                switch (((MeasurementSchema)tablet.getSchemas().get(i)).getType()) {
                    case BOOLEAN: {
                        ((boolean[])columns[i])[rowIndex] = primitiveType.getBoolean();
                        continue block18;
                    }
                    case INT32: {
                        ((int[])columns[i])[rowIndex] = primitiveType.getInt();
                        continue block18;
                    }
                    case DATE: {
                        ((LocalDate[])columns[i])[rowIndex] = DateUtils.parseIntToLocalDate((int)primitiveType.getInt());
                        continue block18;
                    }
                    case INT64: 
                    case TIMESTAMP: {
                        ((long[])columns[i])[rowIndex] = primitiveType.getLong();
                        continue block18;
                    }
                    case FLOAT: {
                        ((float[])columns[i])[rowIndex] = primitiveType.getFloat();
                        continue block18;
                    }
                    case DOUBLE: {
                        ((double[])columns[i])[rowIndex] = primitiveType.getDouble();
                        continue block18;
                    }
                    case TEXT: 
                    case BLOB: 
                    case STRING: {
                        ((Binary[])columns[i])[rowIndex] = primitiveType.getBinary();
                        continue block18;
                    }
                    default: {
                        throw new UnSupportedDataTypeException("UnSupported" + primitiveType.getDataType());
                    }
                }
            }
        } else {
            switch (((MeasurementSchema)tablet.getSchemas().get(0)).getType()) {
                case BOOLEAN: {
                    ((boolean[])columns[0])[rowIndex] = data.getBoolean();
                    break;
                }
                case INT32: {
                    ((int[])columns[0])[rowIndex] = data.getInt();
                    break;
                }
                case DATE: {
                    ((LocalDate[])columns[0])[rowIndex] = DateUtils.parseIntToLocalDate((int)data.getInt());
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    ((long[])columns[0])[rowIndex] = data.getLong();
                    break;
                }
                case FLOAT: {
                    ((float[])columns[0])[rowIndex] = data.getFloat();
                    break;
                }
                case DOUBLE: {
                    ((double[])columns[0])[rowIndex] = data.getDouble();
                    break;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    ((Binary[])columns[0])[rowIndex] = data.getBinary();
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException("UnSupported" + data.getDataType());
                }
            }
        }
    }

    private void moveToNextChunkReader() throws IOException, IllegalStateException {
        byte marker;
        ArrayList<Chunk> valueChunkList = new ArrayList<Chunk>();
        this.currentMeasurements.clear();
        if (this.lastMarker == 2) {
            this.chunkReader = null;
            return;
        }
        block6: while ((marker = this.lastMarker != -128 ? this.lastMarker : this.tsFileSequenceReader.readMarker()) != 2) {
            this.lastMarker = (byte)-128;
            switch (marker) {
                case -127: 
                case -123: 
                case 1: 
                case 5: {
                    this.currentIsMultiPage = marker == 1;
                    ChunkHeader chunkHeader = this.tsFileSequenceReader.readChunkHeader(marker);
                    if (Objects.isNull(this.currentDevice)) {
                        this.tsFileSequenceReader.position(this.tsFileSequenceReader.position() + (long)chunkHeader.getDataSize());
                        continue block6;
                    }
                    if ((chunkHeader.getChunkType() & 0xFFFFFF80) == -128) {
                        this.timeChunkList.add(new Chunk(chunkHeader, this.tsFileSequenceReader.readChunk(-1L, chunkHeader.getDataSize())));
                        this.isMultiPageList.add(marker == -127);
                        continue block6;
                    }
                    if (!this.pattern.matchesMeasurement(this.currentDevice, chunkHeader.getMeasurementID())) {
                        this.tsFileSequenceReader.position(this.tsFileSequenceReader.position() + (long)chunkHeader.getDataSize());
                        continue block6;
                    }
                    this.chunkReader = this.currentIsMultiPage ? new ChunkReader(new Chunk(chunkHeader, this.tsFileSequenceReader.readChunk(-1L, chunkHeader.getDataSize())), this.filter) : new SinglePageWholeChunkReader(new Chunk(chunkHeader, this.tsFileSequenceReader.readChunk(-1L, chunkHeader.getDataSize())));
                    this.currentIsAligned = false;
                    this.currentMeasurements.add(new MeasurementSchema(chunkHeader.getMeasurementID(), chunkHeader.getDataType()));
                    return;
                }
                case 65: 
                case 69: {
                    ChunkHeader chunkHeader;
                    if (Objects.isNull(this.firstChunkHeader4NextSequentialValueChunks)) {
                        chunkHeader = this.tsFileSequenceReader.readChunkHeader(marker);
                        if (Objects.isNull(this.currentDevice) || !this.pattern.matchesMeasurement(this.currentDevice, chunkHeader.getMeasurementID())) {
                            this.tsFileSequenceReader.position(this.tsFileSequenceReader.position() + (long)chunkHeader.getDataSize());
                            continue block6;
                        }
                        int valueIndex = this.measurementIndexMap.compute(chunkHeader.getMeasurementID(), (measurement, index) -> Objects.nonNull(index) ? index + 1 : 0);
                        if (chunkHeader.getDataSize() == 0) continue block6;
                        boolean needReturn = false;
                        if (this.lastIndex >= 0 && valueIndex != this.lastIndex) {
                            needReturn = this.recordAlignedChunk(valueChunkList, marker);
                        }
                        this.lastIndex = valueIndex;
                        if (needReturn) {
                            this.firstChunkHeader4NextSequentialValueChunks = chunkHeader;
                            return;
                        }
                    } else {
                        chunkHeader = this.firstChunkHeader4NextSequentialValueChunks;
                        this.firstChunkHeader4NextSequentialValueChunks = null;
                    }
                    valueChunkList.add(new Chunk(chunkHeader, this.tsFileSequenceReader.readChunk(-1L, chunkHeader.getDataSize())));
                    this.currentMeasurements.add(new MeasurementSchema(chunkHeader.getMeasurementID(), chunkHeader.getDataType()));
                    continue block6;
                }
                case 0: {
                    if (this.recordAlignedChunk(valueChunkList, marker)) {
                        return;
                    }
                    String deviceID = ((PlainDeviceID)this.tsFileSequenceReader.readChunkGroupHeader().getDeviceID()).toStringID();
                    this.lastIndex = -1;
                    this.timeChunkList.clear();
                    this.isMultiPageList.clear();
                    this.measurementIndexMap.clear();
                    this.currentDevice = this.pattern.mayOverlapWithDevice(deviceID) ? deviceID : null;
                    continue block6;
                }
                case 4: {
                    this.tsFileSequenceReader.readPlanIndex();
                    continue block6;
                }
            }
            MetaMarker.handleUnexpectedMarker((byte)marker);
        }
        this.lastMarker = marker;
        if (!this.recordAlignedChunk(valueChunkList, marker)) {
            this.chunkReader = null;
        }
    }

    private boolean recordAlignedChunk(List<Chunk> valueChunkList, byte marker) throws IOException {
        if (!valueChunkList.isEmpty()) {
            Chunk timeChunk = this.timeChunkList.get(this.lastIndex);
            timeChunk.getData().rewind();
            this.currentIsMultiPage = this.isMultiPageList.get(this.lastIndex);
            this.chunkReader = this.currentIsMultiPage ? new AlignedChunkReader(timeChunk, valueChunkList, this.filter) : new AlignedSinglePageWholeChunkReader(timeChunk, valueChunkList);
            this.currentIsAligned = true;
            this.lastMarker = marker;
            return true;
        }
        return false;
    }
}

