/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.TsFileInsertionPointCounter;
import org.apache.iotdb.db.pipe.event.common.tsfile.container.TsFileInsertionDataContainer;
import org.apache.iotdb.db.pipe.event.common.tsfile.container.TsFileInsertionDataContainerProvider;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.assigner.PipeTimePartitionProgressIndexKeeper;
import org.apache.iotdb.db.pipe.metric.PipeDataNodeRemainingEventAndTimeMetrics;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.tsfile.PipeTsFileResourceManager;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessor;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTsFileInsertionEvent
extends EnrichedEvent
implements TsFileInsertionEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTsFileInsertionEvent.class);
    private final TsFileResource resource;
    private File tsFile;
    private boolean isWithMod;
    private File modFile;
    private final boolean isLoaded;
    private final boolean isGeneratedByPipe;
    private final boolean isGeneratedByPipeConsensus;
    private final boolean isGeneratedByHistoricalExtractor;
    private final AtomicBoolean isClosed;
    private TsFileInsertionDataContainer dataContainer;
    private long flushPointCount = -1L;
    private volatile ProgressIndex overridingProgressIndex;

    public PipeTsFileInsertionEvent(TsFileResource resource, boolean isLoaded, boolean isGeneratedByPipe, boolean isGeneratedByHistoricalExtractor) {
        this(resource, true, isLoaded, isGeneratedByPipe, isGeneratedByHistoricalExtractor, null, 0L, null, null, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public PipeTsFileInsertionEvent(TsFileResource resource, boolean isWithMod, boolean isLoaded, boolean isGeneratedByPipe, boolean isGeneratedByHistoricalExtractor, String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, PipePattern pattern, long startTime, long endTime) {
        super(pipeName, creationTime, pipeTaskMeta, pattern, startTime, endTime);
        TsFileProcessor processor;
        this.resource = resource;
        this.tsFile = resource.getTsFile();
        ModificationFile modFile = resource.getModFile();
        this.isWithMod = isWithMod && modFile.exists();
        this.modFile = this.isWithMod ? new File(modFile.getFilePath()) : null;
        this.isLoaded = isLoaded;
        this.isGeneratedByPipe = isGeneratedByPipe;
        this.isGeneratedByPipeConsensus = resource.isGeneratedByPipeConsensus();
        this.isGeneratedByHistoricalExtractor = isGeneratedByHistoricalExtractor;
        this.isClosed = new AtomicBoolean(resource.isClosed());
        if (!this.isClosed.get() && (processor = resource.getProcessor()) != null) {
            processor.addCloseFileListener(o -> {
                AtomicBoolean atomicBoolean = this.isClosed;
                synchronized (atomicBoolean) {
                    this.isClosed.set(true);
                    this.isClosed.notifyAll();
                    this.flushPointCount = processor.getMemTableFlushPointCount();
                }
            });
        }
        this.isClosed.set(resource.isClosed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForTsFileClose() throws InterruptedException {
        if (!this.isClosed.get()) {
            this.isClosed.set(this.resource.isClosed());
            AtomicBoolean atomicBoolean = this.isClosed;
            synchronized (atomicBoolean) {
                while (!this.isClosed.get()) {
                    this.isClosed.wait(100L);
                    boolean isClosedNow = this.resource.isClosed();
                    if (!isClosedNow) continue;
                    this.isClosed.set(true);
                    this.isClosed.notifyAll();
                    TsFileProcessor processor = this.resource.getProcessor();
                    if (processor == null) break;
                    this.flushPointCount = processor.getMemTableFlushPointCount();
                    break;
                }
            }
        }
        return !this.resource.isEmpty();
    }

    public File getTsFile() {
        return this.tsFile;
    }

    public File getModFile() {
        return this.modFile;
    }

    public boolean isWithMod() {
        return this.isWithMod;
    }

    public void disableMod4NonTransferPipes(boolean isWithMod) {
        this.isWithMod = isWithMod && this.isWithMod;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public long getFileStartTime() {
        return this.resource.getFileStartTime();
    }

    public long getFlushPointCount() {
        return this.flushPointCount;
    }

    public long getTimePartitionId() {
        return this.resource.getTimePartition();
    }

    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        try {
            this.tsFile = PipeDataNodeResourceManager.tsfile().increaseFileReference(this.tsFile, true, this.resource);
            if (this.isWithMod) {
                this.modFile = PipeDataNodeResourceManager.tsfile().increaseFileReference(this.modFile, false, null);
            }
            if (Objects.nonNull(this.pipeName)) {
                PipeDataNodeRemainingEventAndTimeMetrics.getInstance().increaseTsFileEventCount(this.pipeName, this.creationTime);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Increase reference count for TsFile %s or modFile %s error. Holder Message: %s", this.tsFile, this.modFile, holderMessage), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        try {
            PipeDataNodeResourceManager.tsfile().decreaseFileReference(this.tsFile);
            if (this.isWithMod) {
                PipeDataNodeResourceManager.tsfile().decreaseFileReference(this.modFile);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Decrease reference count for TsFile %s error. Holder Message: %s", this.tsFile.getPath(), holderMessage), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (Objects.nonNull(this.pipeName)) {
                PipeDataNodeRemainingEventAndTimeMetrics.getInstance().decreaseTsFileEventCount(this.pipeName, this.creationTime);
            }
        }
    }

    public void bindProgressIndex(ProgressIndex overridingProgressIndex) {
        this.overridingProgressIndex = overridingProgressIndex;
    }

    public ProgressIndex getProgressIndex() {
        try {
            if (!this.waitForTsFileClose()) {
                LOGGER.warn("Skipping temporary TsFile {}'s progressIndex, will report MinimumProgressIndex", (Object)this.tsFile);
                return MinimumProgressIndex.INSTANCE;
            }
            if (Objects.nonNull(this.overridingProgressIndex)) {
                return this.overridingProgressIndex;
            }
            return this.resource.getMaxProgressIndexAfterClose();
        }
        catch (InterruptedException e) {
            LOGGER.warn(String.format("Interrupted when waiting for closing TsFile %s.", this.resource.getTsFilePath()));
            Thread.currentThread().interrupt();
            return MinimumProgressIndex.INSTANCE;
        }
    }

    protected void reportProgress() {
        super.reportProgress();
        this.eliminateProgressIndex();
    }

    public void eliminateProgressIndex() {
        if (Objects.isNull(this.overridingProgressIndex)) {
            PipeTimePartitionProgressIndexKeeper.getInstance().eliminateProgressIndex(this.resource.getDataRegionId(), this.resource.getTimePartition(), this.resource.getMaxProgressIndexAfterClose());
        }
    }

    public PipeTsFileInsertionEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, PipePattern pattern, long startTime, long endTime) {
        return new PipeTsFileInsertionEvent(this.resource, this.isWithMod, this.isLoaded, this.isGeneratedByPipe, this.isGeneratedByHistoricalExtractor, pipeName, creationTime, pipeTaskMeta, pattern, startTime, endTime);
    }

    public boolean isGeneratedByPipe() {
        return this.isGeneratedByPipe;
    }

    public boolean mayEventTimeOverlappedWithTimeRange() {
        return this.isClosed.get() ? this.startTime <= this.resource.getFileEndTime() && this.resource.getFileStartTime() <= this.endTime : this.resource.getFileStartTime() <= this.endTime;
    }

    public boolean mayEventPathsOverlappedWithPattern() {
        if (!this.resource.isClosed()) {
            return true;
        }
        try {
            Map<IDeviceID, Boolean> deviceIsAlignedMap = PipeDataNodeResourceManager.tsfile().getDeviceIsAlignedMapFromCache(PipeTsFileResourceManager.getHardlinkOrCopiedFileInPipeDir(this.resource.getTsFile()), false);
            Set<IDeviceID> deviceSet = Objects.nonNull(deviceIsAlignedMap) ? deviceIsAlignedMap.keySet() : this.resource.getDevices();
            return deviceSet.stream().anyMatch(deviceID -> this.pipePattern.mayOverlapWithDevice(((PlainDeviceID)deviceID).toStringID()));
        }
        catch (Exception e) {
            LOGGER.warn("Pipe {}: failed to get devices from TsFile {}, extract it anyway", new Object[]{this.pipeName, this.resource.getTsFilePath(), e});
            return true;
        }
    }

    public Iterable<TabletInsertionEvent> toTabletInsertionEvents() {
        try {
            if (!this.waitForTsFileClose()) {
                LOGGER.warn("Pipe skipping temporary TsFile's parsing which shouldn't be transferred: {}", (Object)this.tsFile);
                return Collections.emptyList();
            }
            return this.initDataContainer().toTabletInsertionEvents();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.close();
            String errorMsg = String.format("Interrupted when waiting for closing TsFile %s.", this.resource.getTsFilePath());
            LOGGER.warn(errorMsg, (Throwable)e);
            throw new PipeException(errorMsg);
        }
    }

    public boolean isGeneratedByPipeConsensus() {
        return this.isGeneratedByPipeConsensus;
    }

    public boolean isGeneratedByHistoricalExtractor() {
        return this.isGeneratedByHistoricalExtractor;
    }

    private TsFileInsertionDataContainer initDataContainer() {
        try {
            if (this.dataContainer == null) {
                this.dataContainer = new TsFileInsertionDataContainerProvider(this.tsFile, this.pipePattern, this.startTime, this.endTime, this.pipeTaskMeta, this).provide();
            }
            return this.dataContainer;
        }
        catch (IOException e) {
            this.close();
            String errorMsg = String.format("Read TsFile %s error.", this.resource.getTsFilePath());
            LOGGER.warn(errorMsg, (Throwable)e);
            throw new PipeException(errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(boolean skipReportOnCommit) throws IOException {
        long count = 0L;
        if (this.shouldParseTime()) {
            try {
                for (TabletInsertionEvent event : this.toTabletInsertionEvents()) {
                    PipeRawTabletInsertionEvent rawEvent = (PipeRawTabletInsertionEvent)event;
                    count += rawEvent.count();
                    if (!skipReportOnCommit) continue;
                    rawEvent.skipReportOnCommit();
                }
                long l = count;
                return l;
            }
            finally {
                this.close();
            }
        }
        try (TsFileInsertionPointCounter counter = new TsFileInsertionPointCounter(this.tsFile, this.pipePattern);){
            long l = counter.count();
            return l;
        }
    }

    public void close() {
        if (this.dataContainer != null) {
            this.dataContainer.close();
            this.dataContainer = null;
        }
    }

    public String toString() {
        return String.format("PipeTsFileInsertionEvent{resource=%s, tsFile=%s, isLoaded=%s, isGeneratedByPipe=%s, isClosed=%s, dataContainer=%s}", this.resource, this.tsFile, this.isLoaded, this.isGeneratedByPipe, this.isClosed.get(), this.dataContainer) + " - " + super.toString();
    }

    public String coreReportMessage() {
        return String.format("PipeTsFileInsertionEvent{resource=%s, tsFile=%s, isLoaded=%s, isGeneratedByPipe=%s, isClosed=%s}", this.resource, this.tsFile, this.isLoaded, this.isGeneratedByPipe, this.isClosed.get()) + " - " + super.coreReportMessage();
    }
}

