/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.client;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientPoolFactory;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.connector.client.IoTDBClientManager;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.connector.client.IoTDBDataNodeCacheLeaderClientManager;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferDataNodeHandshakeV1Req;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferDataNodeHandshakeV2Req;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDataNodeAsyncClientManager
extends IoTDBClientManager
implements IoTDBDataNodeCacheLeaderClientManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBDataNodeAsyncClientManager.class);
    private final Set<TEndPoint> endPointSet;
    private static final Map<String, Integer> RECEIVER_ATTRIBUTES_REF_COUNT = new ConcurrentHashMap<String, Integer>();
    private final String receiverAttributes;
    private static final Map<String, IClientManager<TEndPoint, AsyncPipeDataTransferServiceClient>> ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER = new ConcurrentHashMap<String, IClientManager<TEndPoint, AsyncPipeDataTransferServiceClient>>();
    private final IClientManager<TEndPoint, AsyncPipeDataTransferServiceClient> endPoint2Client;
    private final LoadBalancer loadBalancer;
    private final boolean shouldReceiverConvertOnTypeMismatch;
    private final String loadTsFileStrategy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoTDBDataNodeAsyncClientManager(List<TEndPoint> endPoints, boolean useLeaderCache, String loadBalanceStrategy, boolean shouldReceiverConvertOnTypeMismatch, String loadTsFileStrategy) {
        super(endPoints, useLeaderCache);
        this.endPointSet = new HashSet<TEndPoint>(endPoints);
        this.receiverAttributes = String.format("%s-%s", shouldReceiverConvertOnTypeMismatch, loadTsFileStrategy);
        Object object = IoTDBDataNodeAsyncClientManager.class;
        synchronized (IoTDBDataNodeAsyncClientManager.class) {
            if (!ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER.containsKey(this.receiverAttributes)) {
                ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER.putIfAbsent(this.receiverAttributes, (IClientManager<TEndPoint, AsyncPipeDataTransferServiceClient>)new IClientManager.Factory().createClientManager((IClientPoolFactory)new ClientPoolFactory.AsyncPipeDataTransferServiceClientPoolFactory()));
            }
            this.endPoint2Client = ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER.get(this.receiverAttributes);
            RECEIVER_ATTRIBUTES_REF_COUNT.compute(this.receiverAttributes, (attributes, refCount) -> refCount == null ? 1 : refCount + 1);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            switch (loadBalanceStrategy) {
                case "round-robin": {
                    this.loadBalancer = new RoundRobinLoadBalancer();
                    break;
                }
                case "random": {
                    this.loadBalancer = new RandomLoadBalancer();
                    break;
                }
                case "priority": {
                    this.loadBalancer = new PriorityLoadBalancer();
                    break;
                }
                default: {
                    LOGGER.warn("Unknown load balance strategy: {}, use round-robin strategy instead.", (Object)loadBalanceStrategy);
                    this.loadBalancer = new RoundRobinLoadBalancer();
                }
            }
            this.shouldReceiverConvertOnTypeMismatch = shouldReceiverConvertOnTypeMismatch;
            this.loadTsFileStrategy = loadTsFileStrategy;
            return;
        }
    }

    public AsyncPipeDataTransferServiceClient borrowClient() throws Exception {
        return this.loadBalancer.borrowClient();
    }

    public AsyncPipeDataTransferServiceClient borrowClient(String deviceId) throws Exception {
        if (!this.useLeaderCache || Objects.isNull(deviceId)) {
            return this.borrowClient();
        }
        return this.borrowClient(LEADER_CACHE_MANAGER.getLeaderEndPoint(deviceId));
    }

    public AsyncPipeDataTransferServiceClient borrowClient(TEndPoint endPoint) throws Exception {
        if (!this.useLeaderCache || Objects.isNull(endPoint)) {
            return this.borrowClient();
        }
        try {
            AsyncPipeDataTransferServiceClient client = (AsyncPipeDataTransferServiceClient)this.endPoint2Client.borrowClient((Object)endPoint);
            if (this.handshakeIfNecessary(endPoint, client)) {
                return client;
            }
        }
        catch (Exception e) {
            LOGGER.warn("failed to borrow client {}:{} for cached leader.", new Object[]{endPoint.getIp(), endPoint.getPort(), e});
        }
        return this.borrowClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handshakeIfNecessary(final TEndPoint targetNodeUrl, final AsyncPipeDataTransferServiceClient client) throws Exception {
        if (client.isHandshakeFinished()) {
            return true;
        }
        final AtomicBoolean isHandshakeFinished = new AtomicBoolean(false);
        final AtomicReference resp = new AtomicReference();
        final AtomicReference exception = new AtomicReference();
        AsyncMethodCallback<TPipeTransferResp> callback = new AsyncMethodCallback<TPipeTransferResp>(){

            public void onComplete(TPipeTransferResp response) {
                resp.set(response);
                if (response.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    LOGGER.warn("Handshake error with receiver {}:{}, code: {}, message: {}.", new Object[]{targetNodeUrl.getIp(), targetNodeUrl.getPort(), response.getStatus().getCode(), response.getStatus().getMessage()});
                    exception.set(new PipeConnectionException(String.format("Handshake error with receiver %s:%s, code: %d, message: %s.", targetNodeUrl.getIp(), targetNodeUrl.getPort(), response.getStatus().getCode(), response.getStatus().getMessage())));
                } else {
                    LOGGER.info("Handshake successfully with receiver {}:{}.", (Object)targetNodeUrl.getIp(), (Object)targetNodeUrl.getPort());
                    client.markHandshakeFinished();
                }
                isHandshakeFinished.set(true);
            }

            public void onError(Exception e) {
                LOGGER.warn("Handshake error with receiver {}:{}.", new Object[]{targetNodeUrl.getIp(), targetNodeUrl.getPort(), e});
                exception.set(e);
                isHandshakeFinished.set(true);
            }
        };
        try {
            client.setShouldReturnSelf(false);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("clusterID", IoTDBDescriptor.getInstance().getConfig().getClusterId());
            params.put("timestampPrecision", CommonDescriptor.getInstance().getConfig().getTimestampPrecision());
            params.put("convertOnTypeMismatch", Boolean.toString(this.shouldReceiverConvertOnTypeMismatch));
            params.put("loadTsFileStrategy", this.loadTsFileStrategy);
            client.setTimeoutDynamically(PipeConfig.getInstance().getPipeConnectorHandshakeTimeoutMs());
            client.pipeTransfer((TPipeTransferReq)PipeTransferDataNodeHandshakeV2Req.toTPipeTransferReq(params), (AsyncMethodCallback)callback);
            this.waitHandshakeFinished(isHandshakeFinished);
            if (resp.get() != null && ((TPipeTransferResp)resp.get()).getStatus().getCode() == TSStatusCode.PIPE_TYPE_ERROR.getStatusCode()) {
                LOGGER.info("Handshake error by PipeTransferHandshakeV2Req with receiver {}:{} retry to handshake by PipeTransferHandshakeV1Req.", (Object)targetNodeUrl.getIp(), (Object)targetNodeUrl.getPort());
                this.supportModsIfIsDataNodeReceiver = false;
                isHandshakeFinished.set(false);
                resp.set(null);
                exception.set(null);
                client.setTimeoutDynamically(PipeConfig.getInstance().getPipeConnectorHandshakeTimeoutMs());
                client.pipeTransfer((TPipeTransferReq)PipeTransferDataNodeHandshakeV1Req.toTPipeTransferReq(CommonDescriptor.getInstance().getConfig().getTimestampPrecision()), (AsyncMethodCallback)callback);
                this.waitHandshakeFinished(isHandshakeFinished);
            }
            if (exception.get() != null) {
                throw new PipeConnectionException("Failed to handshake.", (Throwable)exception.get());
            }
        }
        finally {
            client.setShouldReturnSelf(true);
            client.returnSelf();
        }
        return false;
    }

    private void waitHandshakeFinished(AtomicBoolean isHandshakeFinished) {
        try {
            while (!isHandshakeFinished.get()) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PipeException("Interrupted while waiting for handshake response.", (Throwable)e);
        }
    }

    public void updateLeaderCache(String deviceId, TEndPoint endPoint) {
        if (!this.useLeaderCache || deviceId == null || endPoint == null) {
            return;
        }
        if (!this.endPointSet.contains(endPoint)) {
            this.endPointList.add(endPoint);
            this.endPointSet.add(endPoint);
        }
        LEADER_CACHE_MANAGER.updateLeaderEndPoint(deviceId, endPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Class<IoTDBDataNodeAsyncClientManager> clazz = IoTDBDataNodeAsyncClientManager.class;
        synchronized (IoTDBDataNodeAsyncClientManager.class) {
            RECEIVER_ATTRIBUTES_REF_COUNT.computeIfPresent(this.receiverAttributes, (attributes, refCount) -> {
                if (refCount <= 1) {
                    IClientManager<TEndPoint, AsyncPipeDataTransferServiceClient> clientManager = ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER.remove(this.receiverAttributes);
                    if (clientManager != null) {
                        try {
                            clientManager.close();
                        }
                        catch (Exception e) {
                            LOGGER.warn("Failed to close client manager.", (Throwable)e);
                        }
                    }
                    return null;
                }
                return refCount - 1;
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private class RoundRobinLoadBalancer
    implements LoadBalancer {
        private RoundRobinLoadBalancer() {
        }

        @Override
        public AsyncPipeDataTransferServiceClient borrowClient() throws Exception {
            AsyncPipeDataTransferServiceClient client;
            TEndPoint targetNodeUrl;
            int clientSize = IoTDBDataNodeAsyncClientManager.this.endPointList.size();
            while (!IoTDBDataNodeAsyncClientManager.this.handshakeIfNecessary(targetNodeUrl = (TEndPoint)IoTDBDataNodeAsyncClientManager.this.endPointList.get((int)(IoTDBDataNodeAsyncClientManager.this.currentClientIndex++ % (long)clientSize)), client = (AsyncPipeDataTransferServiceClient)IoTDBDataNodeAsyncClientManager.this.endPoint2Client.borrowClient((Object)targetNodeUrl))) {
            }
            return client;
        }
    }

    private static interface LoadBalancer {
        public AsyncPipeDataTransferServiceClient borrowClient() throws Exception;
    }

    private class RandomLoadBalancer
    implements LoadBalancer {
        private RandomLoadBalancer() {
        }

        @Override
        public AsyncPipeDataTransferServiceClient borrowClient() throws Exception {
            AsyncPipeDataTransferServiceClient client;
            TEndPoint targetNodeUrl;
            int clientSize = IoTDBDataNodeAsyncClientManager.this.endPointList.size();
            while (!IoTDBDataNodeAsyncClientManager.this.handshakeIfNecessary(targetNodeUrl = (TEndPoint)IoTDBDataNodeAsyncClientManager.this.endPointList.get((int)(Math.random() * (double)clientSize)), client = (AsyncPipeDataTransferServiceClient)IoTDBDataNodeAsyncClientManager.this.endPoint2Client.borrowClient((Object)targetNodeUrl))) {
            }
            return client;
        }
    }

    private class PriorityLoadBalancer
    implements LoadBalancer {
        private PriorityLoadBalancer() {
        }

        @Override
        public AsyncPipeDataTransferServiceClient borrowClient() throws Exception {
            AsyncPipeDataTransferServiceClient client;
            block0: while (true) {
                TEndPoint targetNodeUrl;
                Iterator iterator = IoTDBDataNodeAsyncClientManager.this.endPointList.iterator();
                do {
                    if (!iterator.hasNext()) continue block0;
                } while (!IoTDBDataNodeAsyncClientManager.this.handshakeIfNecessary(targetNodeUrl = (TEndPoint)iterator.next(), client = (AsyncPipeDataTransferServiceClient)IoTDBDataNodeAsyncClientManager.this.endPoint2Client.borrowClient((Object)targetNodeUrl)));
                break;
            }
            return client;
        }
    }
}

