/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.utils.Pair;

public class ModificationUtils {
    private ModificationUtils() {
    }

    public static void modifyChunkMetaData(List<? extends IChunkMetadata> chunkMetaData, List<Modification> modifications) {
        for (IChunkMetadata iChunkMetadata : chunkMetaData) {
            for (Modification modification : modifications) {
                if (modification.getFileOffset() <= iChunkMetadata.getOffsetOfChunkHeader()) continue;
                ModificationUtils.doModifyChunkMetaData(modification, iChunkMetadata);
            }
        }
        chunkMetaData.removeIf(metaData -> {
            if (metaData.getDeleteIntervalList() != null) {
                for (TimeRange range : metaData.getDeleteIntervalList()) {
                    if (range.contains(metaData.getStartTime(), metaData.getEndTime())) {
                        return true;
                    }
                    if (!range.overlaps(new TimeRange(metaData.getStartTime(), metaData.getEndTime()))) continue;
                    metaData.setModified(true);
                }
            }
            return false;
        });
    }

    public static void modifyAlignedChunkMetaData(List<AlignedChunkMetadata> chunkMetaData, List<List<Modification>> modifications) {
        for (AlignedChunkMetadata metaData : chunkMetaData) {
            List valueChunkMetadataList = metaData.getValueChunkMetadataList();
            for (int i = 0; i < valueChunkMetadataList.size(); ++i) {
                IChunkMetadata v = (IChunkMetadata)valueChunkMetadataList.get(i);
                if (v == null) continue;
                List<Modification> modificationList = modifications.get(i);
                for (Modification modification : modificationList) {
                    if (modification.getFileOffset() <= v.getOffsetOfChunkHeader()) continue;
                    ModificationUtils.doModifyChunkMetaData(modification, v);
                }
            }
        }
        chunkMetaData.removeIf(alignedChunkMetadata -> {
            boolean removed = true;
            boolean modified = false;
            List valueChunkMetadataList = alignedChunkMetadata.getValueChunkMetadataList();
            for (int i = 0; i < valueChunkMetadataList.size(); ++i) {
                IChunkMetadata valueChunkMetadata = (IChunkMetadata)valueChunkMetadataList.get(i);
                if (valueChunkMetadata == null) continue;
                boolean currentRemoved = false;
                if (valueChunkMetadata.getDeleteIntervalList() != null) {
                    for (TimeRange range : valueChunkMetadata.getDeleteIntervalList()) {
                        if (range.contains(valueChunkMetadata.getStartTime(), valueChunkMetadata.getEndTime())) {
                            valueChunkMetadataList.set(i, null);
                            currentRemoved = true;
                            break;
                        }
                        if (!range.overlaps(new TimeRange(valueChunkMetadata.getStartTime(), valueChunkMetadata.getEndTime()))) continue;
                        valueChunkMetadata.setModified(true);
                        modified = true;
                    }
                }
                if (currentRemoved) continue;
                removed = false;
            }
            alignedChunkMetadata.setModified(modified);
            return removed;
        });
    }

    public static boolean isPointDeleted(long timestamp, List<TimeRange> deletionList, int[] deleteCursor) {
        if (deleteCursor.length != 1) {
            throw new IllegalArgumentException("deleteCursor should be an array whose size is 1");
        }
        while (deletionList != null && deleteCursor[0] < deletionList.size()) {
            if (deletionList.get(deleteCursor[0]).contains(timestamp)) {
                return true;
            }
            if (deletionList.get(deleteCursor[0]).getMax() < timestamp) {
                deleteCursor[0] = deleteCursor[0] + 1;
                continue;
            }
            return false;
        }
        return false;
    }

    public static boolean isPointDeletedWithoutOrderedRange(long timestamp, List<TimeRange> timeRangeList) {
        for (TimeRange range : timeRangeList) {
            if (!range.contains(timestamp)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPointDeleted(long timestamp, List<TimeRange> deletionList) {
        int[] deleteCursor = new int[]{0};
        return ModificationUtils.isPointDeleted(timestamp, deletionList, deleteCursor);
    }

    public static boolean isDeviceDeletedByMods(Collection<Modification> modifications, IDeviceID device, long startTime, long endTime) throws IllegalPathException {
        for (Modification modification : modifications) {
            PartialPath path = modification.getPath();
            if (!path.include(new PartialPath(device, "*")) || !((Deletion)modification).getTimeRange().contains(startTime, endTime)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTimeseriesDeletedByMods(Collection<Modification> modifications, IDeviceID device, String timeseriesId, long startTime, long endTime) throws IllegalPathException {
        for (Modification modification : modifications) {
            PartialPath path = modification.getPath();
            if (!path.include(new PartialPath(device, timeseriesId)) || !((Deletion)modification).getTimeRange().contains(startTime, endTime)) continue;
            return true;
        }
        return false;
    }

    private static void doModifyChunkMetaData(Modification modification, IChunkMetadata metaData) {
        if (modification instanceof Deletion) {
            Deletion deletion = (Deletion)modification;
            metaData.insertIntoSortedDeletions(deletion.getTimeRange());
        }
    }

    public static List<List<TimeRange>> constructDeletionList(AlignedPath partialPath, IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable, long timeLowerBound) {
        ArrayList<List<TimeRange>> deletionList = new ArrayList<List<TimeRange>>();
        for (String measurement : partialPath.getMeasurementList()) {
            ArrayList<TimeRange> columnDeletionList = new ArrayList<TimeRange>();
            columnDeletionList.add(new TimeRange(Long.MIN_VALUE, timeLowerBound));
            for (Modification modification : ModificationUtils.getModificationsForMemtable(memTable, modsToMemtable)) {
                if (!(modification instanceof Deletion)) continue;
                Deletion deletion = (Deletion)modification;
                PartialPath fullPath = partialPath.concatNode(measurement);
                if (!deletion.getPath().matchFullPath(fullPath) || deletion.getEndTime() <= timeLowerBound) continue;
                long lowerBound = Math.max(deletion.getStartTime(), timeLowerBound);
                columnDeletionList.add(new TimeRange(lowerBound, deletion.getEndTime()));
            }
            deletionList.add(TimeRange.sortAndMerge(columnDeletionList));
        }
        return deletionList;
    }

    public static List<TimeRange> constructDeletionList(MeasurementPath partialPath, IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable, long timeLowerBound) {
        ArrayList<TimeRange> deletionList = new ArrayList<TimeRange>();
        deletionList.add(new TimeRange(Long.MIN_VALUE, timeLowerBound));
        for (Modification modification : ModificationUtils.getModificationsForMemtable(memTable, modsToMemtable)) {
            Deletion deletion;
            if (!(modification instanceof Deletion) || !(deletion = (Deletion)modification).getPath().matchFullPath((PartialPath)partialPath) || deletion.getEndTime() <= timeLowerBound) continue;
            long lowerBound = Math.max(deletion.getStartTime(), timeLowerBound);
            deletionList.add(new TimeRange(lowerBound, deletion.getEndTime()));
        }
        return TimeRange.sortAndMerge(deletionList);
    }

    private static List<Modification> getModificationsForMemtable(IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable) {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        boolean foundMemtable = false;
        for (Pair<Modification, IMemTable> entry : modsToMemtable) {
            if (!foundMemtable && !((IMemTable)entry.right).equals(memTable)) continue;
            modifications.add((Modification)entry.left);
            foundMemtable = true;
        }
        return modifications;
    }
}

