/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.reader.series;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.reader.IChunkReader;
import org.apache.iotdb.tsfile.read.reader.chunk.AlignedChunkReader;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;

public class FileSeriesReaderByTimestamp {
    protected IChunkLoader chunkLoader;
    protected List<IChunkMetadata> chunkMetadataList;
    private int currentChunkIndex = 0;
    private IChunkReader chunkReader;
    private long currentTimestamp;
    private BatchData data = null;

    public FileSeriesReaderByTimestamp(IChunkLoader chunkLoader, List<IChunkMetadata> chunkMetadataList) {
        this.chunkLoader = chunkLoader;
        this.chunkMetadataList = chunkMetadataList;
        this.currentTimestamp = Long.MIN_VALUE;
    }

    public TSDataType getDataType() {
        return this.chunkMetadataList.get(0).getDataType();
    }

    public Object getValueInTimestamp(long timestamp) throws IOException {
        this.currentTimestamp = timestamp;
        if (this.chunkReader == null) {
            if (!this.constructNextSatisfiedChunkReader()) {
                return null;
            }
            if (this.chunkReader.hasNextSatisfiedPage()) {
                this.data = this.chunkReader.nextPageData();
            } else {
                return null;
            }
        }
        while (this.data != null) {
            while (this.data.hasCurrent() && this.data.currentTime() < timestamp) {
                this.data.next();
            }
            if (this.data.hasCurrent()) {
                if (this.data.currentTime() == timestamp) {
                    Object value = this.data.currentValue();
                    this.data.next();
                    return value;
                }
                return null;
            }
            if (this.chunkReader.hasNextSatisfiedPage()) {
                this.data = this.chunkReader.nextPageData();
                continue;
            }
            if (this.constructNextSatisfiedChunkReader()) continue;
            return null;
        }
        return null;
    }

    public boolean hasNext() throws IOException {
        if (this.chunkReader != null) {
            if (this.data != null && this.data.hasCurrent()) {
                return true;
            }
            while (this.chunkReader.hasNextSatisfiedPage()) {
                this.data = this.chunkReader.nextPageData();
                if (this.data == null || !this.data.hasCurrent()) continue;
                return true;
            }
        }
        while (this.constructNextSatisfiedChunkReader()) {
            while (this.chunkReader.hasNextSatisfiedPage()) {
                this.data = this.chunkReader.nextPageData();
                if (this.data == null || !this.data.hasCurrent()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean constructNextSatisfiedChunkReader() throws IOException {
        while (this.currentChunkIndex < this.chunkMetadataList.size()) {
            IChunkMetadata chunkMetaData;
            if (!this.chunkSatisfied(chunkMetaData = this.chunkMetadataList.get(this.currentChunkIndex++))) continue;
            this.initChunkReader(chunkMetaData);
            return true;
        }
        return false;
    }

    private void initChunkReader(IChunkMetadata chunkMetaData) throws IOException {
        if (chunkMetaData instanceof ChunkMetadata) {
            Chunk chunk = this.chunkLoader.loadChunk((ChunkMetadata)chunkMetaData);
            this.chunkReader = new ChunkReader(chunk, this.currentTimestamp);
        } else {
            AlignedChunkMetadata alignedChunkMetadata = (AlignedChunkMetadata)chunkMetaData;
            Chunk timeChunk = this.chunkLoader.loadChunk((ChunkMetadata)alignedChunkMetadata.getTimeChunkMetadata());
            ArrayList<Chunk> valueChunkList = new ArrayList<Chunk>();
            for (IChunkMetadata metadata : alignedChunkMetadata.getValueChunkMetadataList()) {
                valueChunkList.add(this.chunkLoader.loadChunk((ChunkMetadata)metadata));
            }
            this.chunkReader = new AlignedChunkReader(timeChunk, valueChunkList, this.currentTimestamp);
        }
    }

    private boolean chunkSatisfied(IChunkMetadata chunkMetaData) {
        return chunkMetaData.getEndTime() >= this.currentTimestamp;
    }
}

