/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.fileSystem.fileOutputFactory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.fileSystem.fileOutputFactory.FileOutputFactory;
import org.apache.iotdb.tsfile.write.writer.TsFileOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSFileOutputFactory
implements FileOutputFactory {
    private static final Logger logger = LoggerFactory.getLogger(OSFileOutputFactory.class);
    private Constructor constructor;

    public OSFileOutputFactory() {
        try {
            Class<?> clazz = Class.forName(TSFileDescriptor.getInstance().getConfig().getObjectStorageTsFileOutput());
            this.constructor = clazz.getConstructor(String.class, Boolean.TYPE);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            logger.error("Failed to get OSInput in object storage. Please check your dependency of object storage module.", e);
        }
    }

    @Override
    public TsFileOutput getTsFileOutput(String filePath, boolean append) {
        try {
            return (TsFileOutput)this.constructor.newInstance(filePath, !append);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get TsFile output of file: {}. Please check your dependency of object storage module.", (Object)filePath, (Object)e);
            return null;
        }
    }
}

