/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session;

import java.security.SecureRandom;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.rpc.DeepCopyRpcTransportFactory;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.RedirectException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.IClientRPCService;
import org.apache.iotdb.service.rpc.thrift.TCreateTimeseriesUsingSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSAggregationQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSAppendSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSBackupConfigurationResp;
import org.apache.iotdb.service.rpc.thrift.TSCloseSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSConnectionInfoResp;
import org.apache.iotdb.service.rpc.thrift.TSCreateAlignedTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateMultiTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSDeleteDataReq;
import org.apache.iotdb.service.rpc.thrift.TSDropSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSFastLastDataQueryForOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletsReq;
import org.apache.iotdb.service.rpc.thrift.TSLastDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionResp;
import org.apache.iotdb.service.rpc.thrift.TSPruneSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSQueryTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSQueryTemplateResp;
import org.apache.iotdb.service.rpc.thrift.TSRawDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSSetSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSSetTimeZoneReq;
import org.apache.iotdb.service.rpc.thrift.TSUnsetSchemaTemplateReq;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.session.util.SessionUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionConnection {
    private static final Logger logger = LoggerFactory.getLogger(SessionConnection.class);
    public static final String MSG_RECONNECTION_FAIL = "Fail to reconnect to server. Please check server status.";
    protected Session session;
    private TTransport transport;
    protected IClientRPCService.Iface client;
    private long sessionId;
    private long statementId;
    private ZoneId zoneId;
    private TEndPoint endPoint;
    private List<TEndPoint> endPointList = new ArrayList<TEndPoint>();
    private boolean enableRedirect = false;
    private final Supplier<List<TEndPoint>> availableNodes;
    private final int maxRetryCount;
    private final long retryIntervalInMs;

    public SessionConnection() {
        this.availableNodes = Collections::emptyList;
        this.maxRetryCount = Math.max(0, 60);
        this.retryIntervalInMs = Math.max(0L, 500L);
    }

    public SessionConnection(Session session, TEndPoint endPoint, ZoneId zoneId, Supplier<List<TEndPoint>> availableNodes, int maxRetryCount, long retryIntervalInMs) throws IoTDBConnectionException {
        this.session = session;
        this.endPoint = endPoint;
        this.endPointList.add(endPoint);
        this.zoneId = zoneId == null ? ZoneId.systemDefault() : zoneId;
        this.availableNodes = availableNodes;
        this.maxRetryCount = Math.max(0, maxRetryCount);
        this.retryIntervalInMs = Math.max(0L, retryIntervalInMs);
        try {
            this.init(endPoint, session.useSSL, session.trustStore, session.trustStorePwd);
        }
        catch (StatementExecutionException e) {
            throw new IoTDBConnectionException(e.getMessage());
        }
        catch (IoTDBConnectionException e) {
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    public SessionConnection(Session session, ZoneId zoneId, Supplier<List<TEndPoint>> availableNodes, int maxRetryCount, long retryIntervalInMs) throws IoTDBConnectionException {
        this.session = session;
        this.zoneId = zoneId == null ? ZoneId.systemDefault() : zoneId;
        this.endPointList = SessionUtils.parseSeedNodeUrls(session.nodeUrls);
        this.availableNodes = availableNodes;
        this.maxRetryCount = Math.max(0, maxRetryCount);
        this.retryIntervalInMs = Math.max(0L, retryIntervalInMs);
        this.initClusterConn();
    }

    private void init(TEndPoint endPoint, boolean useSSL, String trustStore, String trustStorePwd) throws IoTDBConnectionException, StatementExecutionException {
        DeepCopyRpcTransportFactory.setDefaultBufferCapacity(this.session.thriftDefaultBufferSize);
        DeepCopyRpcTransportFactory.setThriftMaxFrameSize(this.session.thriftMaxFrameSize);
        try {
            this.transport = useSSL ? DeepCopyRpcTransportFactory.INSTANCE.getTransport(endPoint.getIp(), endPoint.getPort(), this.session.connectionTimeoutInMs, trustStore, trustStorePwd) : DeepCopyRpcTransportFactory.INSTANCE.getTransport(endPoint.getIp(), endPoint.getPort(), this.session.connectionTimeoutInMs);
            if (!this.transport.isOpen()) {
                this.transport.open();
            }
        }
        catch (TTransportException e) {
            throw new IoTDBConnectionException(e);
        }
        this.client = this.session.enableRPCCompression ? new IClientRPCService.Client(new TCompactProtocol(this.transport)) : new IClientRPCService.Client(new TBinaryProtocol(this.transport));
        this.client = RpcUtils.newSynchronizedClient(this.client);
        TSOpenSessionReq openReq = new TSOpenSessionReq();
        openReq.setUsername(this.session.username);
        openReq.setPassword(this.session.password);
        openReq.setZoneId(this.zoneId.toString());
        openReq.putToConfiguration("version", this.session.version.toString());
        try {
            TSOpenSessionResp openResp = this.client.openSession(openReq);
            RpcUtils.verifySuccess(openResp.getStatus());
            if (Session.protocolVersion.getValue() != openResp.getServerProtocolVersion().getValue()) {
                logger.warn("Protocol differ, Client version is {}}, but Server version is {}", (Object)Session.protocolVersion.getValue(), (Object)openResp.getServerProtocolVersion().getValue());
                if (openResp.getServerProtocolVersion().getValue() == 0) {
                    throw new TException(String.format("Protocol not supported, Client version is %s, but Server version is %s", Session.protocolVersion.getValue(), openResp.getServerProtocolVersion().getValue()));
                }
            }
            this.sessionId = openResp.getSessionId();
            this.statementId = this.client.requestStatementId(this.sessionId);
        }
        catch (StatementExecutionException e) {
            this.transport.close();
            throw e;
        }
        catch (Exception e) {
            this.transport.close();
            throw new IoTDBConnectionException(e);
        }
    }

    private void initClusterConn() throws IoTDBConnectionException {
        Iterator<TEndPoint> iterator = this.endPointList.iterator();
        if (iterator.hasNext()) {
            TEndPoint tEndPoint = iterator.next();
            try {
                this.session.defaultEndPoint = tEndPoint;
                this.init(tEndPoint, this.session.useSSL, this.session.trustStore, this.session.trustStorePwd);
            }
            catch (IoTDBConnectionException e) {
                if (!this.reconnect()) {
                    logger.error("Cluster has no nodes to connect");
                    throw new IoTDBConnectionException(this.logForReconnectionFailure());
                }
            }
            catch (StatementExecutionException e) {
                throw new IoTDBConnectionException(e.getMessage());
            }
        }
    }

    public void close() throws IoTDBConnectionException {
        TSCloseSessionReq req = new TSCloseSessionReq(this.sessionId);
        try {
            this.client.closeSession(req);
        }
        catch (TException e) {
            throw new IoTDBConnectionException("Error occurs when closing session at server. Maybe server is down.", e);
        }
        finally {
            if (this.transport != null) {
                this.transport.close();
            }
        }
    }

    protected IClientRPCService.Iface getClient() {
        return this.client;
    }

    protected void setTimeZone(String zoneId) throws StatementExecutionException, IoTDBConnectionException {
        TSStatus resp;
        TSSetTimeZoneReq req = new TSSetTimeZoneReq(this.sessionId, zoneId);
        try {
            resp = this.client.setTimeZone(req);
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    req.setSessionId(this.sessionId);
                    resp = this.client.setTimeZone(req);
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
        RpcUtils.verifySuccess(resp);
        this.setTimeZoneOfSession(zoneId);
    }

    protected void setTimeZoneOfSession(String zoneId) {
        this.zoneId = ZoneId.of(zoneId);
    }

    protected String getTimeZone() {
        if (this.zoneId == null) {
            this.zoneId = ZoneId.systemDefault();
        }
        return this.zoneId.toString();
    }

    protected void setStorageGroup(String storageGroup) throws IoTDBConnectionException, StatementExecutionException {
        try {
            RpcUtils.verifySuccess(this.client.setStorageGroup(this.sessionId, storageGroup));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    RpcUtils.verifySuccess(this.client.setStorageGroup(this.sessionId, storageGroup));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    protected void deleteStorageGroups(List<String> storageGroups) throws IoTDBConnectionException, StatementExecutionException {
        try {
            RpcUtils.verifySuccess(this.client.deleteStorageGroups(this.sessionId, storageGroups));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    RpcUtils.verifySuccess(this.client.deleteStorageGroups(this.sessionId, storageGroups));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    protected void createTimeseries(TSCreateTimeseriesReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess(this.client.createTimeseries(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess(this.client.createTimeseries(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    protected void createAlignedTimeseries(TSCreateAlignedTimeseriesReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess(this.client.createAlignedTimeseries(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess(this.client.createAlignedTimeseries(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    protected void createMultiTimeseries(TSCreateMultiTimeseriesReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess(this.client.createMultiTimeseries(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess(this.client.createMultiTimeseries(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkTimeseriesExists(String path, long timeout) throws IoTDBConnectionException, StatementExecutionException {
        SessionDataSet dataSet = null;
        try {
            try {
                dataSet = this.executeQueryStatement(String.format("SHOW TIMESERIES %s", path), timeout);
            }
            catch (RedirectException e) {
                throw new StatementExecutionException("need to redirect query, should not see this.", e);
            }
            boolean bl = dataSet.hasNext();
            return bl;
        }
        finally {
            if (dataSet != null) {
                dataSet.closeOperationHandle();
            }
        }
    }

    protected SessionDataSet executeQueryStatement(String sql, long timeout) throws StatementExecutionException, IoTDBConnectionException, RedirectException {
        TSExecuteStatementResp execResp;
        TSExecuteStatementReq execReq = new TSExecuteStatementReq(this.sessionId, sql, this.statementId);
        execReq.setFetchSize(this.session.fetchSize);
        execReq.setTimeout(timeout);
        try {
            execReq.setEnableRedirectQuery(this.enableRedirect);
            execResp = this.client.executeQueryStatementV2(execReq);
            RpcUtils.verifySuccessWithRedirection(execResp.getStatus());
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    execReq.setSessionId(this.sessionId);
                    execReq.setStatementId(this.statementId);
                    execResp = this.client.executeQueryStatementV2(execReq);
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
        RpcUtils.verifySuccess(execResp.getStatus());
        return new SessionDataSet(sql, execResp.getColumns(), execResp.getDataTypeList(), execResp.columnNameIndexMap, execResp.getQueryId(), this.statementId, this.client, this.sessionId, execResp.queryResult, execResp.isIgnoreTimeStamp(), timeout, execResp.moreData, this.session.fetchSize);
    }

    protected void executeNonQueryStatement(String sql) throws IoTDBConnectionException, StatementExecutionException {
        TSExecuteStatementReq request = new TSExecuteStatementReq(this.sessionId, sql, this.statementId);
        TException lastTException = null;
        TSStatus status = null;
        for (int i = 0; i <= this.maxRetryCount; ++i) {
            if (i > 0) {
                lastTException = null;
                status = null;
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retryIntervalInMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.reconnect()) continue;
            }
            try {
                status = this.executeNonQueryStatementInternal(request);
                if (status.isSetNeedRetry() && status.isNeedRetry()) continue;
                RpcUtils.verifySuccess(status);
                return;
            }
            catch (TException e) {
                lastTException = e;
            }
        }
        if (status == null) {
            if (lastTException != null) {
                throw new IoTDBConnectionException(lastTException);
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
        RpcUtils.verifySuccess(status);
    }

    private TSStatus executeNonQueryStatementInternal(TSExecuteStatementReq request) throws TException {
        request.setSessionId(this.sessionId);
        request.setStatementId(this.statementId);
        return this.client.executeUpdateStatementV2((TSExecuteStatementReq)request).status;
    }

    protected SessionDataSet executeRawDataQuery(List<String> paths, long startTime, long endTime, long timeOut) throws StatementExecutionException, IoTDBConnectionException, RedirectException {
        TSExecuteStatementResp execResp;
        TSRawDataQueryReq execReq = new TSRawDataQueryReq(this.sessionId, paths, startTime, endTime, this.statementId);
        execReq.setFetchSize(this.session.fetchSize);
        execReq.setTimeout(timeOut);
        try {
            execReq.setEnableRedirectQuery(this.enableRedirect);
            execResp = this.client.executeRawDataQueryV2(execReq);
            RpcUtils.verifySuccessWithRedirection(execResp.getStatus());
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    execReq.setSessionId(this.sessionId);
                    execReq.setStatementId(this.statementId);
                    execResp = this.client.executeRawDataQueryV2(execReq);
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
        RpcUtils.verifySuccess(execResp.getStatus());
        return new SessionDataSet("", execResp.getColumns(), execResp.getDataTypeList(), execResp.columnNameIndexMap, execResp.getQueryId(), this.statementId, this.client, this.sessionId, execResp.queryResult, execResp.isIgnoreTimeStamp(), execResp.moreData);
    }

    protected Pair<SessionDataSet, TEndPoint> executeLastDataQueryForOneDevice(String db, String device, List<String> sensors, boolean isLegalPathNodes, long timeOut) throws StatementExecutionException, IoTDBConnectionException {
        TSFastLastDataQueryForOneDeviceReq req = new TSFastLastDataQueryForOneDeviceReq(this.sessionId, db, device, sensors, this.statementId);
        req.setFetchSize(this.session.fetchSize);
        req.setEnableRedirectQuery(this.enableRedirect);
        req.setLegalPathNodes(isLegalPathNodes);
        req.setTimeout(timeOut);
        TSExecuteStatementResp tsExecuteStatementResp = null;
        TEndPoint redirectedEndPoint = null;
        try {
            tsExecuteStatementResp = this.client.executeFastLastDataQueryForOneDeviceV2(req);
            RpcUtils.verifySuccessWithRedirection(tsExecuteStatementResp.getStatus());
        }
        catch (RedirectException e) {
            redirectedEndPoint = e.getEndPoint();
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    req.setSessionId(this.sessionId);
                    req.setStatementId(this.statementId);
                    tsExecuteStatementResp = this.client.executeFastLastDataQueryForOneDeviceV2(req);
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
        RpcUtils.verifySuccess(tsExecuteStatementResp.getStatus());
        return new Pair<SessionDataSet, TEndPoint>(new SessionDataSet("", tsExecuteStatementResp.getColumns(), tsExecuteStatementResp.getDataTypeList(), tsExecuteStatementResp.columnNameIndexMap, tsExecuteStatementResp.getQueryId(), this.statementId, this.client, this.sessionId, tsExecuteStatementResp.queryResult, tsExecuteStatementResp.isIgnoreTimeStamp(), tsExecuteStatementResp.moreData), redirectedEndPoint);
    }

    protected SessionDataSet executeLastDataQuery(List<String> paths, long time, long timeOut) throws StatementExecutionException, IoTDBConnectionException, RedirectException {
        TSExecuteStatementResp tsExecuteStatementResp;
        TSLastDataQueryReq tsLastDataQueryReq = new TSLastDataQueryReq(this.sessionId, paths, time, this.statementId);
        tsLastDataQueryReq.setFetchSize(this.session.fetchSize);
        tsLastDataQueryReq.setEnableRedirectQuery(this.enableRedirect);
        tsLastDataQueryReq.setTimeout(timeOut);
        try {
            tsExecuteStatementResp = this.client.executeLastDataQueryV2(tsLastDataQueryReq);
            RpcUtils.verifySuccessWithRedirection(tsExecuteStatementResp.getStatus());
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    tsLastDataQueryReq.setSessionId(this.sessionId);
                    tsLastDataQueryReq.setStatementId(this.statementId);
                    tsExecuteStatementResp = this.client.executeLastDataQueryV2(tsLastDataQueryReq);
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
        RpcUtils.verifySuccess(tsExecuteStatementResp.getStatus());
        return new SessionDataSet("", tsExecuteStatementResp.getColumns(), tsExecuteStatementResp.getDataTypeList(), tsExecuteStatementResp.columnNameIndexMap, tsExecuteStatementResp.getQueryId(), this.statementId, this.client, this.sessionId, tsExecuteStatementResp.queryResult, tsExecuteStatementResp.isIgnoreTimeStamp(), tsExecuteStatementResp.moreData);
    }

    protected SessionDataSet executeAggregationQuery(List<String> paths, List<TAggregationType> aggregations) throws StatementExecutionException, IoTDBConnectionException, RedirectException {
        TSAggregationQueryReq req = this.createAggregationQueryReq(paths, aggregations);
        return this.executeAggregationQuery(req);
    }

    protected SessionDataSet executeAggregationQuery(List<String> paths, List<TAggregationType> aggregations, long startTime, long endTime) throws StatementExecutionException, IoTDBConnectionException, RedirectException {
        TSAggregationQueryReq req = this.createAggregationQueryReq(paths, aggregations);
        req.setStartTime(startTime);
        req.setEndTime(endTime);
        return this.executeAggregationQuery(req);
    }

    protected SessionDataSet executeAggregationQuery(List<String> paths, List<TAggregationType> aggregations, long startTime, long endTime, long interval) throws StatementExecutionException, IoTDBConnectionException, RedirectException {
        TSAggregationQueryReq req = this.createAggregationQueryReq(paths, aggregations);
        req.setStartTime(startTime);
        req.setEndTime(endTime);
        req.setInterval(interval);
        return this.executeAggregationQuery(req);
    }

    protected SessionDataSet executeAggregationQuery(List<String> paths, List<TAggregationType> aggregations, long startTime, long endTime, long interval, long slidingStep) throws StatementExecutionException, IoTDBConnectionException, RedirectException {
        TSAggregationQueryReq req = this.createAggregationQueryReq(paths, aggregations);
        req.setStartTime(startTime);
        req.setEndTime(endTime);
        req.setInterval(interval);
        req.setSlidingStep(slidingStep);
        return this.executeAggregationQuery(req);
    }

    private SessionDataSet executeAggregationQuery(TSAggregationQueryReq tsAggregationQueryReq) throws StatementExecutionException, IoTDBConnectionException, RedirectException {
        TSExecuteStatementResp tsExecuteStatementResp;
        try {
            tsExecuteStatementResp = this.client.executeAggregationQueryV2(tsAggregationQueryReq);
            RpcUtils.verifySuccessWithRedirection(tsExecuteStatementResp.getStatus());
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    tsAggregationQueryReq.setSessionId(this.sessionId);
                    tsAggregationQueryReq.setStatementId(this.statementId);
                    tsExecuteStatementResp = this.client.executeAggregationQuery(tsAggregationQueryReq);
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
        RpcUtils.verifySuccess(tsExecuteStatementResp.getStatus());
        return new SessionDataSet("", tsExecuteStatementResp.getColumns(), tsExecuteStatementResp.getDataTypeList(), tsExecuteStatementResp.columnNameIndexMap, tsExecuteStatementResp.getQueryId(), this.statementId, this.client, this.sessionId, tsExecuteStatementResp.queryResult, tsExecuteStatementResp.isIgnoreTimeStamp(), tsExecuteStatementResp.moreData);
    }

    private TSAggregationQueryReq createAggregationQueryReq(List<String> paths, List<TAggregationType> aggregations) {
        TSAggregationQueryReq req = new TSAggregationQueryReq(this.sessionId, this.statementId, paths, aggregations);
        req.setFetchSize(this.session.getFetchSize());
        req.setTimeout(this.session.getQueryTimeout());
        return req;
    }

    protected void insertRecord(TSInsertRecordReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        TException lastTException = null;
        TSStatus status = null;
        for (int i = 0; i <= this.maxRetryCount; ++i) {
            if (i > 0) {
                lastTException = null;
                status = null;
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retryIntervalInMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.reconnect()) continue;
            }
            try {
                status = this.insertRecordInternal(request);
                if (status.isSetNeedRetry() && status.isNeedRetry()) continue;
                if (i == 0) {
                    RpcUtils.verifySuccessWithRedirection(status);
                } else {
                    RpcUtils.verifySuccess(status);
                }
                return;
            }
            catch (TException e) {
                lastTException = e;
            }
        }
        if (status == null) {
            if (lastTException != null) {
                throw new IoTDBConnectionException(lastTException);
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
        RpcUtils.verifySuccess(status);
    }

    private TSStatus insertRecordInternal(TSInsertRecordReq request) throws TException {
        request.setSessionId(this.sessionId);
        return this.client.insertRecord(request);
    }

    protected void insertRecord(TSInsertStringRecordReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        TException lastTException = null;
        TSStatus status = null;
        for (int i = 0; i <= this.maxRetryCount; ++i) {
            if (i > 0) {
                lastTException = null;
                status = null;
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retryIntervalInMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.reconnect()) continue;
            }
            try {
                status = this.insertRecordInternal(request);
                if (status.isSetNeedRetry() && status.isNeedRetry()) continue;
                if (i == 0) {
                    RpcUtils.verifySuccessWithRedirection(status);
                } else {
                    RpcUtils.verifySuccess(status);
                }
                return;
            }
            catch (TException e) {
                lastTException = e;
            }
        }
        if (status == null) {
            if (lastTException != null) {
                throw new IoTDBConnectionException(lastTException);
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
        RpcUtils.verifySuccess(status);
    }

    private TSStatus insertRecordInternal(TSInsertStringRecordReq request) throws TException {
        request.setSessionId(this.sessionId);
        return this.client.insertStringRecord(request);
    }

    protected void insertRecords(TSInsertRecordsReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        TException lastTException = null;
        TSStatus status = null;
        for (int i = 0; i <= this.maxRetryCount; ++i) {
            if (i > 0) {
                lastTException = null;
                status = null;
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retryIntervalInMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.reconnect()) continue;
            }
            try {
                status = this.insertRecordsInternal(request);
                if (status.isSetNeedRetry() && status.isNeedRetry()) continue;
                if (i == 0) {
                    RpcUtils.verifySuccessWithRedirectionForMultiDevices(status, request.getPrefixPaths());
                } else {
                    RpcUtils.verifySuccess(status);
                }
                return;
            }
            catch (TException e) {
                lastTException = e;
            }
        }
        if (status == null) {
            if (lastTException != null) {
                throw new IoTDBConnectionException(lastTException);
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
        RpcUtils.verifySuccess(status);
    }

    private TSStatus insertRecordsInternal(TSInsertRecordsReq request) throws TException {
        request.setSessionId(this.sessionId);
        return this.client.insertRecords(request);
    }

    protected void insertRecords(TSInsertStringRecordsReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        TException lastTException = null;
        TSStatus status = null;
        for (int i = 0; i <= this.maxRetryCount; ++i) {
            if (i > 0) {
                lastTException = null;
                status = null;
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retryIntervalInMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.reconnect()) continue;
            }
            try {
                status = this.insertRecordsInternal(request);
                if (status.isSetNeedRetry() && status.isNeedRetry()) continue;
                if (i == 0) {
                    RpcUtils.verifySuccessWithRedirectionForMultiDevices(status, request.getPrefixPaths());
                } else {
                    RpcUtils.verifySuccess(status);
                }
                return;
            }
            catch (TException e) {
                lastTException = e;
            }
        }
        if (status == null) {
            if (lastTException != null) {
                throw new IoTDBConnectionException(lastTException);
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
        RpcUtils.verifySuccess(status);
    }

    private TSStatus insertRecordsInternal(TSInsertStringRecordsReq request) throws TException {
        request.setSessionId(this.sessionId);
        return this.client.insertStringRecords(request);
    }

    protected void insertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        TException lastTException = null;
        TSStatus status = null;
        for (int i = 0; i <= this.maxRetryCount; ++i) {
            if (i > 0) {
                lastTException = null;
                status = null;
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retryIntervalInMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.reconnect()) continue;
            }
            try {
                status = this.insertRecordsOfOneDeviceInternal(request);
                if (status.isSetNeedRetry() && status.isNeedRetry()) continue;
                if (i == 0) {
                    RpcUtils.verifySuccessWithRedirection(status);
                } else {
                    RpcUtils.verifySuccess(status);
                }
                return;
            }
            catch (TException e) {
                lastTException = e;
            }
        }
        if (status == null) {
            if (lastTException != null) {
                throw new IoTDBConnectionException(lastTException);
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
        RpcUtils.verifySuccess(status);
    }

    private TSStatus insertRecordsOfOneDeviceInternal(TSInsertRecordsOfOneDeviceReq request) throws TException {
        request.setSessionId(this.sessionId);
        return this.client.insertRecordsOfOneDevice(request);
    }

    protected void insertStringRecordsOfOneDevice(TSInsertStringRecordsOfOneDeviceReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        TException lastTException = null;
        TSStatus status = null;
        for (int i = 0; i <= this.maxRetryCount; ++i) {
            if (i > 0) {
                lastTException = null;
                status = null;
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retryIntervalInMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.reconnect()) continue;
            }
            try {
                status = this.insertStringRecordsOfOneDeviceInternal(request);
                if (status.isSetNeedRetry() && status.isNeedRetry()) continue;
                if (i == 0) {
                    RpcUtils.verifySuccessWithRedirection(status);
                } else {
                    RpcUtils.verifySuccess(status);
                }
                return;
            }
            catch (TException e) {
                lastTException = e;
            }
        }
        if (status == null) {
            if (lastTException != null) {
                throw new IoTDBConnectionException(lastTException);
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
        RpcUtils.verifySuccess(status);
    }

    private TSStatus insertStringRecordsOfOneDeviceInternal(TSInsertStringRecordsOfOneDeviceReq request) throws TException {
        request.setSessionId(this.sessionId);
        return this.client.insertStringRecordsOfOneDevice(request);
    }

    protected void insertTablet(TSInsertTabletReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        TException lastTException = null;
        TSStatus status = null;
        for (int i = 0; i <= this.maxRetryCount; ++i) {
            if (i > 0) {
                lastTException = null;
                status = null;
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retryIntervalInMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.reconnect()) continue;
            }
            try {
                status = this.insertTabletInternal(request);
                if (status.isSetNeedRetry() && status.isNeedRetry()) continue;
                if (i == 0) {
                    RpcUtils.verifySuccessWithRedirection(status);
                } else {
                    RpcUtils.verifySuccess(status);
                }
                return;
            }
            catch (TException e) {
                lastTException = e;
            }
        }
        if (status == null) {
            if (lastTException != null) {
                throw new IoTDBConnectionException(lastTException);
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
        RpcUtils.verifySuccess(status);
    }

    private TSStatus insertTabletInternal(TSInsertTabletReq request) throws TException {
        request.setSessionId(this.sessionId);
        return this.client.insertTablet(request);
    }

    protected void insertTablets(TSInsertTabletsReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        TException lastTException = null;
        TSStatus status = null;
        for (int i = 0; i <= this.maxRetryCount; ++i) {
            if (i > 0) {
                lastTException = null;
                status = null;
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retryIntervalInMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.reconnect()) continue;
            }
            try {
                status = this.insertTabletsInternal(request);
                if (status.isSetNeedRetry() && status.isNeedRetry()) continue;
                if (i == 0) {
                    RpcUtils.verifySuccessWithRedirectionForMultiDevices(status, request.getPrefixPaths());
                } else {
                    RpcUtils.verifySuccess(status);
                }
                return;
            }
            catch (TException e) {
                lastTException = e;
            }
        }
        if (status == null) {
            if (lastTException != null) {
                throw new IoTDBConnectionException(lastTException);
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
        RpcUtils.verifySuccess(status);
    }

    private TSStatus insertTabletsInternal(TSInsertTabletsReq request) throws TException {
        request.setSessionId(this.sessionId);
        return this.client.insertTablets(request);
    }

    protected void deleteTimeseries(List<String> paths) throws IoTDBConnectionException, StatementExecutionException {
        TException lastTException = null;
        TSStatus status = null;
        for (int i = 0; i <= this.maxRetryCount; ++i) {
            if (i > 0) {
                lastTException = null;
                status = null;
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retryIntervalInMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.reconnect()) continue;
            }
            try {
                status = this.client.deleteTimeseries(this.sessionId, paths);
                if (status.isSetNeedRetry() && status.isNeedRetry()) continue;
                RpcUtils.verifySuccess(status);
                return;
            }
            catch (TException e) {
                lastTException = e;
            }
        }
        if (status == null) {
            if (lastTException != null) {
                throw new IoTDBConnectionException(lastTException);
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
        RpcUtils.verifySuccess(status);
    }

    public void deleteData(TSDeleteDataReq request) throws IoTDBConnectionException, StatementExecutionException {
        TException lastTException = null;
        TSStatus status = null;
        for (int i = 0; i <= this.maxRetryCount; ++i) {
            if (i > 0) {
                lastTException = null;
                status = null;
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retryIntervalInMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.reconnect()) continue;
            }
            try {
                status = this.deleteDataInternal(request);
                if (status.isSetNeedRetry() && status.isNeedRetry()) continue;
                RpcUtils.verifySuccess(status);
                return;
            }
            catch (TException e) {
                lastTException = e;
            }
        }
        if (status == null) {
            if (lastTException != null) {
                throw new IoTDBConnectionException(lastTException);
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
        RpcUtils.verifySuccess(status);
    }

    private TSStatus deleteDataInternal(TSDeleteDataReq request) throws TException {
        request.setSessionId(this.sessionId);
        return this.client.deleteData(request);
    }

    protected void testInsertRecord(TSInsertStringRecordReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess(this.client.testInsertStringRecord(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess(this.client.testInsertStringRecord(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    protected void testInsertRecord(TSInsertRecordReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess(this.client.testInsertRecord(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess(this.client.testInsertRecord(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    public void testInsertRecords(TSInsertStringRecordsReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess(this.client.testInsertStringRecords(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess(this.client.testInsertStringRecords(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    public void testInsertRecords(TSInsertRecordsReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess(this.client.testInsertRecords(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess(this.client.testInsertRecords(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    protected void testInsertTablet(TSInsertTabletReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess(this.client.testInsertTablet(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess(this.client.testInsertTablet(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    protected void testInsertTablets(TSInsertTabletsReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess(this.client.testInsertTablets(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess(this.client.testInsertTablets(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    private boolean reconnect() {
        boolean connectedSuccess = false;
        SecureRandom random = new SecureRandom();
        for (int i = 1; i <= 3; ++i) {
            if (this.transport != null) {
                this.transport.close();
                this.endPointList = this.availableNodes.get();
                int currHostIndex = random.nextInt(this.endPointList.size());
                int tryHostNum = 0;
                for (int j = currHostIndex; j < this.endPointList.size() && tryHostNum != this.endPointList.size(); ++tryHostNum, ++j) {
                    this.endPoint = this.endPointList.get(j);
                    if (j == this.endPointList.size() - 1) {
                        j = -1;
                    }
                    try {
                        this.init(this.endPoint, this.session.useSSL, this.session.trustStore, this.session.trustStorePwd);
                        connectedSuccess = true;
                        break;
                    }
                    catch (IoTDBConnectionException e) {
                        logger.warn("The current node may have been down {}, try next node", (Object)this.endPoint);
                        continue;
                    }
                    catch (StatementExecutionException e) {
                        logger.warn("login in failed, because {}", (Object)e.getMessage());
                        break;
                    }
                }
            }
            if (!connectedSuccess) continue;
            this.session.removeBrokenSessionConnection(this);
            this.session.defaultEndPoint = this.endPoint;
            this.session.defaultSessionConnection = this;
            if (this.session.endPointToSessionConnection == null) {
                this.session.endPointToSessionConnection = new ConcurrentHashMap<TEndPoint, SessionConnection>();
            }
            this.session.endPointToSessionConnection.put(this.session.defaultEndPoint, this);
            break;
        }
        return connectedSuccess;
    }

    protected void createSchemaTemplate(TSCreateSchemaTemplateReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess(this.client.createSchemaTemplate(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess(this.client.createSchemaTemplate(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    protected void appendSchemaTemplate(TSAppendSchemaTemplateReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess(this.client.appendSchemaTemplate(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess(this.client.appendSchemaTemplate(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    protected void pruneSchemaTemplate(TSPruneSchemaTemplateReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess(this.client.pruneSchemaTemplate(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess(this.client.pruneSchemaTemplate(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    protected TSQueryTemplateResp querySchemaTemplate(TSQueryTemplateReq req) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateResp execResp;
        req.setSessionId(this.sessionId);
        try {
            execResp = this.client.querySchemaTemplate(req);
            RpcUtils.verifySuccess(execResp.getStatus());
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    execResp = this.client.querySchemaTemplate(req);
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
        RpcUtils.verifySuccess(execResp.getStatus());
        return execResp;
    }

    protected void setSchemaTemplate(TSSetSchemaTemplateReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess(this.client.setSchemaTemplate(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess(this.client.setSchemaTemplate(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    protected void unsetSchemaTemplate(TSUnsetSchemaTemplateReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess(this.client.unsetSchemaTemplate(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess(this.client.unsetSchemaTemplate(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    protected void dropSchemaTemplate(TSDropSchemaTemplateReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess(this.client.dropSchemaTemplate(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess(this.client.dropSchemaTemplate(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    protected void createTimeseriesUsingSchemaTemplate(TCreateTimeseriesUsingSchemaTemplateReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess(this.client.createTimeseriesUsingSchemaTemplate(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess(this.client.createTimeseriesUsingSchemaTemplate(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
    }

    protected TSBackupConfigurationResp getBackupConfiguration() throws IoTDBConnectionException, StatementExecutionException {
        TSBackupConfigurationResp execResp;
        try {
            execResp = this.client.getBackupConfiguration();
            RpcUtils.verifySuccess(execResp.getStatus());
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    execResp = this.client.getBackupConfiguration();
                    RpcUtils.verifySuccess(execResp.getStatus());
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
        return execResp;
    }

    public TSConnectionInfoResp fetchAllConnections() throws IoTDBConnectionException {
        try {
            return this.client.fetchAllConnectionsInfo();
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    return this.client.fetchAllConnectionsInfo();
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    public boolean isEnableRedirect() {
        return this.enableRedirect;
    }

    public void setEnableRedirect(boolean enableRedirect) {
        this.enableRedirect = enableRedirect;
    }

    public TEndPoint getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(TEndPoint endPoint) {
        this.endPoint = endPoint;
    }

    private String logForReconnectionFailure() {
        if (this.endPointList == null) {
            return MSG_RECONNECTION_FAIL;
        }
        StringJoiner urls = new StringJoiner(",");
        for (TEndPoint end : this.endPointList) {
            StringJoiner url = new StringJoiner(":");
            url.add(end.getIp());
            url.add(String.valueOf(end.getPort()));
            urls.add(url.toString());
        }
        return MSG_RECONNECTION_FAIL.concat(urls.toString());
    }

    public String toString() {
        return "SessionConnection{ endPoint=" + this.endPoint + "}";
    }
}

