/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.rpc.subscription.config.ConsumerConfig;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeRequestType;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeRequestVersion;
import org.apache.iotdb.service.rpc.thrift.TPipeSubscribeReq;
import org.apache.iotdb.tsfile.utils.PublicBAOS;

public class PipeSubscribeHandshakeReq
extends TPipeSubscribeReq {
    private transient ConsumerConfig consumerConfig = new ConsumerConfig();

    public ConsumerConfig getConsumerConfig() {
        return this.consumerConfig;
    }

    public static PipeSubscribeHandshakeReq toTPipeSubscribeReq(ConsumerConfig consumerConfig) throws IOException {
        PipeSubscribeHandshakeReq req = new PipeSubscribeHandshakeReq();
        req.consumerConfig = consumerConfig;
        req.version = PipeSubscribeRequestVersion.VERSION_1.getVersion();
        req.type = PipeSubscribeRequestType.HANDSHAKE.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);){
            consumerConfig.serialize(outputStream);
            req.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return req;
    }

    public static PipeSubscribeHandshakeReq fromTPipeSubscribeReq(TPipeSubscribeReq handshakeReq) {
        PipeSubscribeHandshakeReq req = new PipeSubscribeHandshakeReq();
        if (Objects.nonNull(handshakeReq.body) && handshakeReq.body.hasRemaining()) {
            req.consumerConfig = ConsumerConfig.deserialize(handshakeReq.body);
        }
        req.version = handshakeReq.version;
        req.type = handshakeReq.type;
        req.body = handshakeReq.body;
        return req;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PipeSubscribeHandshakeReq that = (PipeSubscribeHandshakeReq)obj;
        return Objects.equals(this.consumerConfig, that.consumerConfig) && this.version == that.version && this.type == that.type && Objects.equals(this.body, that.body);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.consumerConfig, this.version, this.type, this.body);
    }
}

