/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.record.Tablet;

public class EnrichedTablets {
    private transient String topicName;
    private transient String subscriptionCommitId;
    private transient List<Tablet> tablets;

    public String getTopicName() {
        return this.topicName;
    }

    public String getSubscriptionCommitId() {
        return this.subscriptionCommitId;
    }

    public List<Tablet> getTablets() {
        return this.tablets;
    }

    public EnrichedTablets() {
        this.tablets = new ArrayList<Tablet>();
    }

    public EnrichedTablets(String topicName, List<Tablet> tablets, String subscriptionCommitId) {
        this.topicName = topicName;
        this.tablets = tablets;
        this.subscriptionCommitId = subscriptionCommitId;
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write(this.topicName, (OutputStream)stream);
        ReadWriteIOUtils.write(this.subscriptionCommitId, (OutputStream)stream);
        ReadWriteIOUtils.write(this.tablets.size(), (OutputStream)stream);
        for (Tablet tablet : this.tablets) {
            tablet.serialize(stream);
        }
    }

    public static EnrichedTablets deserialize(ByteBuffer buffer) {
        EnrichedTablets enrichedTablets = new EnrichedTablets();
        enrichedTablets.topicName = ReadWriteIOUtils.readString(buffer);
        enrichedTablets.subscriptionCommitId = ReadWriteIOUtils.readString(buffer);
        int size = ReadWriteIOUtils.readInt(buffer);
        for (int i = 0; i < size; ++i) {
            enrichedTablets.tablets.add(Tablet.deserialize(buffer));
        }
        return enrichedTablets;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EnrichedTablets that = (EnrichedTablets)obj;
        return Objects.equals(this.topicName, that.topicName) && Objects.equals(this.subscriptionCommitId, that.subscriptionCommitId) && Objects.equals(this.tablets, that.tablets);
    }

    public int hashCode() {
        return Objects.hash(this.topicName, this.subscriptionCommitId);
    }
}

