/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc;

import org.apache.iotdb.rpc.AutoScalingBufferReadTransport;
import org.apache.iotdb.rpc.AutoScalingBufferWriteTransport;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.apache.thrift.transport.layered.TFramedTransport;

public class TElasticFramedTransport
extends TTransport {
    protected final int thriftDefaultBufferSize;
    protected final int thriftMaxFrameSize;
    protected final TTransport underlying;
    protected AutoScalingBufferReadTransport readBuffer;
    protected AutoScalingBufferWriteTransport writeBuffer;
    protected final byte[] i32buf = new byte[4];
    private final boolean copyBinary;

    public TElasticFramedTransport(TTransport underlying, int thriftDefaultBufferSize, int thriftMaxFrameSize, boolean copyBinary) {
        this.underlying = underlying;
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
        this.thriftMaxFrameSize = thriftMaxFrameSize;
        this.copyBinary = copyBinary;
        this.readBuffer = new AutoScalingBufferReadTransport(thriftDefaultBufferSize);
        this.writeBuffer = new AutoScalingBufferWriteTransport(thriftDefaultBufferSize);
    }

    @Override
    public boolean isOpen() {
        return this.underlying.isOpen();
    }

    @Override
    public void open() throws TTransportException {
        this.underlying.open();
    }

    @Override
    public void close() {
        this.underlying.close();
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        int got = this.readBuffer.read(buf, off, len);
        if (got > 0) {
            return got;
        }
        this.readFrame();
        return this.readBuffer.read(buf, off, len);
    }

    protected void readFrame() throws TTransportException {
        this.underlying.readAll(this.i32buf, 0, 4);
        int size = TFramedTransport.decodeFrameSize(this.i32buf);
        if (size < 0) {
            this.close();
            throw new TTransportException(5, "Read a negative frame size (" + size + ")!");
        }
        if (size > this.thriftMaxFrameSize) {
            this.close();
            throw new TTransportException(5, "Frame size (" + size + ") larger than protect max size (" + this.thriftMaxFrameSize + ")!");
        }
        this.readBuffer.fill(this.underlying, size);
    }

    @Override
    public void flush() throws TTransportException {
        int length = this.writeBuffer.getPos();
        TFramedTransport.encodeFrameSize(length, this.i32buf);
        this.underlying.write(this.i32buf, 0, 4);
        this.underlying.write(this.writeBuffer.getBuffer(), 0, length);
        this.writeBuffer.reset();
        if (length > this.thriftDefaultBufferSize) {
            this.writeBuffer.resizeIfNecessary(this.thriftDefaultBufferSize);
        }
        this.underlying.flush();
    }

    @Override
    public TConfiguration getConfiguration() {
        return this.underlying.getConfiguration();
    }

    @Override
    public void updateKnownMessageSize(long size) throws TTransportException {
    }

    @Override
    public void checkReadBytesAvailable(long numBytes) throws TTransportException {
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.writeBuffer.write(buf, off, len);
    }

    public TTransport getSocket() {
        return this.underlying;
    }

    @Override
    public int getBytesRemainingInBuffer() {
        return this.copyBinary ? -1 : this.readBuffer.getBytesRemainingInBuffer();
    }

    @Override
    public byte[] getBuffer() {
        return this.readBuffer.getBuffer();
    }

    @Override
    public int getBufferPosition() {
        return this.readBuffer.getBufferPosition();
    }

    @Override
    public void consumeBuffer(int len) {
        this.readBuffer.consumeBuffer(len);
    }

    public static class Factory
    extends TTransportFactory {
        protected final int thriftMaxFrameSize;
        protected final int thriftDefaultBufferSize;
        protected final boolean copyBinary;

        public Factory() {
            this(1024, 0x20000000, true);
        }

        public Factory(int thriftDefaultBufferSize, int thriftMaxFrameSize, boolean copyBinary) {
            this.thriftDefaultBufferSize = thriftDefaultBufferSize;
            this.thriftMaxFrameSize = thriftMaxFrameSize;
            this.copyBinary = copyBinary;
        }

        @Override
        public TTransport getTransport(TTransport trans) {
            return new TElasticFramedTransport(trans, this.thriftDefaultBufferSize, this.thriftMaxFrameSize, this.copyBinary);
        }
    }
}

