/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc;

import org.apache.iotdb.rpc.TConfigurationConst;
import org.apache.thrift.transport.TMemoryInputTransport;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

public class BaseRpcTransportFactory
extends TTransportFactory {
    public static boolean USE_SNAPPY = false;
    protected static int thriftDefaultBufferSize = 1024;
    protected static int thriftMaxFrameSize = 0x20000000;
    protected final TTransportFactory inner;

    protected BaseRpcTransportFactory(TTransportFactory inner) {
        this.inner = inner;
    }

    @Override
    public TTransport getTransport(TTransport trans) throws TTransportException {
        this.updateConfigurationForAsyncServerIfNecessary(trans);
        return this.inner.getTransport(trans);
    }

    private void updateConfigurationForAsyncServerIfNecessary(TTransport trans) {
        if (trans instanceof TMemoryInputTransport) {
            trans.getConfiguration().setRecursionLimit(TConfigurationConst.defaultTConfiguration.getRecursionLimit());
            trans.getConfiguration().setMaxMessageSize(TConfigurationConst.defaultTConfiguration.getMaxMessageSize());
            trans.getConfiguration().setMaxFrameSize(TConfigurationConst.defaultTConfiguration.getMaxFrameSize());
        }
    }

    public TTransport getTransportWithNoTimeout(String ip, int port) throws TTransportException {
        return this.inner.getTransport(new TSocket(TConfigurationConst.defaultTConfiguration, ip, port));
    }

    public TTransport getTransport(String ip, int port, int timeout, String trustStore, String trustStorePwd) throws TTransportException {
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        params.setTrustStore(trustStore, trustStorePwd);
        TSocket transport = TSSLTransportFactory.getClientSocket(ip, port, timeout, params);
        return this.inner.getTransport(transport);
    }

    public TTransport getTransport(String ip, int port, int timeout) throws TTransportException {
        return this.inner.getTransport(new TSocket(TConfigurationConst.defaultTConfiguration, ip, port, timeout));
    }

    public static boolean isUseSnappy() {
        return USE_SNAPPY;
    }

    public static void setUseSnappy(boolean useSnappy) {
        USE_SNAPPY = useSnappy;
    }

    public static void setDefaultBufferCapacity(int thriftDefaultBufferSize) {
        BaseRpcTransportFactory.thriftDefaultBufferSize = thriftDefaultBufferSize;
    }

    public static void setThriftMaxFrameSize(int thriftMaxFrameSize) {
        BaseRpcTransportFactory.thriftMaxFrameSize = thriftMaxFrameSize;
    }
}

