/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.flink.sql.provider;

import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.InputFormatProvider;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.TableFunctionProvider;
import org.apache.flink.table.functions.TableFunction;
import org.apache.iotdb.flink.sql.common.Options;
import org.apache.iotdb.flink.sql.function.IoTDBBoundedScanFunction;
import org.apache.iotdb.flink.sql.function.IoTDBCDCSourceFunction;
import org.apache.iotdb.flink.sql.function.IoTDBLookupFunction;
import org.apache.iotdb.flink.sql.wrapper.SchemaWrapper;

public class IoTDBDynamicTableSource
implements LookupTableSource,
ScanTableSource {
    private final ReadableConfig options;
    private final TableSchema schema;

    public IoTDBDynamicTableSource(ReadableConfig options, TableSchema schema) {
        this.options = options;
        this.schema = schema;
    }

    public LookupTableSource.LookupRuntimeProvider getLookupRuntimeProvider(LookupTableSource.LookupContext lookupContext) {
        return TableFunctionProvider.of((TableFunction)new IoTDBLookupFunction(this.options, new SchemaWrapper(this.schema)));
    }

    public DynamicTableSource copy() {
        return new IoTDBDynamicTableSource(this.options, this.schema);
    }

    public String asSummaryString() {
        return "IoTDB Dynamic Table Source";
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.insertOnly();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext scanContext) {
        if (this.options.get(Options.MODE) == Options.Mode.CDC) {
            return SourceFunctionProvider.of((SourceFunction)new IoTDBCDCSourceFunction(this.options, new SchemaWrapper(this.schema)), (boolean)false);
        }
        return InputFormatProvider.of((InputFormat)new IoTDBBoundedScanFunction(this.options, new SchemaWrapper(this.schema)));
    }
}

