/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.flink.sql.factory;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.flink.sql.common.Options;
import org.apache.iotdb.flink.sql.common.Utils;
import org.apache.iotdb.flink.sql.exception.IllegalIoTDBPathException;
import org.apache.iotdb.flink.sql.exception.IllegalOptionException;
import org.apache.iotdb.flink.sql.exception.IllegalSchemaException;
import org.apache.iotdb.flink.sql.exception.IllegalUrlPathException;
import org.apache.iotdb.flink.sql.exception.UnsupportedDataTypeException;
import org.apache.iotdb.flink.sql.provider.IoTDBDynamicTableSink;
import org.apache.iotdb.flink.sql.provider.IoTDBDynamicTableSource;

public class IoTDBDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    private static final HashSet<DataType> supportedDataTypes = new HashSet();

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validate();
        ReadableConfig options = helper.getOptions();
        TableSchema schema = context.getCatalogTable().getSchema();
        this.validate(options, schema, Type.SOURCE);
        return new IoTDBDynamicTableSource(options, schema);
    }

    public String factoryIdentifier() {
        return "IoTDB";
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return new HashSet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet optionalOptions = new HashSet();
        optionalOptions.add(Options.NODE_URLS);
        optionalOptions.add(Options.USER);
        optionalOptions.add(Options.PASSWORD);
        optionalOptions.add(Options.LOOKUP_CACHE_MAX_ROWS);
        optionalOptions.add(Options.LOOKUP_CACHE_TTL_SEC);
        optionalOptions.add(Options.ALIGNED);
        optionalOptions.add(Options.MODE);
        optionalOptions.add(Options.CDC_TASK_NAME);
        optionalOptions.add(Options.CDC_PORT);
        optionalOptions.add(Options.SQL);
        optionalOptions.add(Options.PATTERN);
        optionalOptions.add(Options.CDC_MODE);
        return optionalOptions;
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validate();
        ReadableConfig options = helper.getOptions();
        TableSchema schema = context.getCatalogTable().getSchema();
        this.validate(options, schema, Type.SINK);
        return new IoTDBDynamicTableSink(options, schema);
    }

    /*
     * WARNING - void declaration
     */
    protected void validate(ReadableConfig options, TableSchema schema, Type type) {
        void var9_15;
        String[] nodeUrls;
        String[] fieldNames = schema.getFieldNames();
        DataType[] fieldDataTypes = schema.getFieldDataTypes();
        if (!"Time_".equals(fieldNames[0]) || !fieldDataTypes[0].equals((Object)DataTypes.BIGINT())) {
            throw new IllegalSchemaException("The first field's name must be `Time_`, and its data type must be BIGINT.");
        }
        for (String string : fieldNames) {
            if (!"Time_".equals(string) && !string.startsWith("root.")) {
                throw new IllegalIoTDBPathException(String.format("The field name `%s` doesn't start with 'root.'.", string));
            }
            try {
                String[] nodes;
                for (String node : nodes = PathUtils.splitPathToDetachedNodes(string)) {
                    if (!Utils.isNumeric(node)) continue;
                    throw new IllegalIoTDBPathException(String.format("The node `%s` in the field name `%s` is a pure number, which is not allowed in IoTDB.", node, string));
                }
            }
            catch (IllegalPathException e) {
                throw new IllegalIoTDBPathException(e.getMessage());
            }
        }
        for (String string : fieldDataTypes) {
            if (supportedDataTypes.contains(string)) continue;
            throw new UnsupportedDataTypeException("IoTDB doesn't support the data type: " + string);
        }
        String[] stringArray = nodeUrls = ((String)options.get(Options.NODE_URLS)).split(",");
        int n = stringArray.length;
        boolean bl = false;
        while (var9_15 < n) {
            String nodeUrl = stringArray[var9_15];
            String[] split = nodeUrl.split(":");
            if (split.length != 2) {
                throw new IllegalUrlPathException("Every node's URL must be in the format of `host:port`.");
            }
            if (!Utils.isNumeric(split[1])) {
                throw new IllegalUrlPathException(String.format("The port in url %s must be a number.", nodeUrl));
            }
            int port = Integer.parseInt(split[1]);
            if (port > 65535) {
                throw new IllegalUrlPathException(String.format("The port in url %s must be smaller than 65536", nodeUrl));
            }
            if (port < 1) {
                throw new IllegalUrlPathException(String.format("The port in url %s must be greater than 0.", nodeUrl));
            }
            ++var9_15;
        }
        Long lowerBound = (Long)options.get(Options.SCAN_BOUNDED_LOWER_BOUND);
        Long upperBound = (Long)options.get(Options.SCAN_BOUNDED_UPPER_BOUND);
        if (lowerBound > 0L && upperBound > 0L && upperBound < lowerBound) {
            throw new IllegalOptionException("The value of option `scan.bounded.lower-bound` could not be greater than the value of option `scan.bounded.upper-bound`.");
        }
        if (type == Type.SOURCE) {
            if (options.get(Options.MODE) == Options.Mode.CDC) {
                if (options.get(Options.CDC_TASK_NAME) == null) {
                    throw new IllegalOptionException("The option `cdc.task.name` is required when option `mode` equals `CDC`");
                }
                if (options.get(Options.PATTERN) == null) {
                    throw new IllegalOptionException("The option `cdc.pattern` is required when option `mode` equals `CDC`");
                }
            } else if (options.get(Options.MODE) == Options.Mode.BOUNDED) {
                if (options.get(Options.SQL) == null) {
                    throw new IllegalOptionException("The option `sql` is required when option `mode` equals `BOUNDED`");
                }
                String string = ((String)options.get(Options.SQL)).toLowerCase();
                if (!string.contains("select") || string.contains("count(") || string.contains("sum(") || string.contains("avg(") || string.contains("extreme(") || string.contains("max_value(") || string.contains("min_value(") || string.contains("first_value(") || string.contains("last_value(") || string.contains("max_time(") || string.contains("min_time(") || string.contains("max_by(") || string.contains("min_by(") || string.contains("stddev(") || string.contains("stddev_pop(") || string.contains("stddev_samp(") || string.contains("variance(") || string.contains("var_pop(") || string.contains("var_samp(") || string.contains("group") || string.contains("where") || string.contains("create") || string.contains("count") || string.contains("delete") || string.contains("show")) {
                    throw new IllegalOptionException("The option `sql` only supports basic query statements.");
                }
            }
        }
    }

    static {
        supportedDataTypes.add(DataTypes.INT());
        supportedDataTypes.add(DataTypes.BIGINT());
        supportedDataTypes.add(DataTypes.FLOAT());
        supportedDataTypes.add(DataTypes.DOUBLE());
        supportedDataTypes.add(DataTypes.BOOLEAN());
        supportedDataTypes.add(DataTypes.STRING());
    }

    private static enum Type {
        SINK,
        SOURCE;

    }
}

