/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.flink.sql.client;

import java.net.URI;
import java.nio.ByteBuffer;
import org.apache.iotdb.flink.sql.function.IoTDBCDCSourceFunction;
import org.apache.iotdb.flink.sql.wrapper.TabletWrapper;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBWebSocketClient
extends WebSocketClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBWebSocketClient.class);
    private final IoTDBCDCSourceFunction function;
    private transient Status status = Status.WAITING;

    public IoTDBWebSocketClient(URI uri, IoTDBCDCSourceFunction function) {
        super(uri);
        this.function = function;
    }

    public Status getStatus() {
        return this.status;
    }

    @Override
    public void onOpen(ServerHandshake serverHandshake) {
        String log = String.format("The connection with %s:%d has been created.", this.uri.getHost(), this.uri.getPort());
        LOGGER.info(log);
    }

    @Override
    public void onMessage(String s2) {
        if ("READY".equals(s2)) {
            this.status = Status.READY;
        } else if ("ERROR".equals(s2)) {
            this.status = Status.ERROR;
        }
    }

    @Override
    public void onMessage(ByteBuffer bytes) {
        super.onMessage(bytes);
        long commitId = bytes.getLong();
        Tablet tablet = Tablet.deserialize(bytes);
        this.function.addTabletWrapper(new TabletWrapper(commitId, this, tablet));
    }

    @Override
    public void onClose(int i, String s2, boolean b) {
        LOGGER.info("The connection to {}:{} has been closed. Because {}", this.uri.getHost(), this.uri.getPort(), s2);
    }

    @Override
    public void onError(Exception e) {
        String log = String.format("An error occurred when connecting to %s:%s: %s.", this.uri.getHost(), this.uri.getPort(), e.getMessage());
        LOGGER.error(log);
    }

    public static enum Status {
        WAITING,
        READY,
        ERROR;

    }
}

