/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.subscription.meta.topic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.rpc.subscription.config.TopicConfig;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TopicMeta {
    private String topicName;
    private long creationTime;
    private TopicConfig config;
    private Set<String> subscribedConsumerGroupIds;

    private TopicMeta() {
        this.config = new TopicConfig(new HashMap<String, String>());
        this.subscribedConsumerGroupIds = new HashSet<String>();
    }

    public TopicMeta(String topicName, long creationTime, Map<String, String> topicAttributes) {
        this.topicName = topicName;
        this.creationTime = creationTime;
        this.config = new TopicConfig(topicAttributes);
        this.subscribedConsumerGroupIds = new HashSet<String>();
    }

    public TopicMeta deepCopy() {
        TopicMeta copied = new TopicMeta();
        copied.topicName = this.topicName;
        copied.creationTime = this.creationTime;
        copied.config = new TopicConfig(new HashMap<String, String>(this.config.getAttribute()));
        copied.subscribedConsumerGroupIds = new HashSet<String>(this.subscribedConsumerGroupIds);
        return copied;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public TopicConfig getConfig() {
        return this.config;
    }

    public boolean addSubscribedConsumerGroup(String consumerGroupId) {
        return this.subscribedConsumerGroupIds.add(consumerGroupId);
    }

    public void removeSubscribedConsumerGroup(String consumerGroupId) {
        this.subscribedConsumerGroupIds.remove(consumerGroupId);
    }

    public Set<String> getSubscribedConsumerGroupIds() {
        return this.subscribedConsumerGroupIds;
    }

    public boolean isSubscribedByConsumerGroup(String consumerGroupId) {
        return this.subscribedConsumerGroupIds.contains(consumerGroupId);
    }

    public boolean hasSubscribedConsumerGroup() {
        return !this.subscribedConsumerGroupIds.isEmpty();
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);
        this.serialize(outputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
    }

    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write(this.topicName, outputStream);
        ReadWriteIOUtils.write(this.creationTime, outputStream);
        ReadWriteIOUtils.write(this.config.getAttribute().size(), outputStream);
        for (Map.Entry<String, String> entry : this.config.getAttribute().entrySet()) {
            ReadWriteIOUtils.write(entry.getKey(), outputStream);
            ReadWriteIOUtils.write(entry.getValue(), outputStream);
        }
        ReadWriteIOUtils.write(this.subscribedConsumerGroupIds.size(), outputStream);
        for (String subscribedConsumerGroupID : this.subscribedConsumerGroupIds) {
            ReadWriteIOUtils.write(subscribedConsumerGroupID, outputStream);
        }
    }

    public static TopicMeta deserialize(InputStream inputStream) throws IOException {
        int i;
        TopicMeta topicMeta = new TopicMeta();
        topicMeta.topicName = ReadWriteIOUtils.readString(inputStream);
        topicMeta.creationTime = ReadWriteIOUtils.readLong(inputStream);
        int size = ReadWriteIOUtils.readInt(inputStream);
        for (i = 0; i < size; ++i) {
            String key = ReadWriteIOUtils.readString(inputStream);
            String value = ReadWriteIOUtils.readString(inputStream);
            topicMeta.config.getAttribute().put(key, value);
        }
        size = ReadWriteIOUtils.readInt(inputStream);
        for (i = 0; i < size; ++i) {
            topicMeta.subscribedConsumerGroupIds.add(ReadWriteIOUtils.readString(inputStream));
        }
        return topicMeta;
    }

    public static TopicMeta deserialize(ByteBuffer byteBuffer) {
        int i;
        TopicMeta topicMeta = new TopicMeta();
        topicMeta.topicName = ReadWriteIOUtils.readString(byteBuffer);
        topicMeta.creationTime = ReadWriteIOUtils.readLong(byteBuffer);
        int size = ReadWriteIOUtils.readInt(byteBuffer);
        for (i = 0; i < size; ++i) {
            String key = ReadWriteIOUtils.readString(byteBuffer);
            String value = ReadWriteIOUtils.readString(byteBuffer);
            topicMeta.config.getAttribute().put(key, value);
        }
        size = ReadWriteIOUtils.readInt(byteBuffer);
        for (i = 0; i < size; ++i) {
            topicMeta.subscribedConsumerGroupIds.add(ReadWriteIOUtils.readString(byteBuffer));
        }
        return topicMeta;
    }

    public Map<String, String> generateExtractorAttributes() {
        HashMap<String, String> extractorAttributes = new HashMap<String, String>();
        extractorAttributes.put("source", "iotdb-source");
        extractorAttributes.put("inclusion", "data.insert");
        extractorAttributes.put("inclusion.exclusion", "data.delete");
        extractorAttributes.putAll(this.config.getAttributesWithSourcePathOrPattern());
        extractorAttributes.putAll(this.config.getAttributesWithTimeRange(this.creationTime));
        return extractorAttributes;
    }

    public Map<String, String> generateProcessorAttributes() {
        return this.config.getAttributesWithProcessorPrefix();
    }

    public Map<String, String> generateConnectorAttributes(String consumerGroupId) {
        HashMap<String, String> connectorAttributes = new HashMap<String, String>();
        connectorAttributes.put("sink", "subscription-sink");
        connectorAttributes.put("sink.topic", this.topicName);
        connectorAttributes.put("sink.consumer-group", consumerGroupId);
        return connectorAttributes;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TopicMeta that = (TopicMeta)obj;
        return this.creationTime == that.creationTime && Objects.equals(this.topicName, that.topicName) && Objects.equals(this.config, that.config) && Objects.equals(this.subscribedConsumerGroupIds, that.subscribedConsumerGroupIds);
    }

    public int hashCode() {
        return Objects.hash(this.topicName, this.creationTime, this.subscribedConsumerGroupIds, this.config);
    }

    public String toString() {
        return "TopicMeta{topicName='" + this.topicName + '\'' + ", creationTime=" + this.creationTime + ", config=" + this.config + ", subscribedConsumerGroupIds=" + this.subscribedConsumerGroupIds + '}';
    }
}

