/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.subscription.meta.consumer;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerGroupMeta;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ConsumerGroupMetaKeeper {
    private final Map<String, ConsumerGroupMeta> consumerGroupIdToConsumerGroupMetaMap = new ConcurrentHashMap<String, ConsumerGroupMeta>();
    private final ReentrantReadWriteLock consumerGroupMetaKeeperLock = new ReentrantReadWriteLock(true);

    public void acquireReadLock() {
        this.consumerGroupMetaKeeperLock.readLock().lock();
    }

    public void releaseReadLock() {
        this.consumerGroupMetaKeeperLock.readLock().unlock();
    }

    public void acquireWriteLock() {
        this.consumerGroupMetaKeeperLock.writeLock().lock();
    }

    public void releaseWriteLock() {
        this.consumerGroupMetaKeeperLock.writeLock().unlock();
    }

    public boolean containsConsumerGroupMeta(String consumerGroupId) {
        return this.consumerGroupIdToConsumerGroupMetaMap.containsKey(consumerGroupId);
    }

    public ConsumerGroupMeta getConsumerGroupMeta(String consumerGroupId) {
        return this.consumerGroupIdToConsumerGroupMetaMap.get(consumerGroupId);
    }

    public Iterable<ConsumerGroupMeta> getAllConsumerGroupMeta() {
        return this.consumerGroupIdToConsumerGroupMetaMap.values();
    }

    public Set<String> getConsumersSubscribingTopic(String consumerGroupId, String topic) {
        return this.consumerGroupIdToConsumerGroupMetaMap.containsKey(consumerGroupId) ? this.consumerGroupIdToConsumerGroupMetaMap.get(consumerGroupId).getConsumersSubscribingTopic(topic) : Collections.emptySet();
    }

    public Set<String> getTopicsSubscribedByConsumer(String consumerGroupId, String consumerId) {
        return this.consumerGroupIdToConsumerGroupMetaMap.containsKey(consumerGroupId) ? this.consumerGroupIdToConsumerGroupMetaMap.get(consumerGroupId).getTopicsSubscribedByConsumer(consumerId) : Collections.emptySet();
    }

    public void addConsumerGroupMeta(String consumerGroupId, ConsumerGroupMeta consumerGroupMeta) {
        this.consumerGroupIdToConsumerGroupMetaMap.put(consumerGroupId, consumerGroupMeta);
    }

    public void removeConsumerGroupMeta(String consumerGroupId) {
        this.consumerGroupIdToConsumerGroupMetaMap.remove(consumerGroupId);
    }

    public void clear() {
        this.consumerGroupIdToConsumerGroupMetaMap.clear();
    }

    public boolean isEmpty() {
        return this.consumerGroupIdToConsumerGroupMetaMap.isEmpty();
    }

    public void processTakeSnapshot(FileOutputStream fileOutputStream) throws IOException {
        ReadWriteIOUtils.write(this.consumerGroupIdToConsumerGroupMetaMap.size(), (OutputStream)fileOutputStream);
        for (Map.Entry<String, ConsumerGroupMeta> entry : this.consumerGroupIdToConsumerGroupMetaMap.entrySet()) {
            ReadWriteIOUtils.write(entry.getKey(), (OutputStream)fileOutputStream);
            entry.getValue().serialize(fileOutputStream);
        }
    }

    public void processLoadSnapshot(FileInputStream fileInputStream) throws IOException {
        this.clear();
        int size = ReadWriteIOUtils.readInt(fileInputStream);
        for (int i = 0; i < size; ++i) {
            String topicName = ReadWriteIOUtils.readString(fileInputStream);
            this.consumerGroupIdToConsumerGroupMetaMap.put(topicName, ConsumerGroupMeta.deserialize(fileInputStream));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumerGroupMetaKeeper that = (ConsumerGroupMetaKeeper)o;
        return Objects.equals(this.consumerGroupIdToConsumerGroupMetaMap, that.consumerGroupIdToConsumerGroupMetaMap);
    }

    public int hashCode() {
        return Objects.hash(this.consumerGroupIdToConsumerGroupMetaMap);
    }

    public String toString() {
        return "ConsumerGroupMetaKeeper{consumerGroupIDToConsumerGroupMetaMap=" + this.consumerGroupIdToConsumerGroupMetaMap + '}';
    }
}

