/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.subscription.meta.consumer;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerMeta;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ConsumerGroupMeta {
    private String consumerGroupId;
    private long creationTime;
    private Map<String, Set<String>> topicNameToSubscribedConsumerIdSet = new HashMap<String, Set<String>>();
    private Map<String, ConsumerMeta> consumerIdToConsumerMeta = new HashMap<String, ConsumerMeta>();

    public ConsumerGroupMeta() {
    }

    public ConsumerGroupMeta(String consumerGroupId, long creationTime, ConsumerMeta firstConsumerMeta) {
        this.consumerGroupId = consumerGroupId;
        this.creationTime = creationTime;
        this.topicNameToSubscribedConsumerIdSet = new HashMap<String, Set<String>>();
        this.consumerIdToConsumerMeta = new HashMap<String, ConsumerMeta>();
        this.consumerIdToConsumerMeta.put(firstConsumerMeta.getConsumerId(), firstConsumerMeta);
    }

    public ConsumerGroupMeta deepCopy() {
        ConsumerGroupMeta copied = new ConsumerGroupMeta();
        copied.consumerGroupId = this.consumerGroupId;
        copied.creationTime = this.creationTime;
        copied.topicNameToSubscribedConsumerIdSet = new HashMap<String, Set<String>>(this.topicNameToSubscribedConsumerIdSet);
        copied.consumerIdToConsumerMeta = new HashMap<String, ConsumerMeta>(this.consumerIdToConsumerMeta);
        return copied;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void addConsumer(ConsumerMeta consumerMeta) {
        this.consumerIdToConsumerMeta.put(consumerMeta.getConsumerId(), consumerMeta);
    }

    public void removeConsumer(String consumerId) {
        this.consumerIdToConsumerMeta.remove(consumerId);
        for (Set<String> subscribedConsumers : this.topicNameToSubscribedConsumerIdSet.values()) {
            subscribedConsumers.remove(consumerId);
        }
    }

    public boolean containsConsumer(String consumerId) {
        return this.consumerIdToConsumerMeta.containsKey(consumerId);
    }

    public boolean isEmpty() {
        return this.consumerIdToConsumerMeta.isEmpty();
    }

    public Set<String> getConsumersSubscribingTopic(String topic) {
        return this.topicNameToSubscribedConsumerIdSet.getOrDefault(topic, Collections.emptySet());
    }

    public Set<String> getTopicsSubscribedByConsumer(String consumerId) {
        HashSet<String> topics = new HashSet<String>();
        for (Map.Entry<String, Set<String>> topicNameToSubscribedConsumerId : this.topicNameToSubscribedConsumerIdSet.entrySet()) {
            if (!topicNameToSubscribedConsumerId.getValue().contains(consumerId)) continue;
            topics.add(topicNameToSubscribedConsumerId.getKey());
        }
        return topics;
    }

    public void addSubscription(String consumerId, Set<String> topics) {
        if (!this.consumerIdToConsumerMeta.containsKey(consumerId)) {
            throw new SubscriptionException(String.format("Failed to add subscription to consumer group meta: consumer %s does not exist in consumer group %s", consumerId, this.consumerGroupId));
        }
        for (String topic : topics) {
            this.topicNameToSubscribedConsumerIdSet.computeIfAbsent(topic, k -> new HashSet()).add(consumerId);
        }
    }

    public Set<String> removeSubscription(String consumerId, Set<String> topics) {
        if (!this.consumerIdToConsumerMeta.containsKey(consumerId)) {
            throw new SubscriptionException(String.format("Failed to remove subscription from consumer group meta: consumer %s does not exist in consumer group %s", consumerId, this.consumerGroupId));
        }
        HashSet<String> noSubscriptionTopicAfterRemoval = new HashSet<String>();
        for (String topic : topics) {
            if (!this.topicNameToSubscribedConsumerIdSet.containsKey(topic)) continue;
            this.topicNameToSubscribedConsumerIdSet.get(topic).remove(consumerId);
            if (!this.topicNameToSubscribedConsumerIdSet.get(topic).isEmpty()) continue;
            noSubscriptionTopicAfterRemoval.add(topic);
            this.topicNameToSubscribedConsumerIdSet.remove(topic);
        }
        return noSubscriptionTopicAfterRemoval;
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);
        this.serialize(outputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
    }

    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write(this.consumerGroupId, outputStream);
        ReadWriteIOUtils.write(this.creationTime, outputStream);
        ReadWriteIOUtils.write(this.topicNameToSubscribedConsumerIdSet.size(), outputStream);
        for (Map.Entry<String, Set<String>> entry : this.topicNameToSubscribedConsumerIdSet.entrySet()) {
            ReadWriteIOUtils.write(entry.getKey(), outputStream);
            ReadWriteIOUtils.write(entry.getValue().size(), outputStream);
            for (String id : entry.getValue()) {
                ReadWriteIOUtils.write(id, outputStream);
            }
        }
        ReadWriteIOUtils.write(this.consumerIdToConsumerMeta.size(), outputStream);
        for (Map.Entry<String, Object> entry : this.consumerIdToConsumerMeta.entrySet()) {
            ReadWriteIOUtils.write(entry.getKey(), outputStream);
            ((ConsumerMeta)entry.getValue()).serialize(outputStream);
        }
    }

    public static ConsumerGroupMeta deserialize(InputStream inputStream) throws IOException {
        Object value;
        String key;
        int i;
        ConsumerGroupMeta consumerGroupMeta = new ConsumerGroupMeta();
        consumerGroupMeta.consumerGroupId = ReadWriteIOUtils.readString(inputStream);
        consumerGroupMeta.creationTime = ReadWriteIOUtils.readLong(inputStream);
        consumerGroupMeta.topicNameToSubscribedConsumerIdSet = new HashMap<String, Set<String>>();
        int size = ReadWriteIOUtils.readInt(inputStream);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString(inputStream);
            value = new HashSet<String>();
            int innerSize = ReadWriteIOUtils.readInt(inputStream);
            for (int j = 0; j < innerSize; ++j) {
                value.add(ReadWriteIOUtils.readString(inputStream));
            }
            consumerGroupMeta.topicNameToSubscribedConsumerIdSet.put(key, (Set<String>)value);
        }
        consumerGroupMeta.consumerIdToConsumerMeta = new HashMap<String, ConsumerMeta>();
        size = ReadWriteIOUtils.readInt(inputStream);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString(inputStream);
            value = ConsumerMeta.deserialize(inputStream);
            consumerGroupMeta.consumerIdToConsumerMeta.put(key, (ConsumerMeta)value);
        }
        return consumerGroupMeta;
    }

    public static ConsumerGroupMeta deserialize(ByteBuffer byteBuffer) {
        Object value;
        String key;
        int i;
        ConsumerGroupMeta consumerGroupMeta = new ConsumerGroupMeta();
        consumerGroupMeta.consumerGroupId = ReadWriteIOUtils.readString(byteBuffer);
        consumerGroupMeta.creationTime = ReadWriteIOUtils.readLong(byteBuffer);
        consumerGroupMeta.topicNameToSubscribedConsumerIdSet = new HashMap<String, Set<String>>();
        int size = ReadWriteIOUtils.readInt(byteBuffer);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString(byteBuffer);
            value = new HashSet<String>();
            int innerSize = ReadWriteIOUtils.readInt(byteBuffer);
            for (int j = 0; j < innerSize; ++j) {
                value.add(ReadWriteIOUtils.readString(byteBuffer));
            }
            consumerGroupMeta.topicNameToSubscribedConsumerIdSet.put(key, (Set<String>)value);
        }
        consumerGroupMeta.consumerIdToConsumerMeta = new HashMap<String, ConsumerMeta>();
        size = ReadWriteIOUtils.readInt(byteBuffer);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString(byteBuffer);
            value = ConsumerMeta.deserialize(byteBuffer);
            consumerGroupMeta.consumerIdToConsumerMeta.put(key, (ConsumerMeta)value);
        }
        return consumerGroupMeta;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConsumerGroupMeta that = (ConsumerGroupMeta)obj;
        return Objects.equals(this.consumerGroupId, that.consumerGroupId) && this.creationTime == that.creationTime && Objects.equals(this.topicNameToSubscribedConsumerIdSet, that.topicNameToSubscribedConsumerIdSet) && Objects.equals(this.consumerIdToConsumerMeta, that.consumerIdToConsumerMeta);
    }

    public int hashCode() {
        return Objects.hash(this.consumerGroupId, this.creationTime, this.topicNameToSubscribedConsumerIdSet, this.consumerIdToConsumerMeta);
    }

    public String toString() {
        return "ConsumerGroupMeta{consumerGroupId='" + this.consumerGroupId + "', creationTime=" + this.creationTime + ", topicNameToSubscribedConsumerIdSet=" + this.topicNameToSubscribedConsumerIdSet + ", consumerIdToConsumerMeta=" + this.consumerIdToConsumerMeta + "}";
    }
}

