/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.task.subtask;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.execution.scheduler.PipeSubtaskScheduler;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeSubtask
implements FutureCallback<Boolean>,
Callable<Boolean>,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeSubtask.class);
    protected final String taskID;
    protected long creationTime;
    protected ListeningExecutorService subtaskWorkerThreadPoolExecutor;
    protected final AtomicBoolean shouldStopSubmittingSelf = new AtomicBoolean(true);
    protected final AtomicBoolean isClosed = new AtomicBoolean(false);
    protected PipeSubtaskScheduler subtaskScheduler;
    public static final int MAX_RETRY_TIMES = 5;
    protected final AtomicInteger retryCount = new AtomicInteger(0);
    protected Event lastEvent;

    protected PipeSubtask(String taskID, long creationTime) {
        this.taskID = taskID;
        this.creationTime = creationTime;
    }

    public abstract void bindExecutors(ListeningExecutorService var1, ExecutorService var2, PipeSubtaskScheduler var3);

    @Override
    public Boolean call() throws Exception {
        boolean hasAtLeastOneEventProcessed = false;
        try {
            while (this.subtaskScheduler.schedule()) {
                if (!this.executeOnce()) {
                    break;
                }
                hasAtLeastOneEventProcessed = true;
            }
        }
        finally {
            this.subtaskScheduler.reset();
        }
        return hasAtLeastOneEventProcessed;
    }

    protected synchronized void setLastEvent(Event event) {
        this.lastEvent = event;
    }

    protected abstract boolean executeOnce() throws Exception;

    @Override
    public synchronized void onSuccess(Boolean hasAtLeastOneEventProcessed) {
        int totalRetryCount = this.retryCount.getAndSet(0);
        this.submitSelf();
        if (totalRetryCount != 0) {
            LOGGER.warn("Successfully executed subtask {}({}) after {} retries.", this.taskID, this.getClass().getSimpleName(), totalRetryCount);
        }
    }

    public abstract void submitSelf();

    public void allowSubmittingSelf() {
        this.retryCount.set(0);
        this.shouldStopSubmittingSelf.set(false);
    }

    public boolean disallowSubmittingSelf() {
        return !this.shouldStopSubmittingSelf.getAndSet(true);
    }

    public boolean isSubmittingSelf() {
        return !this.shouldStopSubmittingSelf.get();
    }

    @Override
    public void close() {
        this.clearReferenceCountAndReleaseLastEvent();
    }

    protected synchronized void decreaseReferenceCountAndReleaseLastEvent(boolean shouldReport) {
        if (this.lastEvent != null) {
            if (this.lastEvent instanceof EnrichedEvent) {
                ((EnrichedEvent)this.lastEvent).decreaseReferenceCount(PipeSubtask.class.getName(), shouldReport);
            }
            this.lastEvent = null;
        }
    }

    protected synchronized void clearReferenceCountAndReleaseLastEvent() {
        if (this.lastEvent != null) {
            if (this.lastEvent instanceof EnrichedEvent) {
                ((EnrichedEvent)this.lastEvent).clearReferenceCount(PipeSubtask.class.getName());
            }
            this.lastEvent = null;
        }
    }

    public String getTaskID() {
        return this.taskID;
    }

    public long getCreationTime() {
        return this.creationTime;
    }
}

