/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.task.subtask;

import org.apache.iotdb.commons.exception.pipe.PipeRuntimeConnectorRetryTimesConfigurableException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.task.subtask.PipeSubtask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeReportableSubtask
extends PipeSubtask {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeReportableSubtask.class);

    protected PipeReportableSubtask(String taskID, long creationTime) {
        super(taskID, creationTime);
    }

    @Override
    public synchronized void onFailure(Throwable throwable) {
        if (this.isClosed.get()) {
            LOGGER.info("onFailure in pipe subtask, ignored because pipe is dropped.", throwable);
            this.clearReferenceCountAndReleaseLastEvent();
            return;
        }
        if (this.lastEvent instanceof EnrichedEvent) {
            this.onEnrichedEventFailure(throwable);
        } else {
            this.onNonEnrichedEventFailure(throwable);
        }
    }

    private void onEnrichedEventFailure(Throwable throwable) {
        int maxRetryTimes;
        int n = maxRetryTimes = throwable instanceof PipeRuntimeConnectorRetryTimesConfigurableException ? ((PipeRuntimeConnectorRetryTimesConfigurableException)throwable).getRetryTimes() : 5;
        if (this.retryCount.get() == 0) {
            LOGGER.warn("Failed to execute subtask {} (creation time: {}, simple class: {}), because of {}. Will retry for {} times.", this.taskID, this.creationTime, this.getClass().getSimpleName(), throwable.getMessage(), maxRetryTimes, throwable);
        }
        this.retryCount.incrementAndGet();
        if (this.retryCount.get() <= 5) {
            LOGGER.warn("Retry executing subtask {} (creation time: {}, simple class: {}), retry count [{}/{}]", this.taskID, this.creationTime, this.getClass().getSimpleName(), this.retryCount.get(), maxRetryTimes);
            try {
                Thread.sleep(Math.min(1000L * (long)this.retryCount.get(), 10000L));
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted when retrying to execute subtask {} (creation time: {}, simple class: {})", this.taskID, this.creationTime, this.getClass().getSimpleName(), e);
                Thread.currentThread().interrupt();
            }
            this.submitSelf();
        } else {
            String errorMessage = String.format("Failed to execute subtask %s (creation time: %s, simple class: %s), retry count exceeds the max retry times %d, last exception: %s, root cause: %s", this.taskID, this.creationTime, this.getClass().getSimpleName(), this.retryCount.get(), throwable.getMessage(), this.getRootCause(throwable));
            LOGGER.warn(errorMessage, throwable);
            this.report((EnrichedEvent)this.lastEvent, throwable instanceof PipeRuntimeException ? (PipeRuntimeException)throwable : new PipeRuntimeCriticalException(errorMessage));
            LOGGER.warn("The last event is an instance of EnrichedEvent, so the exception is reported. Stopping current pipe subtask {} (creation time: {}, simple class: {}) locally... Status shown when query the pipe will be 'STOPPED'. Please restart the task by executing 'START PIPE' manually if needed.", this.taskID, this.creationTime, this.getClass().getSimpleName(), throwable);
        }
    }

    protected abstract String getRootCause(Throwable var1);

    protected abstract void report(EnrichedEvent var1, PipeRuntimeException var2);

    private void onNonEnrichedEventFailure(Throwable throwable) {
        if (this.retryCount.get() == 0) {
            LOGGER.warn("Failed to execute subtask {} (creation time: {}, simple class: {}), because of {}. Will retry forever.", this.taskID, this.creationTime, this.getClass().getSimpleName(), throwable.getMessage(), throwable);
        }
        this.retryCount.incrementAndGet();
        LOGGER.warn("Retry executing subtask {} (creation time: {}, simple class: {}), retry count {}", this.taskID, this.creationTime, this.getClass().getSimpleName(), this.retryCount.get());
        try {
            Thread.sleep(Math.min(1000L * (long)this.retryCount.get(), 10000L));
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted when retrying to execute subtask {} (creation time: {}, simple class: {})", this.taskID, this.creationTime, this.getClass().getSimpleName());
            Thread.currentThread().interrupt();
        }
        this.submitSelf();
    }
}

